/*
 * Decompiled with CFR 0.152.
 */
package org.sitemesh.webapp.contentfilter.io;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.CharBuffer;
import javax.servlet.ServletOutputStream;
import org.sitemesh.webapp.contentfilter.io.ByteBufferBuilder;
import org.sitemesh.webapp.contentfilter.io.TextEncoder;

public class Buffer {
    private final String encoding;
    private static final CharBuffer EMPTY_BUFFER = CharBuffer.allocate(0);
    private CharArrayWriter bufferedWriter;
    private ByteBufferBuilder byteBufferBuilder;
    private PrintWriter exposedWriter;
    private ServletOutputStream exposedStream;

    public Buffer(String encoding) {
        this.encoding = encoding;
    }

    public PrintWriter getWriter() {
        if (this.bufferedWriter == null) {
            if (this.byteBufferBuilder != null) {
                throw new IllegalStateException("response.getWriter() called after response.getOutputStream()");
            }
            this.bufferedWriter = new CharArrayWriter(128);
            this.exposedWriter = new PrintWriter(this.bufferedWriter);
        }
        return this.exposedWriter;
    }

    public ServletOutputStream getOutputStream() {
        if (this.byteBufferBuilder == null) {
            if (this.bufferedWriter != null) {
                throw new IllegalStateException("response.getOutputStream() called after response.getWriter()");
            }
            this.byteBufferBuilder = new ByteBufferBuilder();
            this.exposedStream = new ServletOutputStream(){

                public void write(int b) {
                    Buffer.this.byteBufferBuilder.write(b);
                }

                public void write(byte[] b, int off, int len) throws IOException {
                    Buffer.this.byteBufferBuilder.write(b, off, len);
                }
            };
        }
        return this.exposedStream;
    }

    public boolean isUsingStream() {
        return this.byteBufferBuilder != null;
    }

    public CharBuffer toCharBuffer() throws IOException {
        if (this.bufferedWriter != null) {
            return CharBuffer.wrap(this.bufferedWriter.toCharArray());
        }
        if (this.byteBufferBuilder != null) {
            return TextEncoder.encode(this.byteBufferBuilder.toByteBuffer(), this.encoding);
        }
        return EMPTY_BUFFER;
    }

    public String toString() {
        try {
            return this.toCharBuffer().toString();
        }
        catch (IOException e) {
            return e.getMessage();
        }
    }
}

