/*
 * Decompiled with CFR 0.152.
 */
package org.sitemesh.webapp;

import java.io.IOException;
import java.nio.CharBuffer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.sitemesh.DecoratorSelector;
import org.sitemesh.content.Content;
import org.sitemesh.content.ContentProcessor;
import org.sitemesh.webapp.WebAppContext;
import org.sitemesh.webapp.contentfilter.ContentBufferingFilter;
import org.sitemesh.webapp.contentfilter.ResponseMetaData;
import org.sitemesh.webapp.contentfilter.Selector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SiteMeshFilter
extends ContentBufferingFilter {
    private final ContentProcessor contentProcessor;
    private final DecoratorSelector<WebAppContext> decoratorSelector;

    public SiteMeshFilter(Selector selector, ContentProcessor contentProcessor, DecoratorSelector<WebAppContext> decoratorSelector) {
        super(selector);
        if (contentProcessor == null) {
            throw new IllegalArgumentException("contentProcessor cannot be null");
        }
        if (decoratorSelector == null) {
            throw new IllegalArgumentException("decoratorSelector cannot be null");
        }
        this.contentProcessor = contentProcessor;
        this.decoratorSelector = decoratorSelector;
    }

    @Override
    protected boolean postProcess(String contentType, CharBuffer buffer, HttpServletRequest request, HttpServletResponse response, ResponseMetaData metaData) throws IOException, ServletException {
        String[] decoratorPaths;
        WebAppContext context = this.createContext(contentType, request, response, metaData);
        Content content = this.contentProcessor.build(buffer, context);
        if (content == null) {
            return false;
        }
        for (String decoratorPath : decoratorPaths = this.decoratorSelector.selectDecoratorPaths(content, context)) {
            content = context.decorate(decoratorPath, content);
        }
        if (content == null) {
            return false;
        }
        content.getData().writeValueTo(response.getWriter());
        return true;
    }

    protected WebAppContext createContext(String contentType, HttpServletRequest request, HttpServletResponse response, ResponseMetaData metaData) {
        return new WebAppContext(contentType, request, response, this.getFilterConfig().getServletContext(), this.contentProcessor, metaData);
    }
}

