/*
 * Decompiled with CFR 0.152.
 */
package org.sitemesh.content.tagrules;

import java.io.IOException;
import java.nio.CharBuffer;
import org.sitemesh.SiteMeshContext;
import org.sitemesh.content.Content;
import org.sitemesh.content.ContentProcessor;
import org.sitemesh.content.memory.InMemoryContent;
import org.sitemesh.content.tagrules.TagRuleBundle;
import org.sitemesh.tagprocessor.TagProcessor;

public class TagBasedContentProcessor
implements ContentProcessor {
    private final TagRuleBundle[] tagRuleBundles;

    public TagBasedContentProcessor(TagRuleBundle ... tagRuleBundles) {
        this.tagRuleBundles = (TagRuleBundle[])tagRuleBundles.clone();
    }

    public Content build(CharBuffer data, SiteMeshContext siteMeshContext) throws IOException {
        InMemoryContent content = new InMemoryContent();
        content.getData().setValue(data);
        TagProcessor processor = new TagProcessor(data);
        for (TagRuleBundle tagRuleBundle : this.tagRuleBundles) {
            tagRuleBundle.install(processor.defaultState(), content.getExtractedProperties(), siteMeshContext);
        }
        processor.process();
        content.getExtractedProperties().setValue(processor.getDefaultBufferContents());
        for (TagRuleBundle tagRuleBundle : this.tagRuleBundles) {
            tagRuleBundle.cleanUp(processor.defaultState(), content.getExtractedProperties(), siteMeshContext);
        }
        return content;
    }

    public TagRuleBundle[] getTagRuleBundles() {
        return (TagRuleBundle[])this.tagRuleBundles.clone();
    }
}

