/*
 * Decompiled with CFR 0.152.
 */
package org.sitemesh.config.properties;

import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PropertiesParser {
    private final Map<String, String> properties;

    PropertiesParser(Map<String, String> properties) {
        this.properties = properties;
    }

    String getString(String ... keysToSearch) {
        for (String key : keysToSearch) {
            String string = this.properties.get(key);
            if (string == null || (string = string.trim()).length() <= 0) continue;
            return string;
        }
        return null;
    }

    String[] getStringArray(String key) {
        String string = this.getString(key);
        if (string == null) {
            return new String[0];
        }
        String[] result = string.split("[,\\s]+");
        for (int i = 0; i < result.length; ++i) {
            result[i] = result[i].trim();
        }
        return result;
    }

    Map<String, String[]> getStringMultiMap(String key) {
        LinkedHashMap<String, String[]> result = new LinkedHashMap<String, String[]>();
        String[] entries = this.getStringArray(key);
        if (entries != null) {
            for (String entry : entries) {
                String[] split = entry.split("=", 2);
                if (split.length != 2) continue;
                String itemKey = split[0];
                String[] itemValue = split[1].split("\\|");
                result.put(itemKey, itemValue);
            }
        }
        return result;
    }
}

