<%@ page contentType="text/html;charset=UTF-8" language="java" %>
<%@ page import="java.sql.Connection" %>
<%@ page import="java.util.*" %>
<%@ page import="com.censoft.common.db.ConnectionFactory" %>
<%@ page import="com.censoft.common.base.Pub" %>
<%@ page import="com.censoft.db.Logger" %>
<%@ page import="java.text.DateFormat" %>
<%@ page import="java.text.SimpleDateFormat" %>
<%@ page import="java.text.ParseException" %>
<%!
    public static List<String> getDays(String startTime, String endTime) {
        // 返回的日期集合
        List<String> days = new ArrayList<String>();
        DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        try {
            Date start = dateFormat.parse(startTime);
            Date end = dateFormat.parse(endTime);

            Calendar tempStart = Calendar.getInstance();
            tempStart.setTime(start);

            Calendar tempEnd = Calendar.getInstance();
            tempEnd.setTime(end);
            tempEnd.add(Calendar.DATE, +1);// 日期加1(包含结束)
            while (tempStart.before(tempEnd)) {
                days.add(dateFormat.format(tempStart.getTime()));
                tempStart.add(Calendar.DAY_OF_YEAR, 1);
            }
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return days;
    }
    public static String getBeforeDay(String specifiedDay)
    {
        Calendar c = Calendar.getInstance();
        Date date = null;
        try
        {
            date = new SimpleDateFormat("yyyy-MM-dd").parse(specifiedDay);
        }
        catch (ParseException e)
        {
            e.printStackTrace();
        }
        c.setTime(date);
        int day = c.get(Calendar.DATE);
        c.set(Calendar.DATE, day - 1);
        String dayBefore = new SimpleDateFormat("yyyy-MM-dd").format(c.getTime());
        return dayBefore;
    }
%>
<%
    ConnectionFactory cf = new ConnectionFactory();
    Pub pub = new Pub();
    Connection conn = null;
    Enumeration enu = request.getParameterNames();
    String action = pub.trimNull(request.getParameter("action"));
    String action_msg="";
    String id = pub.trimNull(request.getParameter("id"));
    String h_id = pub.trimNull(request.getParameter("h_id"));
    if("".equals(h_id)){
        h_id=UUID.randomUUID().toString().trim().replaceAll("-", "");
    }
    String name = pub.trimNull(request.getParameter("name"));
    String h_day = pub.trimNull(request.getParameter("h_day"));
    String b_time = pub.trimNull(request.getParameter("b_time"));
    String e_time = pub.trimNull(request.getParameter("e_time"));
    List<String> list=null;
    if(!"".equals(b_time)&&!"".equals(e_time)){
        list= getDays(b_time,e_time);//获取两个时间点之间的日期
    }

    String add_user = pub.trimNull((String) session.getAttribute("session_login_id"));
    if ("".equals(add_user)) {
        System.out.println("当前没有用户信息");
    }
    String add_time = pub.getCurrentServerTime();
    StringBuffer sql_add=new StringBuffer("insert into zb_holiday (h_id,name,h_day,day,add_user,add_time) values (?,?,?,?,?,?)");
    StringBuffer sql_update=new StringBuffer("update zb_holiday set update_user=?,update_time=?,name=?,day=? where id=?");
    try {
        conn = com.censoft.db.DBUtil.getConnection();
        conn.setAutoCommit(false);
        boolean is_oper = false;
        if("add".equals(action)){
            action_msg="新增";
            if(list!=null){
                for(int i=0;i<list.size();i++){
                    is_oper = cf.executeUpdate(conn, sql_add.toString(), new Object[]{h_id,name,h_day,list.get(i),add_user,add_time});
                    if (!is_oper) {
                        conn.rollback();
                        System.out.println("新增节假日表出错了" + cf.getMsg());
                        return;
                    }
                }
            }else{
                is_oper = cf.executeUpdate(conn, sql_add.toString(), new Object[]{h_id,name,h_day,"",add_user,add_time});
                if (!is_oper) {
                    conn.rollback();
                    System.out.println("新增节假日表出错了" + cf.getMsg());
                    return;
                }
            }
        }else if("delete".equals(action)){
            action_msg="删除";
            is_oper = cf.executeUpdate(conn, "delete from zb_holiday where h_id=?",new Object[]{id});
            if (!is_oper) {
                conn.rollback();
                System.out.println("删除节假日表出错了" + cf.getMsg());
                return;
            }
        }else{
            action_msg="修改";
            is_oper = cf.executeUpdate(conn, "delete from zb_holiday where h_id=?",new Object[]{id});
            if (!is_oper) {
                conn.rollback();
                System.out.println("删除节假日表出错了" + cf.getMsg());
                return;
            }
            if(list!=null){
                for(int i=0;i<list.size();i++){
                    is_oper = cf.executeUpdate(conn, sql_add.toString(), new Object[]{h_id,name,h_day,list.get(i),add_user,add_time});
                    if (!is_oper) {
                        conn.rollback();
                        System.out.println("新增节假日表出错了" + cf.getMsg());
                        return;
                    }
                }
            }else{
                is_oper = cf.executeUpdate(conn, sql_add.toString(), new Object[]{h_id,name,h_day,"",add_user,add_time});
                if (!is_oper) {
                    conn.rollback();
                    System.out.println("新增节假日表出错了" + cf.getMsg());
                    return;
                }
            }
        }
        if (!is_oper) {
            conn.rollback();
            System.out.println("操作出错了" + cf.getMsg());
            return;
        }
        Logger.log(conn, "节假日管理",action_msg,  add_user, "", request);
        conn.commit();
        if (!is_oper) {
            conn.rollback();
            out.println(cf.getMsg());
        } else {
            out.println("success,"+id);
        }
    } catch (Exception e) {
        conn.rollback();
        System.out.println("有异常" + e);
        return;
    } finally {
        if (conn != null) {
            conn.setAutoCommit(true);
            try {
                conn.close();
            } catch (Exception e) {
            }
        }
    }
%>
