/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.trading.util;

public class MessageQueue {
    private boolean m_deactivated = false;
    private Element m_head = null;
    private Element m_tail = null;

    public synchronized void deactivate() {
        this.m_deactivated = true;
        this.notifyAll();
    }

    public synchronized boolean getDeactivated() {
        return this.m_deactivated;
    }

    public synchronized boolean getEmpty() {
        return this.m_head == null;
    }

    public synchronized void enqueue(Object object) {
        Element element = new Element(object);
        if (this.m_tail == null) {
            this.m_head = this.m_tail = element;
        } else {
            this.m_tail.next = element;
            this.m_tail = element;
        }
        this.notifyAll();
    }

    public synchronized Object dequeue() {
        Object object = null;
        while (object == null && !this.m_deactivated) {
            if (this.m_head == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            object = this.m_head.value;
            this.m_head = this.m_head.next;
            if (this.m_head != null) continue;
            this.m_tail = null;
        }
        return object;
    }

    private static class Element {
        public Object value;
        public Element next;

        public Element(Object object) {
            this.value = object;
            this.next = null;
        }
    }
}

