/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.trading;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Properties;
import org.jacorb.config.Configuration;
import org.jacorb.trading.db.DatabaseMgr;
import org.jacorb.trading.db.OfferDatabase;
import org.jacorb.trading.db.TypeDatabase;
import org.jacorb.trading.db.simple.SimpleDatabaseMgr;
import org.jacorb.trading.impl.AdminImpl;
import org.jacorb.trading.impl.ImportAttrib;
import org.jacorb.trading.impl.LinkAttrib;
import org.jacorb.trading.impl.LinkImpl;
import org.jacorb.trading.impl.LookupImpl;
import org.jacorb.trading.impl.ProxyImpl;
import org.jacorb.trading.impl.RegisterImpl;
import org.jacorb.trading.impl.RepositoryImpl;
import org.jacorb.trading.impl.SupportAttrib;
import org.jacorb.trading.impl.TraderComp;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.Repository;
import org.omg.CORBA.RepositoryHelper;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.UserException;
import org.omg.CosTrading.AdminHelper;
import org.omg.CosTrading.FollowOption;
import org.omg.CosTrading.LinkHelper;
import org.omg.CosTrading.LookupHelper;
import org.omg.CosTrading.ProxyHelper;
import org.omg.CosTrading.RegisterHelper;
import org.omg.PortableServer.IdAssignmentPolicyValue;
import org.omg.PortableServer.LifespanPolicyValue;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.omg.PortableServer.RequestProcessingPolicyValue;

public class TradingService {
    private static final String s_defaultDbpath = "db";
    private static Configuration configuration = null;
    private static ORB orb;

    protected TradingService() {
    }

    public static ORB getORB() {
        return orb;
    }

    public TradingService(DatabaseMgr databaseMgr, String string) throws Exception {
        Repository repository = null;
        Object object = null;
        try {
            object = orb.resolve_initial_references("InterfaceRepository");
        }
        catch (Exception exception) {
            // empty catch block
        }
        POA pOA = null;
        try {
            pOA = POAHelper.narrow(orb.resolve_initial_references("RootPOA"));
            pOA.the_POAManager().activate();
            if (object != null) {
                repository = RepositoryHelper.narrow(object);
            }
        }
        catch (InvalidName invalidName) {
        }
        catch (SystemException systemException) {
        }
        catch (UserException userException) {
            // empty catch block
        }
        Policy[] policyArray = new Policy[]{pOA.create_id_assignment_policy(IdAssignmentPolicyValue.USER_ID), pOA.create_lifespan_policy(LifespanPolicyValue.PERSISTENT), pOA.create_request_processing_policy(RequestProcessingPolicyValue.USE_SERVANT_MANAGER)};
        POA pOA2 = pOA.create_POA("Trader-POA", pOA.the_POAManager(), policyArray);
        OfferDatabase offerDatabase = databaseMgr.getOfferDatabase();
        TypeDatabase typeDatabase = databaseMgr.getTypeDatabase();
        RepositoryImpl repositoryImpl = new RepositoryImpl(typeDatabase, repository);
        pOA2.activate_object_with_id("Repository".getBytes(), repositoryImpl);
        SupportAttrib supportAttrib = new SupportAttrib();
        supportAttrib.setModifiableProperties(this.getProperty("jtrader.modifiable_properties", true));
        supportAttrib.setDynamicProperties(this.getProperty("jtrader.dynamic_properties", true));
        supportAttrib.setProxyOffers(this.getProperty("jtrader.proxy_offers", true));
        supportAttrib.setTypeRepos(pOA2.servant_to_reference(repositoryImpl));
        ImportAttrib importAttrib = new ImportAttrib();
        importAttrib.setDefSearchCard(this.getProperty("jtrader.def_search_card", Integer.MAX_VALUE));
        importAttrib.setMaxSearchCard(this.getProperty("jtrader.max_search_card", Integer.MAX_VALUE));
        importAttrib.setDefMatchCard(this.getProperty("jtrader.def_match_card", Integer.MAX_VALUE));
        importAttrib.setMaxMatchCard(this.getProperty("jtrader.max_match_card", Integer.MAX_VALUE));
        importAttrib.setDefReturnCard(this.getProperty("jtrader.def_return_card", Integer.MAX_VALUE));
        importAttrib.setMaxReturnCard(this.getProperty("jtrader.max_return_card", Integer.MAX_VALUE));
        importAttrib.setMaxList(this.getProperty("jtrader.max_list", Integer.MAX_VALUE));
        importAttrib.setDefHopCount(this.getProperty("jtrader.def_hop_count", Integer.MAX_VALUE));
        importAttrib.setMaxHopCount(this.getProperty("jtrader.max_hop_count", Integer.MAX_VALUE));
        importAttrib.setDefFollowPolicy(this.getProperty("jtrader.def_follow_policy", FollowOption.always));
        importAttrib.setMaxFollowPolicy(this.getProperty("jtrader.max_follow_policy", FollowOption.always));
        LinkAttrib linkAttrib = new LinkAttrib();
        linkAttrib.setMaxLinkFollowPolicy(this.getProperty("jtrader.max_link_follow_policy", FollowOption.always));
        TraderComp traderComp = new TraderComp();
        RegisterImpl registerImpl = new RegisterImpl(traderComp, supportAttrib, offerDatabase, repository);
        pOA2.activate_object_with_id("Register".getBytes(), registerImpl);
        traderComp.setRegisterInterface(RegisterHelper.narrow(pOA2.servant_to_reference(registerImpl)));
        LinkImpl linkImpl = new LinkImpl(traderComp, supportAttrib, linkAttrib);
        pOA2.activate_object_with_id("Link".getBytes(), linkImpl);
        traderComp.setLinkInterface(LinkHelper.narrow(pOA2.servant_to_reference(linkImpl)));
        LookupImpl lookupImpl = new LookupImpl(traderComp, supportAttrib, importAttrib, offerDatabase, linkImpl, ((org.jacorb.orb.ORB)orb).getConfiguration());
        pOA2.activate_object_with_id("Lookup".getBytes(), lookupImpl);
        traderComp.setLookupInterface(LookupHelper.narrow(pOA2.servant_to_reference(lookupImpl)));
        byte[] byArray = orb.object_to_string(pOA2.servant_to_reference(lookupImpl)).getBytes();
        AdminImpl adminImpl = new AdminImpl(traderComp, supportAttrib, importAttrib, linkAttrib, offerDatabase, byArray);
        pOA2.activate_object_with_id("Admin".getBytes(), adminImpl);
        traderComp.setAdminInterface(AdminHelper.narrow(pOA2.servant_to_reference(adminImpl)));
        ProxyImpl proxyImpl = new ProxyImpl(traderComp, supportAttrib, offerDatabase);
        pOA2.activate_object_with_id("Proxy".getBytes(), proxyImpl);
        traderComp.setProxyInterface(ProxyHelper.narrow(pOA2.servant_to_reference(proxyImpl)));
        if (string != null) {
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(string);
                PrintWriter printWriter = new PrintWriter(fileOutputStream);
                printWriter.println(orb.object_to_string(pOA2.servant_to_reference(lookupImpl)));
                printWriter.flush();
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                System.err.println("Unable to write IOR to file " + string);
                System.exit(1);
            }
        }
    }

    public static void main(String[] stringArray) {
        File file;
        String string = null;
        String string2 = s_defaultDbpath;
        if (stringArray.length != 1 && stringArray.length != 3) {
            TradingService.usage();
        }
        string = stringArray[0];
        if (stringArray.length == 3) {
            if (stringArray[1].equals("-d")) {
                string2 = stringArray[2];
            } else {
                TradingService.usage();
            }
        }
        if (!(file = new File(string2)).exists()) {
            System.out.println("The directory " + string2 + " does not exist");
            System.exit(1);
        } else if (!file.isDirectory()) {
            System.out.println("The path " + string2 + " is not a directory");
            System.exit(1);
        }
        Properties properties = new Properties();
        properties.put("jacorb.implname", "Trader");
        orb = ORB.init(stringArray, null);
        configuration = ((org.jacorb.orb.ORB)orb).getConfiguration();
        SimpleDatabaseMgr simpleDatabaseMgr = new SimpleDatabaseMgr(string2);
        try {
            new TradingService(simpleDatabaseMgr, string);
            orb.run();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        simpleDatabaseMgr.shutdown();
        System.exit(0);
    }

    protected static void usage() {
        System.err.println("Usage: org.jacorb.trading.TradingService <iorfile> [-d dbpath]");
        System.exit(1);
    }

    private int getProperty(String string, int n) {
        String string2 = configuration.getAttribute(string, null);
        int n2 = n;
        if (string2 != null) {
            try {
                n2 = Integer.parseInt(string2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return n2;
    }

    private FollowOption getProperty(String string, FollowOption followOption) {
        String string2 = configuration.getAttribute(string, null);
        int n = followOption.value();
        if (string2 != null) {
            try {
                n = Integer.parseInt(string2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return FollowOption.from_int(n);
    }

    private boolean getProperty(String string, boolean bl) {
        String string2 = configuration.getAttribute(string, null);
        boolean bl2 = bl;
        if (string2 != null) {
            try {
                bl2 = Boolean.valueOf(string2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return bl2;
    }
}

