/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.poa;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.poa.AOMListener;
import org.jacorb.poa.EventMulticaster;
import org.jacorb.poa.POA;
import org.jacorb.poa.RequestController;
import org.jacorb.poa.except.POAInternalError;
import org.jacorb.poa.util.ByteArrayKey;
import org.jacorb.poa.util.POAUtil;
import org.jacorb.poa.util.StringPair;
import org.omg.CORBA.SystemException;
import org.omg.PortableServer.ForwardRequest;
import org.omg.PortableServer.POAPackage.ObjectAlreadyActive;
import org.omg.PortableServer.POAPackage.ObjectNotActive;
import org.omg.PortableServer.POAPackage.ServantAlreadyActive;
import org.omg.PortableServer.Servant;
import org.omg.PortableServer.ServantActivator;

public class AOM {
    private AOMListener aomListener;
    private boolean unique;
    private boolean singleThreaded;
    private Logger logger;
    private Hashtable objectMap = new Hashtable();
    private Hashtable servantMap;
    private Vector etherealisationList = new Vector();
    private Vector incarnationList = new Vector();
    private Vector deactivationList = new Vector();
    private Object deactivationListLock = new Object();

    private AOM() {
    }

    protected AOM(boolean bl, boolean bl2, Logger logger) {
        this.unique = bl;
        this.singleThreaded = bl2;
        this.logger = logger;
        if (this.unique) {
            this.servantMap = new Hashtable();
        }
    }

    protected synchronized void add(byte[] byArray, Servant servant) throws ObjectAlreadyActive, ServantAlreadyActive {
        ByteArrayKey byteArrayKey = new ByteArrayKey(byArray);
        while (this.incarnationList.contains(byteArrayKey) || this.etherealisationList.contains(byteArrayKey) || this.deactivationList.contains(byteArrayKey) || this.servantMap != null && this.servantMap.get(servant) != null && this.deactivationList.contains((ByteArrayKey)this.servantMap.get(servant))) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.objectMap.containsKey(byteArrayKey)) {
            throw new ObjectAlreadyActive();
        }
        if (this.unique && this.servantMap.containsKey(servant)) {
            throw new ServantAlreadyActive();
        }
        this.objectMap.put(byteArrayKey, servant);
        if (this.unique) {
            this.servantMap.put(servant, byteArrayKey);
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("oid: " + POAUtil.convert(byArray) + "object is activated");
        }
        if (this.aomListener != null) {
            this.aomListener.objectActivated(byArray, servant, this.objectMap.size());
        }
    }

    protected synchronized void addAOMListener(AOMListener aOMListener) {
        this.aomListener = EventMulticaster.add(this.aomListener, aOMListener);
    }

    boolean isDeactivating(ByteArrayKey byteArrayKey) {
        return this.deactivationList.contains(byteArrayKey);
    }

    protected boolean contains(Servant servant) {
        if (this.unique) {
            return this.servantMap.containsKey(servant);
        }
        return this.objectMap.contains(servant);
    }

    protected synchronized StringPair[] deliverContent() {
        StringPair[] stringPairArray = new StringPair[this.objectMap.size()];
        Enumeration enumeration = this.objectMap.keys();
        for (int i = 0; i < stringPairArray.length; ++i) {
            ByteArrayKey byteArrayKey = (ByteArrayKey)enumeration.nextElement();
            stringPairArray[i] = new StringPair(byteArrayKey.toString(), this.objectMap.get(byteArrayKey).getClass().getName());
        }
        return stringPairArray;
    }

    protected byte[] getObjectId(Servant servant) {
        if (!this.unique) {
            throw new POAInternalError("error: not UNIQUE_ID policy (getObjectId)");
        }
        ByteArrayKey byteArrayKey = (ByteArrayKey)this.servantMap.get(servant);
        if (byteArrayKey != null) {
            return byteArrayKey.getBytes();
        }
        return null;
    }

    protected Servant getServant(byte[] byArray) {
        return (Servant)this.objectMap.get(new ByteArrayKey(byArray));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized Servant incarnate(byte[] byArray, ServantActivator servantActivator, org.omg.PortableServer.POA pOA) throws ForwardRequest {
        ByteArrayKey byteArrayKey = new ByteArrayKey(byArray);
        Servant servant = null;
        if (this.logger.isInfoEnabled()) {
            this.logger.info("oid: " + POAUtil.convert(byArray) + "incarnate");
        }
        while (!this.incarnationList.isEmpty() || !this.etherealisationList.isEmpty()) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.objectMap.containsKey(byteArrayKey)) {
            return (Servant)this.objectMap.get(byteArrayKey);
        }
        this.incarnationList.addElement(byteArrayKey);
        try {
            servant = servantActivator.incarnate(byArray, pOA);
        }
        finally {
            this.incarnationList.removeElement(byteArrayKey);
            this.notifyAll();
        }
        if (servant == null) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("oid: " + POAUtil.convert(byArray) + "servant is not incarnated (incarnate returns null)");
            }
            return null;
        }
        if (this.unique && this.servantMap.containsKey(servant)) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("oid: " + POAUtil.convert(byArray) + "servant is not incarnated (unique_id policy is violated)");
            }
            return null;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("oid: " + POAUtil.convert(byArray) + "servant is incarnated");
        }
        if (this.aomListener != null) {
            this.aomListener.servantIncarnated(byArray, servant);
        }
        try {
            this.add(byArray, servant);
        }
        catch (ObjectAlreadyActive objectAlreadyActive) {
            throw new POAInternalError("error: object already active (AOM.incarnate)");
        }
        catch (ServantAlreadyActive servantAlreadyActive) {
            throw new POAInternalError("error: servant already active (AOM.incarnate)");
        }
        return servant;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void remove(byte[] byArray, RequestController requestController, ServantActivator servantActivator, POA pOA, boolean bl) throws ObjectNotActive {
        ByteArrayKey byteArrayKey = new ByteArrayKey(byArray);
        Object object = this.deactivationListLock;
        synchronized (object) {
            if (!this.objectMap.containsKey(byteArrayKey) || this.deactivationList.contains(byteArrayKey)) {
                throw new ObjectNotActive();
            }
            this.deactivationList.addElement(byteArrayKey);
        }
        object = byArray;
        RequestController requestController2 = requestController;
        ServantActivator servantActivator2 = servantActivator;
        POA pOA2 = pOA;
        boolean bl2 = bl;
        Thread thread = new Thread("AOM_RemovalThread", (byte[])object, requestController2, servantActivator2, pOA2, bl2){
            final /* synthetic */ byte[] val$oid_;
            final /* synthetic */ RequestController val$requestController_;
            final /* synthetic */ ServantActivator val$servantActivator_;
            final /* synthetic */ POA val$poa_;
            final /* synthetic */ boolean val$cleanupInProgress_;
            {
                this.val$oid_ = byArray;
                this.val$requestController_ = requestController;
                this.val$servantActivator_ = servantActivator;
                this.val$poa_ = pOA;
                this.val$cleanupInProgress_ = bl;
                super(string);
            }

            public void run() {
                AOM.this._remove(this.val$oid_, this.val$requestController_, this.val$servantActivator_, this.val$poa_, this.val$cleanupInProgress_);
            }
        };
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _remove(byte[] byArray, RequestController requestController, ServantActivator servantActivator, POA pOA, boolean bl) {
        ByteArrayKey byteArrayKey = new ByteArrayKey(byArray);
        Servant servant = null;
        if (!this.objectMap.containsKey(byteArrayKey)) {
            this.deactivationList.removeElement(byteArrayKey);
            return;
        }
        if (requestController != null) {
            requestController.waitForObjectCompletion(byArray);
        }
        AOM aOM = this;
        synchronized (aOM) {
            servant = (Servant)this.objectMap.get(byteArrayKey);
            if (servant == null) {
                return;
            }
            this.objectMap.remove(byteArrayKey);
            if (this.unique) {
                this.servantMap.remove(servant);
            }
            this.deactivationList.removeElement(byteArrayKey);
            if (this.logger.isInfoEnabled()) {
                this.logger.info("oid: " + POAUtil.convert(byArray) + "object is deactivated");
            }
            if (this.aomListener != null) {
                this.aomListener.objectDeactivated(byArray, servant, this.objectMap.size());
            }
            if (servantActivator == null) {
                requestController.freeObject(byArray);
                this.notifyAll();
                return;
            }
            while (!this.incarnationList.isEmpty() || !this.etherealisationList.isEmpty()) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.etherealisationList.addElement(byteArrayKey);
            try {
                servantActivator.etherealize(byArray, pOA, servant, bl, this.contains(servant));
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("oid: " + POAUtil.convert(byArray) + "servant is etherealized");
                }
                if (this.aomListener != null) {
                    this.aomListener.servantEtherialized(byArray, servant);
                }
            }
            catch (SystemException systemException) {
                if (this.logger.isWarnEnabled()) {
                    this.logger.info("oid: " + POAUtil.convert(byArray) + "exception occurred during servant etherialisation: " + systemException.getMessage());
                }
            }
            finally {
                this.etherealisationList.removeElement(byteArrayKey);
                this.notifyAll();
            }
            if (requestController != null) {
                requestController.freeObject(byArray);
            }
        }
    }

    protected void removeAll(ServantActivator servantActivator, POA pOA, boolean bl) {
        Enumeration enumeration = this.objectMap.keys();
        while (enumeration.hasMoreElements()) {
            byte[] byArray = ((ByteArrayKey)enumeration.nextElement()).getBytes();
            this._remove(byArray, null, servantActivator, pOA, bl);
        }
    }

    protected synchronized void removeAOMListener(AOMListener aOMListener) {
        this.aomListener = EventMulticaster.remove(this.aomListener, aOMListener);
    }

    protected int size() {
        return this.objectMap.size();
    }
}

