/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.jmx;

import javax.management.Attribute;
import javax.management.AttributeChangeNotification;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ReflectionException;
import javax.management.StandardMBean;
import org.jacorb.notification.interfaces.JMXManageable;
import org.jacorb.util.ObjectUtil;

public class BroadcastSupportMBeanDecorator
implements DynamicMBean,
NotificationEmitter {
    private final NotificationBroadcasterSupport broadCaster_ = new NotificationBroadcasterSupport();
    private final DynamicMBean delegate_;
    private final String[] types_;
    private int notificationSequence_ = 0;

    public BroadcastSupportMBeanDecorator(JMXManageable jMXManageable) throws NotCompliantMBeanException, ClassNotFoundException {
        this.types_ = jMXManageable.getJMXNotificationTypes();
        this.delegate_ = new StandardMBean(jMXManageable, this.getManagementInterface(jMXManageable.getClass()));
        jMXManageable.setJMXCallback(new JMXManageable.JMXCallback(){

            public void sendJMXNotification(String string, String string2) {
                BroadcastSupportMBeanDecorator.this.sendNotification(string, string2);
            }

            public void sendJMXAttributeChanged(String string, Object object, Object object2) {
                BroadcastSupportMBeanDecorator.this.sendAttributeChanged(string, object, object2);
            }

            public void sendJMXNotification(String string, String string2, Object object) {
                BroadcastSupportMBeanDecorator.this.sendNotification(string, string2, object);
            }
        });
    }

    private Class getManagementInterface(Class clazz) throws IllegalArgumentException, ClassNotFoundException {
        String string = clazz.getName() + "MBean";
        if (clazz.getClassLoader() != null) {
            return clazz.getClassLoader().loadClass(string);
        }
        return ObjectUtil.classForName(string);
    }

    public Object getAttribute(String string) throws AttributeNotFoundException, MBeanException, ReflectionException {
        return this.delegate_.getAttribute(string);
    }

    public AttributeList getAttributes(String[] stringArray) {
        return this.delegate_.getAttributes(stringArray);
    }

    public MBeanInfo getMBeanInfo() {
        MBeanInfo mBeanInfo = this.delegate_.getMBeanInfo();
        if (this.types_ != null && this.types_.length > 0) {
            return new MBeanInfo(mBeanInfo.getClassName(), mBeanInfo.getDescription(), mBeanInfo.getAttributes(), mBeanInfo.getConstructors(), mBeanInfo.getOperations(), this.getNotificationInfo());
        }
        return mBeanInfo;
    }

    public Object invoke(String string, Object[] objectArray, String[] stringArray) throws MBeanException, ReflectionException {
        return this.delegate_.invoke(string, objectArray, stringArray);
    }

    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        this.delegate_.setAttribute(attribute);
    }

    public AttributeList setAttributes(AttributeList attributeList) {
        return this.delegate_.setAttributes(attributeList);
    }

    public void addNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws IllegalArgumentException {
        this.broadCaster_.addNotificationListener(notificationListener, notificationFilter, object);
    }

    public void removeNotificationListener(NotificationListener notificationListener) throws ListenerNotFoundException {
        this.broadCaster_.removeNotificationListener(notificationListener);
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        return new MBeanNotificationInfo[]{new MBeanNotificationInfo(this.types_, Notification.class.getName(), "User Notifications"), new MBeanNotificationInfo(new String[]{"jmx.attribute.change"}, AttributeChangeNotification.class.getName(), "User attribute change notification")};
    }

    public void sendNotification(String string, String string2, Object object) {
        Notification notification = new Notification(string, (Object)this, (long)(++this.notificationSequence_), string2);
        if (object != null) {
            notification.setUserData(object);
        }
        this.broadCaster_.sendNotification(notification);
    }

    public void sendNotification(String string, String string2) {
        Notification notification = new Notification(string, (Object)this, (long)(++this.notificationSequence_), string2);
        this.broadCaster_.sendNotification(notification);
    }

    public void removeNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws ListenerNotFoundException {
        this.broadCaster_.removeNotificationListener(notificationListener, notificationFilter, object);
    }

    public void sendAttributeChanged(String string, Object object, Object object2) {
        this.broadCaster_.sendNotification(new AttributeChangeNotification(this.delegate_, ++this.notificationSequence_, System.currentTimeMillis(), "Attribute value changed", string, object == null ? null : object.getClass().getName(), object, object2));
    }
}

