/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.filter;

import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicInteger;
import edu.emory.mathcs.backport.java.util.concurrent.locks.Lock;
import edu.emory.mathcs.backport.java.util.concurrent.locks.ReadWriteLock;
import edu.emory.mathcs.backport.java.util.concurrent.locks.ReentrantReadWriteLock;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.notification.AbstractMessage;
import org.jacorb.notification.EventTypeWrapper;
import org.jacorb.notification.MessageFactory;
import org.jacorb.notification.conf.Default;
import org.jacorb.notification.filter.AbstractFilterMBean;
import org.jacorb.notification.filter.CallbackManager;
import org.jacorb.notification.filter.ConstraintEntry;
import org.jacorb.notification.filter.EvaluationContext;
import org.jacorb.notification.filter.EvaluationException;
import org.jacorb.notification.filter.FilterConstraint;
import org.jacorb.notification.filter.FilterUsageDecorator;
import org.jacorb.notification.filter.PropertyDoesNotExistException;
import org.jacorb.notification.interfaces.Disposable;
import org.jacorb.notification.interfaces.EvaluationContextFactory;
import org.jacorb.notification.interfaces.GCDisposable;
import org.jacorb.notification.interfaces.JMXManageable;
import org.jacorb.notification.interfaces.Message;
import org.jacorb.notification.lifecycle.IServantLifecyle;
import org.jacorb.notification.lifecycle.ServantLifecyleControl;
import org.jacorb.notification.util.DisposableManager;
import org.jacorb.notification.util.LogUtil;
import org.jacorb.notification.util.WildcardMap;
import org.jacorb.util.ObjectUtil;
import org.omg.CORBA.Any;
import org.omg.CORBA.Object;
import org.omg.CosNotification.EventType;
import org.omg.CosNotification.Property;
import org.omg.CosNotification.StructuredEvent;
import org.omg.CosNotifyComm.NotifySubscribe;
import org.omg.CosNotifyFilter.ConstraintExp;
import org.omg.CosNotifyFilter.ConstraintInfo;
import org.omg.CosNotifyFilter.ConstraintNotFound;
import org.omg.CosNotifyFilter.FilterOperations;
import org.omg.CosNotifyFilter.FilterPOATie;
import org.omg.CosNotifyFilter.InvalidConstraint;
import org.omg.CosNotifyFilter.UnsupportedFilterableData;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;

public abstract class AbstractFilter
implements GCDisposable,
IServantLifecyle,
FilterOperations,
JMXManageable,
AbstractFilterMBean {
    private static int sCount_ = 0;
    private final int number_ = ++sCount_;
    static final RuntimeException NOT_SUPPORTED = new UnsupportedOperationException("this operation is not supported");
    public static final int NO_CONSTRAINTS_MATCH = -2;
    public static final int CONSTRAINTS_EMPTY = -1;
    private static final String EMPTY_EVENT_TYPE_CONSTRAINT_KEY = AbstractMessage.calcConstraintKey("*", "*");
    private final DisposableManager disposables_ = new DisposableManager();
    private final CallbackManager callbackManager_ = new CallbackManager();
    protected final Map constraints_ = new HashMap();
    protected final WildcardMap wildcardMap_;
    protected final ReadWriteLock constraintsLock_;
    private final AtomicInteger constraintIdPool_ = new AtomicInteger(0);
    protected final MessageFactory messageFactory_;
    private final FilterUsageDecorator filterUsageDecorator_;
    private final POA poa_;
    private final Logger logger_;
    private final EvaluationContextFactory evaluationContextFactory_;
    private final long maxIdleTime_;
    private final ServantLifecyleControl servantLifecyle_;

    protected AbstractFilter(Configuration configuration, EvaluationContextFactory evaluationContextFactory, MessageFactory messageFactory, POA pOA) throws ConfigurationException {
        this.poa_ = pOA;
        this.logger_ = LogUtil.getLogger(configuration, this.getClass().getName());
        if (this.logger_.isInfoEnabled()) {
            this.logger_.info("Created filter for Grammar: " + this.constraint_grammar());
        }
        this.messageFactory_ = messageFactory;
        this.evaluationContextFactory_ = evaluationContextFactory;
        this.constraintsLock_ = new ReentrantReadWriteLock();
        this.wildcardMap_ = this.newWildcardMap(configuration);
        this.disposables_.addDisposable(this.callbackManager_);
        this.filterUsageDecorator_ = new FilterUsageDecorator(this);
        this.maxIdleTime_ = configuration.getAttributeAsLong("jacorb.notification.filter.dead_interval", 0L);
        this.servantLifecyle_ = new ServantLifecyleControl((IServantLifecyle)this, configuration);
    }

    public final Servant newServant() {
        return new FilterPOATie(this.filterUsageDecorator_.getFilterOperations());
    }

    public final POA getPOA() {
        return this.poa_;
    }

    private WildcardMap newWildcardMap(Configuration configuration) throws ConfigurationException {
        String string = configuration.getAttribute("jacorb.notification.filter.wildcardmap_impl", Default.DEFAULT_WILDCARDMAP_IMPL);
        try {
            Class clazz = ObjectUtil.classForName(string);
            Constructor constructor = clazz.getConstructor(new Class[0]);
            return (WildcardMap)constructor.newInstance(new java.lang.Object[0]);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        throw new ConfigurationException(string + " is no valid WildcardMap Implementation");
    }

    public final Object activate() {
        return this.servantLifecyle_.activate();
    }

    public final void deactivate() {
        this.servantLifecyle_.deactivate();
    }

    protected int newConstraintId() {
        return this.constraintIdPool_.getAndIncrement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConstraintInfo[] add_constraints(ConstraintExp[] constraintExpArray) throws InvalidConstraint {
        FilterConstraint[] filterConstraintArray = this.newFilterConstraints(constraintExpArray);
        this.constraintsLock_.writeLock().lock();
        try {
            ConstraintInfo[] constraintInfoArray = this.add_constraint(constraintExpArray, filterConstraintArray);
            return constraintInfoArray;
        }
        finally {
            this.constraintsLock_.writeLock().unlock();
        }
    }

    private ConstraintInfo[] add_constraint(ConstraintExp[] constraintExpArray, FilterConstraint[] filterConstraintArray) {
        ConstraintInfo[] constraintInfoArray = new ConstraintInfo[filterConstraintArray.length];
        for (int i = 0; i < constraintExpArray.length; ++i) {
            int n = this.newConstraintId();
            constraintInfoArray[i] = new ConstraintInfo(constraintExpArray[i], n);
            ConstraintEntry constraintEntry = new ConstraintEntry(filterConstraintArray[i], constraintInfoArray[i]);
            this.addEventTypeMappingsForConstraint(constraintEntry);
            this.constraints_.put(new Integer(n), constraintEntry);
            this.notifyCallbacks();
        }
        return constraintInfoArray;
    }

    private void addEventTypeMappingsForConstraint(ConstraintEntry constraintEntry) {
        int n = constraintEntry.getEventTypeCount();
        if (n == 0) {
            this.addConstraintEntryToWildcardMap(EMPTY_EVENT_TYPE_CONSTRAINT_KEY, constraintEntry);
        } else {
            for (int i = 0; i < n; ++i) {
                EventTypeWrapper eventTypeWrapper = constraintEntry.getEventTypeWrapper(i);
                this.addConstraintEntryToWildcardMap(eventTypeWrapper.getConstraintKey(), constraintEntry);
            }
        }
    }

    private void addConstraintEntryToWildcardMap(String string, ConstraintEntry constraintEntry) {
        LinkedList<ConstraintEntry> linkedList = (LinkedList<ConstraintEntry>)this.wildcardMap_.getNoExpansion(string);
        if (linkedList == null) {
            linkedList = new LinkedList<ConstraintEntry>();
            this.wildcardMap_.put(string, linkedList);
        }
        linkedList.add(constraintEntry);
    }

    private FilterConstraint[] newFilterConstraints(ConstraintExp[] constraintExpArray) throws InvalidConstraint {
        FilterConstraint[] filterConstraintArray = new FilterConstraint[constraintExpArray.length];
        for (int i = 0; i < constraintExpArray.length; ++i) {
            filterConstraintArray[i] = this.newFilterConstraint(constraintExpArray[i]);
        }
        return filterConstraintArray;
    }

    protected abstract FilterConstraint newFilterConstraint(ConstraintExp var1) throws InvalidConstraint;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modify_constraints(int[] nArray, ConstraintInfo[] constraintInfoArray) throws ConstraintNotFound, InvalidConstraint {
        this.constraintsLock_.writeLock().lock();
        try {
            Integer[] integerArray = this.checkConstraintsToBeDeleted(nArray);
            FilterConstraint[] filterConstraintArray = this.checkConstraintsToBeModified(constraintInfoArray);
            this.deleteConstraints(integerArray);
            this.modifyConstraints(constraintInfoArray, filterConstraintArray);
            this.notifyCallbacks();
        }
        finally {
            this.constraintsLock_.writeLock().unlock();
        }
    }

    private void modifyConstraints(ConstraintInfo[] constraintInfoArray, FilterConstraint[] filterConstraintArray) {
        for (int i = 0; i < constraintInfoArray.length; ++i) {
            Integer n = new Integer(constraintInfoArray[i].constraint_id);
            ConstraintEntry constraintEntry = new ConstraintEntry(filterConstraintArray[i], constraintInfoArray[i]);
            this.constraints_.put(n, constraintEntry);
            int n2 = constraintEntry.getEventTypeCount();
            for (int j = 0; j < n2; ++j) {
                EventTypeWrapper eventTypeWrapper = constraintEntry.getEventTypeWrapper(j);
                List list = (List)this.wildcardMap_.getNoExpansion(eventTypeWrapper.getConstraintKey());
                list.add(constraintEntry);
            }
        }
    }

    private FilterConstraint[] checkConstraintsToBeModified(ConstraintInfo[] constraintInfoArray) throws InvalidConstraint, ConstraintNotFound {
        FilterConstraint[] filterConstraintArray = new FilterConstraint[constraintInfoArray.length];
        for (int i = 0; i < constraintInfoArray.length; ++i) {
            if (!this.constraints_.containsKey(new Integer(constraintInfoArray[i].constraint_id))) {
                throw new ConstraintNotFound(constraintInfoArray[i].constraint_id);
            }
            filterConstraintArray[i] = this.newFilterConstraint(constraintInfoArray[i].constraint_expression);
        }
        return filterConstraintArray;
    }

    private Integer[] checkConstraintsToBeDeleted(int[] nArray) throws ConstraintNotFound {
        Integer[] integerArray = new Integer[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            integerArray[i] = new Integer(nArray[i]);
            if (this.constraints_.containsKey(integerArray[i])) continue;
            throw new ConstraintNotFound(nArray[i]);
        }
        return integerArray;
    }

    private void deleteConstraints(Integer[] integerArray) {
        for (int i = 0; i < integerArray.length; ++i) {
            ConstraintEntry constraintEntry = (ConstraintEntry)this.constraints_.remove(integerArray[i]);
            this.removeEventTypeMappingForConstraint(integerArray[i], constraintEntry);
        }
    }

    private void removeEventTypeMappingForConstraint(Integer n, ConstraintEntry constraintEntry) {
        int n2 = constraintEntry.getEventTypeCount();
        block0: for (int i = 0; i < n2; ++i) {
            EventTypeWrapper eventTypeWrapper = constraintEntry.getEventTypeWrapper(i);
            List list = (List)this.wildcardMap_.getNoExpansion(eventTypeWrapper.getConstraintKey());
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                ConstraintEntry constraintEntry2 = (ConstraintEntry)iterator.next();
                if (constraintEntry2.getConstraintId() != n.intValue()) continue;
                iterator.remove();
                continue block0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConstraintInfo[] get_constraints(int[] nArray) throws ConstraintNotFound {
        Lock lock = this.constraintsLock_.readLock();
        lock.lock();
        try {
            ConstraintInfo[] constraintInfoArray = new ConstraintInfo[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                Integer n = new Integer(nArray[i]);
                if (!this.constraints_.containsKey(n)) {
                    throw new ConstraintNotFound(nArray[i]);
                }
                constraintInfoArray[i] = ((ConstraintEntry)this.constraints_.get(n)).getConstraintInfo();
            }
            ConstraintInfo[] constraintInfoArray2 = constraintInfoArray;
            return constraintInfoArray2;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConstraintInfo[] get_all_constraints() {
        this.constraintsLock_.readLock().lock();
        try {
            ConstraintInfo[] constraintInfoArray = new ConstraintInfo[this.constraints_.size()];
            Iterator iterator = this.constraints_.values().iterator();
            for (int i = 0; i < constraintInfoArray.length; ++i) {
                constraintInfoArray[i] = ((ConstraintEntry)iterator.next()).getConstraintInfo();
            }
            ConstraintInfo[] constraintInfoArray2 = constraintInfoArray;
            return constraintInfoArray2;
        }
        finally {
            this.constraintsLock_.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove_all_constraints() {
        this.constraintsLock_.writeLock().lock();
        try {
            this.constraints_.clear();
            this.wildcardMap_.clear();
            this.notifyCallbacks();
        }
        finally {
            this.constraintsLock_.writeLock().unlock();
        }
    }

    public void destroy() {
        this.dispose();
    }

    private Iterator getConstraintsForEvent(Message message) {
        String string = message.getConstraintKey();
        return this.getIterator(string);
    }

    public Iterator getIterator(java.lang.Object object) {
        java.lang.Object[] objectArray = this.wildcardMap_.getWithExpansion(object);
        return new ConstraintIterator(objectArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int match_ReadLock(EvaluationContext evaluationContext, Message message) throws UnsupportedFilterableData {
        this.constraintsLock_.readLock().lock();
        try {
            int n = this.match_NoLock(evaluationContext, message);
            return n;
        }
        finally {
            this.constraintsLock_.readLock().unlock();
        }
    }

    private int match_NoLock(EvaluationContext evaluationContext, Message message) throws UnsupportedFilterableData {
        if (!this.constraints_.isEmpty()) {
            Iterator iterator = this.getConstraintsForEvent(message);
            while (iterator.hasNext()) {
                ConstraintEntry constraintEntry = (ConstraintEntry)iterator.next();
                try {
                    boolean bl = constraintEntry.getFilterConstraint().evaluate(evaluationContext, message).getBool();
                    if (!bl) continue;
                    return constraintEntry.getConstraintId();
                }
                catch (PropertyDoesNotExistException propertyDoesNotExistException) {
                    if (this.logger_.isInfoEnabled()) {
                        this.logger_.info("tried to access non existing Property: " + propertyDoesNotExistException.getMessage());
                        continue;
                    }
                    if (!this.logger_.isDebugEnabled()) continue;
                    this.logger_.debug("tried to access non existing Property", (Throwable)propertyDoesNotExistException);
                }
                catch (EvaluationException evaluationException) {
                    this.logger_.error("Error evaluating filter", (Throwable)evaluationException);
                    throw new UnsupportedFilterableData(evaluationException.getMessage());
                }
            }
            return -2;
        }
        this.logger_.info("Filter has no Expressions");
        return -1;
    }

    public boolean match(Any any) throws UnsupportedFilterableData {
        return this.match_internal(any) >= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int match_internal(Any any) throws UnsupportedFilterableData {
        EvaluationContext evaluationContext = this.evaluationContextFactory_.newEvaluationContext();
        try {
            int n;
            Message message = this.messageFactory_.newMessage(any);
            try {
                n = this.match_ReadLock(evaluationContext, message);
            }
            catch (Throwable throwable) {
                message.dispose();
                throw throwable;
            }
            message.dispose();
            return n;
        }
        finally {
            evaluationContext.dispose();
        }
    }

    public boolean match_structured(StructuredEvent structuredEvent) throws UnsupportedFilterableData {
        return this.match_structured_internal(structuredEvent) >= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int match_structured_internal(StructuredEvent structuredEvent) throws UnsupportedFilterableData {
        EvaluationContext evaluationContext = this.evaluationContextFactory_.newEvaluationContext();
        try {
            int n;
            Message message = this.messageFactory_.newMessage(structuredEvent);
            try {
                n = this.match_ReadLock(evaluationContext, message);
            }
            catch (Throwable throwable) {
                message.dispose();
                throw throwable;
            }
            message.dispose();
            return n;
        }
        finally {
            evaluationContext.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int match_typed_internal(Property[] propertyArray) throws UnsupportedFilterableData {
        EvaluationContext evaluationContext = this.evaluationContextFactory_.newEvaluationContext();
        try {
            int n;
            Message message = this.messageFactory_.newMessage(propertyArray);
            try {
                n = this.match_ReadLock(evaluationContext, message);
            }
            catch (Throwable throwable) {
                message.dispose();
                throw throwable;
            }
            message.dispose();
            return n;
        }
        finally {
            evaluationContext.dispose();
        }
    }

    public boolean match_typed(Property[] propertyArray) throws UnsupportedFilterableData {
        return this.match_typed_internal(propertyArray) >= 0;
    }

    public int attach_callback(NotifySubscribe notifySubscribe) {
        return this.callbackManager_.attach_callback(notifySubscribe);
    }

    public void detach_callback(int n) {
        this.callbackManager_.detach_callback(n);
    }

    public int[] get_callbacks() {
        return this.callbackManager_.get_callbacks();
    }

    private void notifyCallbacks() {
        Iterator iterator = this.constraints_.keySet().iterator();
        ArrayList<EventType> arrayList = new ArrayList<EventType>();
        while (iterator.hasNext()) {
            java.lang.Object k = iterator.next();
            ConstraintEntry constraintEntry = (ConstraintEntry)this.constraints_.get(k);
            int n = constraintEntry.getEventTypeCount();
            for (int i = 0; i < n; ++i) {
                EventTypeWrapper eventTypeWrapper = constraintEntry.getEventTypeWrapper(i);
                arrayList.add(eventTypeWrapper.getEventType());
            }
        }
        this.callbackManager_.replaceWith(arrayList.toArray(EventTypeWrapper.EMPTY_EVENT_TYPE_ARRAY));
    }

    public void dispose() {
        this.deactivate();
        this.disposables_.dispose();
    }

    public void registerDisposable(Disposable disposable) {
        this.disposables_.addDisposable(disposable);
    }

    public Date getLastUsage() {
        return this.filterUsageDecorator_.getLastUsage();
    }

    public Date getCreationDate() {
        return this.filterUsageDecorator_.getCreationDate();
    }

    public long getMatchCount() {
        return this.filterUsageDecorator_.getMatchCount();
    }

    public long getMatchStructuredCount() {
        return this.filterUsageDecorator_.getMatchStructuredCount();
    }

    public long getMatchTypedCount() {
        return this.filterUsageDecorator_.getMatchTypedCount();
    }

    public String listContraints() {
        StringBuffer stringBuffer = new StringBuffer();
        for (Map.Entry entry : this.constraints_.entrySet()) {
            ConstraintEntry constraintEntry = (ConstraintEntry)entry.getValue();
            constraintEntry.appendToBuffer(stringBuffer);
        }
        return stringBuffer.toString();
    }

    public final String getJMXObjectName() {
        return "type=filter, number=" + this.number_ + ", grammar=" + this.constraint_grammar();
    }

    public String[] getJMXNotificationTypes() {
        return new String[0];
    }

    public void setJMXCallback(JMXManageable.JMXCallback jMXCallback) {
    }

    public void attemptDispose() {
        AbstractFilter.attemptDispose(this, this.getLastUsage(), this.maxIdleTime_);
    }

    static void attemptDispose(Disposable disposable, Date date, long l) {
        if (l <= 0L) {
            return;
        }
        if (date.getTime() + l < System.currentTimeMillis()) {
            disposable.dispose();
        }
    }

    private static class ConstraintIterator
    implements Iterator {
        private final java.lang.Object[] arrayOfLists_;
        private Iterator currentIterator_;
        private int currentListIdx_ = 0;

        ConstraintIterator(java.lang.Object[] objectArray) {
            this.arrayOfLists_ = objectArray;
            if (this.arrayOfLists_.length == 0) {
                this.currentIterator_ = null;
            } else {
                this.switchIterator();
            }
        }

        private void switchIterator() {
            this.currentIterator_ = ((List)this.arrayOfLists_[this.currentListIdx_]).iterator();
        }

        public boolean hasNext() {
            return this.currentIterator_ != null && this.currentIterator_.hasNext();
        }

        public java.lang.Object next() {
            if (this.currentIterator_ == null) {
                throw new NoSuchElementException();
            }
            java.lang.Object e = this.currentIterator_.next();
            if (!this.currentIterator_.hasNext() && this.currentListIdx_ < this.arrayOfLists_.length - 1) {
                ++this.currentListIdx_;
                this.switchIterator();
            }
            return e;
        }

        public void remove() {
            throw NOT_SUPPORTED;
        }
    }
}

