/*
 * Decompiled with CFR 0.152.
 */
package org.sitemesh.content.memory;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.sitemesh.content.ContentProperty;
import org.sitemesh.content.memory.InMemoryContent;
import org.sitemesh.content.memory.InMemoryContentChunk;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class InMemoryContentProperty
extends InMemoryContentChunk
implements ContentProperty,
Iterable<ContentProperty> {
    private static final Iterator<ContentProperty> EMPTY_ITERATOR = Collections.emptySet().iterator();
    private final boolean isRoot;
    private final String name;
    private final InMemoryContentProperty parent;
    private Map<String, ContentProperty> children;

    public InMemoryContentProperty(InMemoryContent owner) {
        super(owner);
        this.name = null;
        this.parent = null;
        this.isRoot = true;
    }

    protected InMemoryContentProperty(String name, InMemoryContentProperty parent) {
        super(parent.getOwningContent());
        this.name = name;
        this.parent = parent;
        this.isRoot = false;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public ContentProperty[] getFullPath() {
        int size = 0;
        InMemoryContentProperty node = this;
        while (!node.isRoot) {
            ++size;
            node = node.parent;
        }
        ContentProperty[] result = new ContentProperty[size];
        int index = 0;
        InMemoryContentProperty node2 = this;
        while (!node2.isRoot) {
            result[result.length - 1 - index] = node2;
            node2 = node2.parent;
            ++index;
        }
        return result;
    }

    @Override
    public boolean hasChildren() {
        return this.children != null && !this.children.isEmpty();
    }

    @Override
    public boolean hasChild(String childName) {
        return this.children != null && this.children.containsKey(childName);
    }

    @Override
    public ContentProperty getChild(String childName) {
        ContentProperty property;
        if (this.children == null) {
            this.children = new HashMap<String, ContentProperty>();
        }
        if ((property = this.children.get(childName)) == null) {
            property = this.createChild(childName);
            this.children.put(childName, property);
        }
        return property;
    }

    protected InMemoryContentProperty createChild(String childName) {
        return new InMemoryContentProperty(childName, this);
    }

    @Override
    public ContentProperty getParent() {
        return this.parent;
    }

    @Override
    public Iterable<ContentProperty> getChildren() {
        return this;
    }

    @Override
    public Iterator<ContentProperty> iterator() {
        return this.children == null ? EMPTY_ITERATOR : this.children.values().iterator();
    }

    @Override
    public Iterable<ContentProperty> getDescendants() {
        return this.walk(this, new LinkedList<ContentProperty>());
    }

    private List<ContentProperty> walk(ContentProperty node, List<ContentProperty> result) {
        result.add(node);
        for (ContentProperty child : node.getChildren()) {
            this.walk(child, result);
        }
        return result;
    }
}

