/*
 * Decompiled with CFR 0.152.
 */
package org.sitemesh.content.memory;

import java.io.IOException;
import org.sitemesh.content.Content;
import org.sitemesh.content.ContentChunk;
import org.sitemesh.tagprocessor.CharSequenceBuffer;

class InMemoryContentChunk
implements ContentChunk {
    private CharSequence value;
    private final Content owner;

    public InMemoryContentChunk(Content owner) {
        this.owner = owner;
    }

    public boolean hasValue() {
        return this.value != null;
    }

    public String getValue() {
        return this.value != null ? ((Object)this.value).toString() : null;
    }

    public String getNonNullValue() {
        return this.value != null ? ((Object)this.value).toString() : "";
    }

    public void writeValueTo(Appendable out) throws IOException {
        if (this.value == null) {
            return;
        }
        if (this.value instanceof CharSequenceBuffer) {
            ((CharSequenceBuffer)this.value).writeTo(out);
        } else {
            out.append(this.value);
        }
    }

    public void setValue(CharSequence value) {
        this.value = value;
    }

    public String toString() {
        return this.getNonNullValue();
    }

    public Content getOwningContent() {
        return this.owner;
    }
}

