/*
 * Decompiled with CFR 0.152.
 */
package org.sitemesh.config.xml;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Xml {
    private final Element element;

    public Xml(Element element) {
        this.element = element;
    }

    public Xml() {
        this.element = null;
    }

    public Xml(String xml) {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = builder.parse(new InputSource(new StringReader(xml)));
            this.element = document.getDocumentElement();
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException(e);
        }
        catch (SAXException e) {
            throw new IllegalArgumentException("Could not parse XML:\n" + xml, e);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public String attribute(String name) {
        return this.element == null || !this.element.hasAttribute(name) ? null : this.element.getAttribute(name);
    }

    public String attribute(String name, String defaultValue) {
        return this.valueIfNotNull(this.attribute(name), defaultValue);
    }

    public String text() {
        return this.element == null ? null : this.element.getTextContent();
    }

    public String text(String defaultValue) {
        return this.valueIfNotNull(this.text(), defaultValue);
    }

    public List<Xml> children(String tagName) {
        if (this.element == null) {
            return Collections.emptyList();
        }
        NodeList nodeList = this.element.getChildNodes();
        ArrayList<Xml> result = new ArrayList<Xml>(nodeList.getLength());
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element;
            Node node = nodeList.item(i);
            if (!(node instanceof Element) || !(element = (Element)node).getTagName().equals(tagName)) continue;
            result.add(new Xml((Element)node));
        }
        return result;
    }

    public Xml child(String tagName) {
        if (this.element == null) {
            return new Xml();
        }
        NodeList nodeList = this.element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element;
            Node node = nodeList.item(i);
            if (!(node instanceof Element) || !(element = (Element)node).getTagName().equals(tagName)) continue;
            return new Xml((Element)node);
        }
        return new Xml();
    }

    public boolean exists() {
        return this.element != null;
    }

    private String valueIfNotNull(String value, String defaultValue) {
        return value == null ? defaultValue : value;
    }
}

