/*
 * Decompiled with CFR 0.152.
 */
package org.sitemesh.config.cmdline;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.StringReader;
import java.nio.CharBuffer;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.sitemesh.builder.SiteMeshOfflineBuilder;
import org.sitemesh.config.ObjectFactory;
import org.sitemesh.config.cmdline.ArgParser;
import org.sitemesh.config.properties.PropertiesOfflineConfigurator;
import org.sitemesh.config.xml.XmlOfflineConfigurator;
import org.sitemesh.offline.SiteMeshOffline;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class CommandLineLauncher {
    public static final String CONFIG_FILE_PARAM = "config";
    public static final String CONFIG_FILE_DEFAULT = "/WEB-INF/sitemesh3.xml";
    private static final String HELP_TEXT = "-------------------------------------------------------------------------------\nSiteMesh Offline Generator\n\n{sitemesh.exe} \\\n  -src SOURCE_DIR -dest DEST_DIR [-config CONFIG_FILE] FILES...\n\nCopy FILES from SOURCE_DIR to DEST_DIR applying SiteMesh decorators on the \nway.\n\nOptions:\n\n  -src -srcdir -source -in -i:\n          (required) Source directory, containing content and decorators.\n  -dest -destdir -destination -out -o [REQUIRED]:\n          (required) Destination, where decorated content will be output to.\n  -config:\n          (optional) Path to XML configuration file to use if \n  -decoratorMappings:\n          (optional) List of mappings of path patterns to decorators. \n          Each entry should consiste of pattern=decorator, separated by\n          commas. If multiple decorators are required, they should be\n          delimited with a pipe | char.\n  FILES...:\n          Files to apply decorators too. These are filenames relative to\n          SOURCE_DIR.\n\nExamples:\n\n  {sitemesh.exe} -src src/webapp -dest build/webapp \\\n  index.html page1.html page2.html\n          Copies src/webapp/{index.html,page1.html,page2.html} to\n          build/webapp, applying any decorators configured in\n          src/webapp/WEB-INF/sitemesh3.xml.\n\n  {sitemesh.exe} -src src/webapp -dest build/webapp\\\n  -config myconfig.xml \\\n  index.html\n          Copies src/webapp/index.html to build/webapp, applying any decorators\n          configured in myconfig.xml.\n\n  {sitemesh.exe} -src src/webapp -dest build/webapp \\\n  -decoratorMappings '/*=/dec-main.html,/page*=/dec-page.html|/dec-main.html'\\\n  index.html page1.html page2.html\n          Copies src/webapp/index.html to build/webapp, applying\n          dec-main.html, and src/webapp/{page1.html,page2.html} applying\n          decorator dec-page.html followed by dec-main.html\n\nFor more information, see http://www.sitemesh.org/\n\n".replaceAll("\\{sitemesh.exe\\}", System.getProperty("sitemesh.exe", "java -jar sitemesh.jar"));

    public static void main(String[] unparsedArgs) throws Exception {
        if (unparsedArgs.length == 0) {
            System.err.println(HELP_TEXT);
            System.exit(-1);
        }
        try {
            ArgParser args = new ArgParser(unparsedArgs);
            SiteMeshOfflineBuilder builder = new SiteMeshOfflineBuilder();
            ObjectFactory.Default objectFactory = new ObjectFactory.Default();
            new PropertiesOfflineConfigurator(objectFactory, args.getProperties()).configureOffline(builder);
            String configFileName = args.getProperties().get(CONFIG_FILE_PARAM);
            if (configFileName == null) {
                try {
                    CharBuffer configContents = builder.getSourceDirectory().load(CONFIG_FILE_DEFAULT);
                    new XmlOfflineConfigurator(objectFactory, CommandLineLauncher.parseXml(new InputSource(new StringReader(configContents.toString())))).configureOffline(builder);
                }
                catch (FileNotFoundException e) {}
            } else {
                new XmlOfflineConfigurator(objectFactory, CommandLineLauncher.parseXml(new InputSource(new FileInputStream(new File(configFileName))))).configureOffline(builder);
            }
            SiteMeshOffline siteMeshOffline = builder.create();
            for (String fileName : args.getRemaining()) {
                siteMeshOffline.process(fileName);
            }
        }
        catch (Exception e) {
            System.err.println("-------------------------------------------------------------------------------");
            System.err.println("ERROR: \n");
            if (System.getProperty("fullStackTrace", "false").equals("true")) {
                e.printStackTrace();
            } else {
                System.err.println(e.getMessage());
            }
            System.err.println(HELP_TEXT);
            System.err.println("-------------------------------------------------------------------------------");
            System.err.println("See start of message for error.");
            System.exit(-1);
        }
    }

    private static Element parseXml(InputSource input) throws IOException, SAXException, ParserConfigurationException {
        return DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(input).getDocumentElement();
    }
}

