/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.stat;

import dm.jdbc.desc.DmSvcConf;
import dm.jdbc.processor.BaseFlusher;
import dm.jdbc.stat.StatReader;
import dm.jdbc.util.StringUtil;
import java.util.ArrayList;

public class StatFlusher
extends BaseFlusher {
    private static StatReader statReader = new StatReader();
    private static int READ_MAX_SIZE = 100;
    private ArrayList<String> logList;

    private StatFlusher() {
        super("StatFlusher", DmSvcConf.statDir, "dm_jdbc_stat", DmSvcConf.statFlushFreq);
    }

    public static StatFlusher getInstance() {
        return StatFlusherThreadHolder.instance;
    }

    public static boolean isConnStatEnabled() {
        return DmSvcConf.statEnable;
    }

    public static boolean isSlowSqlStatEnabled() {
        return DmSvcConf.statEnable;
    }

    public static boolean isHighFreqSqlStatEnabled() {
        return DmSvcConf.statEnable;
    }

    protected void doRun() {
        while (this.flushFreq > 0) {
            this.doStat();
            try {
                Thread.sleep(this.flushFreq * 1000);
            }
            catch (Exception exception) {}
        }
    }

    protected void doStat() {
        boolean hasMore;
        if (this.logList == null) {
            this.logList = new ArrayList(16);
        }
        this.logList.add(StringUtil.formatTime("******************************************************* ", " *******************************************************"));
        if (StatFlusher.isConnStatEnabled()) {
            this.logList.add("#connection stat");
            hasMore = true;
            while (hasMore) {
                hasMore = statReader.readConnStat(this.logList, READ_MAX_SIZE);
                this.writeAndFlush(this.logList.toArray(new String[0]), 0, this.logList.size());
                this.logList.clear();
            }
        }
        if (StatFlusher.isHighFreqSqlStatEnabled()) {
            this.logList.add("#top " + DmSvcConf.statHighFreqSqlCount + " high freq sql stat");
            hasMore = true;
            while (hasMore) {
                hasMore = statReader.readHighFreqSqlStat(this.logList, READ_MAX_SIZE);
                this.writeAndFlush(this.logList.toArray(new String[0]), 0, this.logList.size());
                this.logList.clear();
            }
        }
        if (StatFlusher.isSlowSqlStatEnabled()) {
            this.logList.add("#top " + DmSvcConf.statSlowSqlCount + " slow sql stat");
            hasMore = true;
            while (hasMore) {
                hasMore = statReader.readSlowSqlStat(this.logList, READ_MAX_SIZE);
                this.writeAndFlush(this.logList.toArray(new String[0]), 0, this.logList.size());
                this.logList.clear();
            }
        }
        this.logList.add(StringUtil.LINE_SEPARATOR);
        this.logList.add(StringUtil.LINE_SEPARATOR);
        this.writeAndFlush(this.logList.toArray(new String[0]), 0, this.logList.size());
        this.logList.clear();
    }

    protected void beforeExit() throws Exception {
        this.doStat();
    }

    protected void writeAndFlush(String[] logs, int startOff, int len) {
        byte[] bytes = null;
        int i = startOff;
        while (i < startOff + len) {
            bytes = (String.valueOf(logs[i]) + StringUtil.LINE_SEPARATOR).getBytes();
            this.buffer.addBytes(bytes, 0, bytes.length);
            if (this.buffer.length() >= 32768) {
                this.doFlush(this.buffer);
            }
            ++i;
        }
        if (this.buffer.length() > 0) {
            this.doFlush(this.buffer);
        }
    }

    /* synthetic */ StatFlusher(StatFlusher statFlusher) {
        this();
    }

    private static class StatFlusherThreadHolder {
        private static final StatFlusher instance = new StatFlusher(null);

        private StatFlusherThreadHolder() {
        }
    }
}

