/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.filter;

import dm.jdbc.desc.DmSvcConf;
import dm.jdbc.driver.DmDriver;
import dm.jdbc.driver.DmdbCallableStatement;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbDatabaseMetaData;
import dm.jdbc.driver.DmdbParameterMetaData;
import dm.jdbc.driver.DmdbPreparedStatement;
import dm.jdbc.driver.DmdbResultSet;
import dm.jdbc.driver.DmdbResultSetMetaData;
import dm.jdbc.driver.DmdbStatement;
import dm.jdbc.filter.BaseFilter;
import dm.jdbc.filter.LogFilter;
import dm.jdbc.filter.StatFilter;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.RowIdLifetime;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;

public class FilterChain {
    private List<BaseFilter> filterList = new ArrayList<BaseFilter>();
    private int filterSize = 0;
    private int pos = 0;

    public FilterChain() {
        if (DmSvcConf.logLevel > 0) {
            this.filterList.add(LogFilter.getInstance());
        }
        if (DmSvcConf.statEnable) {
            this.filterList.add(StatFilter.getInstance());
        }
        this.filterSize = this.filterList.size();
    }

    public BaseFilter nextFilter() {
        if (this.pos < this.filterSize) {
            return this.filterList.get(this.pos++);
        }
        return null;
    }

    public FilterChain reset() {
        this.pos = 0;
        return this;
    }

    public void Connection_abort(DmdbConnection connection, Executor executor) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.Connection_abort(this, connection, executor);
            return;
        }
        connection.do_abort(executor);
    }

    public void Connection_clearWarnings(DmdbConnection connection) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.Connection_clearWarnings(this, connection);
            return;
        }
        connection.do_clearWarnings();
    }

    public void Connection_close(DmdbConnection connection) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.Connection_close(this, connection);
            return;
        }
        connection.do_close();
    }

    public void Connection_commit(DmdbConnection connection) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.Connection_commit(this, connection);
            return;
        }
        connection.do_commit();
    }

    public void Connection_create(DmdbConnection connection) {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.Connection_create(this, connection);
        }
    }

    public Array Connection_createArrayOf(DmdbConnection connection, String typeName, Object[] elements) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.Connection_createArrayOf(this, connection, typeName, elements);
        }
        return connection.do_createArrayOf(typeName, elements);
    }

    public Blob Connection_createBlob(DmdbConnection connection) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.Connection_createBlob(this, connection);
        }
        return connection.do_createBlob();
    }

    public Clob Connection_createClob(DmdbConnection connection) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.Connection_createClob(this, connection);
        }
        return connection.do_createClob();
    }

    public NClob Connection_createNClob(DmdbConnection connection) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.Connection_createNClob(this, connection);
        }
        return connection.do_createNClob();
    }

    public SQLXML Connection_createSQLXML(DmdbConnection connection) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.Connection_createSQLXML(this, connection);
        }
        return connection.do_createSQLXML();
    }

    public Statement Connection_createStatement(DmdbConnection connection) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.Connection_createStatement(this, connection);
        }
        return connection.do_createStatement();
    }

    public Statement Connection_createStatement(DmdbConnection connection, int resultSetType, int resultSetConcurrency) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.Connection_createStatement(this, connection, resultSetType, resultSetConcurrency);
        }
        return connection.do_createStatement(resultSetType, resultSetConcurrency);
    }

    public Statement Connection_createStatement(DmdbConnection connection, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.Connection_createStatement(this, connection, resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        return connection.do_createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    public Struct Connection_createStruct(DmdbConnection connection, String typeName, Object[] attributes) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.Connection_createStruct(this, connection, typeName, attributes);
        }
        return connection.do_createStruct(typeName, attributes);
    }

    public boolean Connection_getAutoCommit(DmdbConnection connection) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.Connection_getAutoCommit(this, connection);
        }
        return connection.do_getAutoCommit();
    }

    public String Connection_getCatalog(DmdbConnection connection) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.Connection_getCatalog(this, connection);
        }
        return connection.do_getCatalog();
    }

    public Properties Connection_getClientInfo(DmdbConnection connection) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.Connection_getClientInfo(this, connection);
        }
        return connection.do_getClientInfo();
    }

    public String Connection_getClientInfo(DmdbConnection connection, String name) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.Connection_getClientInfo(this, connection, name);
        }
        return connection.do_getClientInfo(name);
    }

    public int Connection_getHoldability(DmdbConnection connection) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.Connection_getHoldability(this, connection);
        }
        return connection.do_getHoldability();
    }

    public DatabaseMetaData Connection_getMetaData(DmdbConnection connection) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.Connection_getMetaData(this, connection);
        }
        return connection.do_getMetaData();
    }

    public int Connection_getNetworkTimeout(DmdbConnection connection) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.Connection_getNetworkTimeout(this, connection);
        }
        return connection.do_getNetworkTimeout();
    }

    public String Connection_getSchema(DmdbConnection connection) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.Connection_getSchema(this, connection);
        }
        return connection.do_getSchema();
    }

    public int Connection_getTransactionIsolation(DmdbConnection connection) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.Connection_getTransactionIsolation(this, connection);
        }
        return connection.do_getTransactionIsolation();
    }

    public Map<String, Class<?>> Connection_getTypeMap(DmdbConnection connection) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.Connection_getTypeMap(this, connection);
        }
        return connection.do_getTypeMap();
    }

    public SQLWarning Connection_getWarnings(DmdbConnection connection) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.Connection_getWarnings(this, connection);
        }
        return connection.do_getWarnings();
    }

    public boolean Connection_isClosed(DmdbConnection connection) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.Connection_isClosed(this, connection);
        }
        return connection.do_isClosed();
    }

    public boolean Connection_isReadOnly(DmdbConnection connection) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.Connection_isReadOnly(this, connection);
        }
        return connection.do_isReadOnly();
    }

    public boolean Connection_isValid(DmdbConnection connection, int timeout) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.Connection_isValid(this, connection, timeout);
        }
        return connection.do_isValid(timeout);
    }

    public String Connection_nativeSQL(DmdbConnection connection, String sql) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.Connection_nativeSQL(this, connection, sql);
        }
        return connection.do_nativeSQL(sql);
    }

    public CallableStatement Connection_prepareCall(DmdbConnection connection, String sql) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.Connection_prepareCall(this, connection, sql);
        }
        return connection.do_prepareCall(sql);
    }

    public CallableStatement Connection_prepareCall(DmdbConnection connection, String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.Connection_prepareCall(this, connection, sql, resultSetType, resultSetConcurrency);
        }
        return connection.do_prepareCall(sql, resultSetType, resultSetConcurrency);
    }

    public CallableStatement Connection_prepareCall(DmdbConnection connection, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.Connection_prepareCall(this, connection, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        return connection.do_prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    public PreparedStatement Connection_prepareStatement(DmdbConnection connection, String sql) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.Connection_prepareStatement(this, connection, sql);
        }
        return connection.do_prepareStatement(sql);
    }

    public PreparedStatement Connection_prepareStatement(DmdbConnection connection, String sql, String[] columnNames) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.Connection_prepareStatement(this, connection, sql, columnNames);
        }
        return connection.do_prepareStatement(sql, columnNames);
    }

    public PreparedStatement Connection_prepareStatement(DmdbConnection connection, String sql, int autoGeneratedKeys) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.Connection_prepareStatement(this, connection, sql, autoGeneratedKeys);
        }
        return connection.do_prepareStatement(sql, autoGeneratedKeys);
    }

    public PreparedStatement Connection_prepareStatement(DmdbConnection connection, String sql, int[] columnIndexes) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.Connection_prepareStatement(this, connection, sql, columnIndexes);
        }
        return connection.do_prepareStatement(sql, columnIndexes);
    }

    public PreparedStatement Connection_prepareStatement(DmdbConnection connection, String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.Connection_prepareStatement(this, connection, sql, resultSetType, resultSetConcurrency);
        }
        return connection.do_prepareStatement(sql, resultSetType, resultSetConcurrency);
    }

    public PreparedStatement Connection_prepareStatement(DmdbConnection connection, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.Connection_prepareStatement(this, connection, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        return connection.do_prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    public void Connection_releaseSavepoint(DmdbConnection connection, Savepoint savepoint) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.Connection_releaseSavepoint(this, connection, savepoint);
            return;
        }
        connection.do_releaseSavepoint(savepoint);
    }

    public void Connection_rollback(DmdbConnection connection) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.Connection_rollback(this, connection);
            return;
        }
        connection.do_rollback();
    }

    public void Connection_rollback(DmdbConnection connection, Savepoint savepoint) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.Connection_rollback(this, connection, savepoint);
            return;
        }
        connection.do_rollback(savepoint);
    }

    public void Connection_setAutoCommit(DmdbConnection connection, boolean autoCommit) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.Connection_setAutoCommit(this, connection, autoCommit);
            return;
        }
        connection.do_setAutoCommit(autoCommit);
    }

    public void Connection_setCatalog(DmdbConnection connection, String catalog) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.Connection_setCatalog(this, connection, catalog);
            return;
        }
        connection.do_setCatalog(catalog);
    }

    public void Connection_setClientInfo(DmdbConnection connection, Properties properties) throws SQLClientInfoException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.Connection_setClientInfo(this, connection, properties);
            return;
        }
        connection.do_setClientInfo(properties);
    }

    public void Connection_setClientInfo(DmdbConnection connection, String name, String value) throws SQLClientInfoException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.Connection_setClientInfo(this, connection, name, value);
            return;
        }
        connection.do_setClientInfo(name, value);
    }

    public void Connection_setHoldability(DmdbConnection connection, int holdability) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.Connection_setHoldability(this, connection, holdability);
            return;
        }
        connection.do_setHoldability(holdability);
    }

    public void Connection_setNetworkTimeout(DmdbConnection connection, Executor executor, int milliseconds) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.Connection_setNetworkTimeout(this, connection, executor, milliseconds);
            return;
        }
        connection.do_setNetworkTimeout(executor, milliseconds);
    }

    public void Connection_setReadOnly(DmdbConnection connection, boolean readOnly) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.Connection_setReadOnly(this, connection, readOnly);
            return;
        }
        connection.do_setReadOnly(readOnly);
    }

    public Savepoint Connection_setSavepoint(DmdbConnection connection) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.Connection_setSavepoint(this, connection);
        }
        return connection.do_setSavepoint();
    }

    public Savepoint Connection_setSavepoint(DmdbConnection connection, String name) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.Connection_setSavepoint(this, connection, name);
        }
        return connection.do_setSavepoint(name);
    }

    public void Connection_setSchema(DmdbConnection connection, String schema) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.Connection_setSchema(this, connection, schema);
            return;
        }
        connection.do_setSchema(schema);
    }

    public void Connection_setTransactionIsolation(DmdbConnection connection, int level) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.Connection_setTransactionIsolation(this, connection, level);
            return;
        }
        connection.do_setTransactionIsolation(level);
    }

    public void Connection_setTypeMap(DmdbConnection connection, Map<String, Class<?>> map) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.Connection_setTypeMap(this, connection, map);
            return;
        }
        connection.do_setTypeMap(map);
    }

    public void Statement_addBatch(DmdbStatement statement, String sql) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.Statement_addBatch(this, statement, sql);
            return;
        }
        statement.do_addBatch(sql);
    }

    public void Statement_cancel(DmdbStatement statement) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.Statement_cancel(this, statement);
            return;
        }
        statement.do_cancel();
    }

    public void Statement_clearBatch(DmdbStatement statement) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.Statement_clearBatch(this, statement);
            return;
        }
        statement.do_clearBatch();
    }

    public void Statement_clearWarnings(DmdbStatement statement) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.Statement_clearWarnings(this, statement);
            return;
        }
        statement.do_clearWarnings();
    }

    public void Statement_close(DmdbStatement statement) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.Statement_close(this, statement);
            return;
        }
        statement.do_close();
    }

    public void Statement_closeOnCompletion(DmdbStatement statement) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.Statement_closeOnCompletion(this, statement);
            return;
        }
        statement.do_closeOnCompletion();
    }

    public boolean Statement_execute(DmdbStatement statement, String sql) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.Statement_execute(this, statement, sql);
        }
        return statement.do_execute(sql);
    }

    public boolean Statement_execute(DmdbStatement statement, String sql, String[] columnNames) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.Statement_execute(this, statement, sql, columnNames);
        }
        return statement.do_execute(sql, columnNames);
    }

    public boolean Statement_execute(DmdbStatement statement, String sql, int autoGeneratedKeys) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.Statement_execute(this, statement, sql, autoGeneratedKeys);
        }
        return statement.do_execute(sql, autoGeneratedKeys);
    }

    public boolean Statement_execute(DmdbStatement statement, String sql, int[] columnIndexes) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.Statement_execute(this, statement, sql, columnIndexes);
        }
        return statement.do_execute(sql, columnIndexes);
    }

    public int[] Statement_executeBatch(DmdbStatement statement) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.Statement_executeBatch(this, statement);
        }
        return statement.do_executeBatch();
    }

    public ResultSet Statement_executeQuery(DmdbStatement statement, String sql) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.Statement_executeQuery(this, statement, sql);
        }
        return statement.do_executeQuery(sql);
    }

    public int Statement_executeUpdate(DmdbStatement statement, String sql) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.Statement_executeUpdate(this, statement, sql);
        }
        return statement.do_executeUpdate(sql);
    }

    public int Statement_executeUpdate(DmdbStatement statement, String sql, String[] columnNames) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.Statement_executeUpdate(this, statement, sql, columnNames);
        }
        return statement.do_executeUpdate(sql, columnNames);
    }

    public int Statement_executeUpdate(DmdbStatement statement, String sql, int autoGeneratedKeys) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.Statement_executeUpdate(this, statement, sql, autoGeneratedKeys);
        }
        return statement.do_executeUpdate(sql, autoGeneratedKeys);
    }

    public int Statement_executeUpdate(DmdbStatement statement, String sql, int[] columnIndexes) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.Statement_executeUpdate(this, statement, sql, columnIndexes);
        }
        return statement.do_executeUpdate(sql, columnIndexes);
    }

    public Connection Statement_getConnection(DmdbStatement statement) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.Statement_getConnection(this, statement);
        }
        return statement.do_getConnection();
    }

    public int Statement_getFetchDirection(DmdbStatement statement) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.Statement_getFetchDirection(this, statement);
        }
        return statement.do_getFetchDirection();
    }

    public int Statement_getFetchSize(DmdbStatement statement) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.Statement_getFetchSize(this, statement);
        }
        return statement.do_getFetchSize();
    }

    public ResultSet Statement_getGeneratedKeys(DmdbStatement statement) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.Statement_getGeneratedKeys(this, statement);
        }
        return statement.do_getGeneratedKeys();
    }

    public long Statement_getLargeUpdateCount(DmdbStatement dmdbStatement) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.Statement_getLargeUpdateCount(this, dmdbStatement);
        }
        return dmdbStatement.do_getLargeUpdateCount();
    }

    public int Statement_getMaxFieldSize(DmdbStatement statement) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.Statement_getMaxFieldSize(this, statement);
        }
        return statement.do_getMaxFieldSize();
    }

    public int Statement_getMaxRows(DmdbStatement statement) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.Statement_getMaxRows(this, statement);
        }
        return statement.do_getMaxRows();
    }

    public boolean Statement_getMoreResults(DmdbStatement statement) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.Statement_getMoreResults(this, statement);
        }
        return statement.do_getMoreResults();
    }

    public boolean Statement_getMoreResults(DmdbStatement statement, int current) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.Statement_getMoreResults(this, statement, current);
        }
        return statement.do_getMoreResults(current);
    }

    public int Statement_getQueryTimeout(DmdbStatement statement) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.Statement_getQueryTimeout(this, statement);
        }
        return statement.do_getQueryTimeout();
    }

    public ResultSet Statement_getResultSet(DmdbStatement statement) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.Statement_getResultSet(this, statement);
        }
        return statement.do_getResultSet();
    }

    public int Statement_getResultSetConcurrency(DmdbStatement statement) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.Statement_getResultSetConcurrency(this, statement);
        }
        return statement.do_getResultSetConcurrency();
    }

    public int Statement_getResultSetHoldability(DmdbStatement statement) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.Statement_getResultSetHoldability(this, statement);
        }
        return statement.do_getResultSetHoldability();
    }

    public int Statement_getResultSetType(DmdbStatement statement) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.Statement_getResultSetType(this, statement);
        }
        return statement.do_getResultSetType();
    }

    public int Statement_getUpdateCount(DmdbStatement statement) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.Statement_getUpdateCount(this, statement);
        }
        return statement.do_getUpdateCount();
    }

    public SQLWarning Statement_getWarnings(DmdbStatement statement) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.Statement_getWarnings(this, statement);
        }
        return statement.do_getWarnings();
    }

    public boolean Statement_isCloseOnCompletion(DmdbStatement statement) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.Statement_isCloseOnCompletion(this, statement);
        }
        return statement.do_isCloseOnCompletion();
    }

    public boolean Statement_isClosed(DmdbStatement statement) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.Statement_isClosed(this, statement);
        }
        return statement.do_isClosed();
    }

    public boolean Statement_isPoolable(DmdbStatement statement) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.Statement_isPoolable(this, statement);
        }
        return statement.do_isPoolable();
    }

    public void Statement_setCursorName(DmdbStatement statement, String name) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.Statement_setCursorName(this, statement, name);
            return;
        }
        statement.do_setCursorName(name);
    }

    public void Statement_setEscapeProcessing(DmdbStatement statement, boolean enable) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.Statement_setEscapeProcessing(this, statement, enable);
            return;
        }
        statement.do_setEscapeProcessing(enable);
    }

    public void Statement_setFetchDirection(DmdbStatement statement, int direction) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.Statement_setFetchDirection(this, statement, direction);
            return;
        }
        statement.do_setFetchDirection(direction);
    }

    public void Statement_setFetchSize(DmdbStatement statement, int rows) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.Statement_setFetchSize(this, statement, rows);
            return;
        }
        statement.do_setFetchSize(rows);
    }

    public void Statement_setLargeMaxRows(DmdbStatement dmdbStatement, long max) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.Statement_setLargeMaxRows(this, dmdbStatement, max);
            return;
        }
        dmdbStatement.do_setLargeMaxRows(max);
    }

    public void Statement_setMaxFieldSize(DmdbStatement statement, int max) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.Statement_setMaxFieldSize(this, statement, max);
            return;
        }
        statement.do_setMaxFieldSize(max);
    }

    public void Statement_setMaxRows(DmdbStatement statement, int max) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.Statement_setMaxRows(this, statement, max);
            return;
        }
        statement.do_setMaxRows(max);
    }

    public void Statement_setPoolable(DmdbStatement statement, boolean poolable) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.Statement_setPoolable(this, statement, poolable);
            return;
        }
        statement.do_setPoolable(poolable);
    }

    public void Statement_setQueryTimeout(DmdbStatement statement, int seconds) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.Statement_setQueryTimeout(this, statement, seconds);
            return;
        }
        statement.do_setQueryTimeout(seconds);
    }

    public void PreparedStatement_addBatch(DmdbPreparedStatement preparedStatement) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.PreparedStatement_addBatch(this, preparedStatement);
            return;
        }
        preparedStatement.do_addBatch();
    }

    public void PreparedStatement_clearParameters(DmdbPreparedStatement preparedStatement) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.PreparedStatement_clearParameters(this, preparedStatement);
            return;
        }
        preparedStatement.do_clearParameters();
    }

    public void PreparedStatement_close(DmdbPreparedStatement preparedStatement) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.PreparedStatement_close(this, preparedStatement);
        } else {
            preparedStatement.do_close();
        }
    }

    public boolean PreparedStatement_execute(DmdbPreparedStatement preparedStatement) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.PreparedStatement_execute(this, preparedStatement);
        }
        return preparedStatement.do_execute();
    }

    public int[] PreparedStatement_executeBatch(DmdbPreparedStatement preparedStatement) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.PreparedStatement_executeBatch(this, preparedStatement);
        }
        return preparedStatement.do_executeBatch();
    }

    public ResultSet PreparedStatement_executeQuery(DmdbPreparedStatement preparedStatement) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.PreparedStatement_executeQuery(this, preparedStatement);
        }
        return preparedStatement.do_executeQuery();
    }

    public int PreparedStatement_executeUpdate(DmdbPreparedStatement preparedStatement) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.PreparedStatement_executeUpdate(this, preparedStatement);
        }
        return preparedStatement.do_executeUpdate();
    }

    public ResultSetMetaData PreparedStatement_getMetaData(DmdbPreparedStatement preparedStatement) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.PreparedStatement_getMetaData(this, preparedStatement);
        }
        return preparedStatement.do_getMetaData();
    }

    public ParameterMetaData PreparedStatement_getParameterMetaData(DmdbPreparedStatement preparedStatement) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.PreparedStatement_getParameterMetaData(this, preparedStatement);
        }
        return preparedStatement.do_getParameterMetaData();
    }

    public void PreparedStatement_setArray(DmdbPreparedStatement preparedStatement, int parameterIndex, Array x) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.PreparedStatement_setArray(this, preparedStatement, parameterIndex, x);
            return;
        }
        preparedStatement.do_setArray(parameterIndex, x);
    }

    public void PreparedStatement_setAsciiStream(DmdbPreparedStatement preparedStatement, int parameterIndex, InputStream x) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.PreparedStatement_setAsciiStream(this, preparedStatement, parameterIndex, x);
            return;
        }
        preparedStatement.do_setAsciiStream(parameterIndex, x);
    }

    public void PreparedStatement_setAsciiStream(DmdbPreparedStatement preparedStatement, int parameterIndex, InputStream x, int length) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.PreparedStatement_setAsciiStream(this, preparedStatement, parameterIndex, x, length);
            return;
        }
        preparedStatement.do_setAsciiStream(parameterIndex, x, length);
    }

    public void PreparedStatement_setAsciiStream(DmdbPreparedStatement preparedStatement, int parameterIndex, InputStream x, long length) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.PreparedStatement_setAsciiStream(this, preparedStatement, parameterIndex, x, length);
            return;
        }
        preparedStatement.do_setAsciiStream(parameterIndex, x, length);
    }

    public void PreparedStatement_setBigDecimal(DmdbPreparedStatement preparedStatement, int parameterIndex, BigDecimal x) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.PreparedStatement_setBigDecimal(this, preparedStatement, parameterIndex, x);
            return;
        }
        preparedStatement.do_setBigDecimal(parameterIndex, x);
    }

    public void PreparedStatement_setBinaryStream(DmdbPreparedStatement preparedStatement, int parameterIndex, InputStream x) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.PreparedStatement_setBinaryStream(this, preparedStatement, parameterIndex, x);
            return;
        }
        preparedStatement.do_setBinaryStream(parameterIndex, x);
    }

    public void PreparedStatement_setBinaryStream(DmdbPreparedStatement preparedStatement, int parameterIndex, InputStream x, int length) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.PreparedStatement_setBinaryStream(this, preparedStatement, parameterIndex, x, length);
            return;
        }
        preparedStatement.do_setBinaryStream(parameterIndex, x, length);
    }

    public void PreparedStatement_setBinaryStream(DmdbPreparedStatement preparedStatement, int parameterIndex, InputStream x, long length) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.PreparedStatement_setBinaryStream(this, preparedStatement, parameterIndex, x, length);
            return;
        }
        preparedStatement.do_setBinaryStream(parameterIndex, x, length);
    }

    public void PreparedStatement_setBlob(DmdbPreparedStatement preparedStatement, int parameterIndex, Blob x) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.PreparedStatement_setBlob(this, preparedStatement, parameterIndex, x);
            return;
        }
        preparedStatement.do_setBlob(parameterIndex, x);
    }

    public void PreparedStatement_setBlob(DmdbPreparedStatement preparedStatement, int parameterIndex, InputStream inputStream) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.PreparedStatement_setBlob(this, preparedStatement, parameterIndex, inputStream);
            return;
        }
        preparedStatement.do_setBlob(parameterIndex, inputStream);
    }

    public void PreparedStatement_setBlob(DmdbPreparedStatement preparedStatement, int parameterIndex, InputStream inputStream, long length) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.PreparedStatement_setBlob(this, preparedStatement, parameterIndex, inputStream, length);
            return;
        }
        preparedStatement.do_setBlob(parameterIndex, inputStream, length);
    }

    public void PreparedStatement_setBoolean(DmdbPreparedStatement preparedStatement, int parameterIndex, boolean x) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.PreparedStatement_setBoolean(this, preparedStatement, parameterIndex, x);
            return;
        }
        preparedStatement.do_setBoolean(parameterIndex, x);
    }

    public void PreparedStatement_setByte(DmdbPreparedStatement preparedStatement, int parameterIndex, byte x) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.PreparedStatement_setByte(this, preparedStatement, parameterIndex, x);
            return;
        }
        preparedStatement.do_setByte(parameterIndex, x);
    }

    public void PreparedStatement_setBytes(DmdbPreparedStatement preparedStatement, int parameterIndex, byte[] x) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.PreparedStatement_setBytes(this, preparedStatement, parameterIndex, x);
            return;
        }
        preparedStatement.do_setBytes(parameterIndex, x);
    }

    public void PreparedStatement_setCharacterStream(DmdbPreparedStatement preparedStatement, int parameterIndex, Reader reader) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.PreparedStatement_setCharacterStream(this, preparedStatement, parameterIndex, reader);
            return;
        }
        preparedStatement.do_setCharacterStream(parameterIndex, reader);
    }

    public void PreparedStatement_setCharacterStream(DmdbPreparedStatement preparedStatement, int parameterIndex, Reader reader, int length) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.PreparedStatement_setCharacterStream(this, preparedStatement, parameterIndex, reader, length);
            return;
        }
        preparedStatement.do_setCharacterStream(parameterIndex, reader, length);
    }

    public void PreparedStatement_setCharacterStream(DmdbPreparedStatement preparedStatement, int parameterIndex, Reader reader, long length) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.PreparedStatement_setCharacterStream(this, preparedStatement, parameterIndex, reader, length);
            return;
        }
        preparedStatement.do_setCharacterStream(parameterIndex, reader, length);
    }

    public void PreparedStatement_setClob(DmdbPreparedStatement preparedStatement, int parameterIndex, Clob x) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.PreparedStatement_setClob(this, preparedStatement, parameterIndex, x);
            return;
        }
        preparedStatement.do_setClob(parameterIndex, x);
    }

    public void PreparedStatement_setClob(DmdbPreparedStatement preparedStatement, int parameterIndex, Reader reader) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.PreparedStatement_setClob(this, preparedStatement, parameterIndex, reader);
            return;
        }
        preparedStatement.do_setClob(parameterIndex, reader);
    }

    public void PreparedStatement_setClob(DmdbPreparedStatement preparedStatement, int parameterIndex, Reader reader, long length) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.PreparedStatement_setClob(this, preparedStatement, parameterIndex, reader, length);
            return;
        }
        preparedStatement.do_setClob(parameterIndex, reader, length);
    }

    public void PreparedStatement_setDate(DmdbPreparedStatement preparedStatement, int parameterIndex, Date x) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.PreparedStatement_setDate(this, preparedStatement, parameterIndex, x);
            return;
        }
        preparedStatement.do_setDate(parameterIndex, x);
    }

    public void PreparedStatement_setDate(DmdbPreparedStatement preparedStatement, int parameterIndex, Date x, Calendar cal) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.PreparedStatement_setDate(this, preparedStatement, parameterIndex, x, cal);
            return;
        }
        preparedStatement.do_setDate(parameterIndex, x, cal);
    }

    public void PreparedStatement_setDouble(DmdbPreparedStatement preparedStatement, int parameterIndex, double x) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.PreparedStatement_setDouble(this, preparedStatement, parameterIndex, x);
            return;
        }
        preparedStatement.do_setDouble(parameterIndex, x);
    }

    public void PreparedStatement_setFloat(DmdbPreparedStatement preparedStatement, int parameterIndex, float x) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.PreparedStatement_setFloat(this, preparedStatement, parameterIndex, x);
            return;
        }
        preparedStatement.do_setFloat(parameterIndex, x);
    }

    public void PreparedStatement_setInt(DmdbPreparedStatement preparedStatement, int parameterIndex, int x) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.PreparedStatement_setInt(this, preparedStatement, parameterIndex, x);
            return;
        }
        preparedStatement.do_setInt(parameterIndex, x);
    }

    public void PreparedStatement_setLong(DmdbPreparedStatement preparedStatement, int parameterIndex, long x) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.PreparedStatement_setLong(this, preparedStatement, parameterIndex, x);
            return;
        }
        preparedStatement.do_setLong(parameterIndex, x);
    }

    public void PreparedStatement_setNCharacterStream(DmdbPreparedStatement preparedStatement, int parameterIndex, Reader value) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.PreparedStatement_setNCharacterStream(this, preparedStatement, parameterIndex, value);
            return;
        }
        preparedStatement.do_setNCharacterStream(parameterIndex, value);
    }

    public void PreparedStatement_setNCharacterStream(DmdbPreparedStatement preparedStatement, int parameterIndex, Reader value, long length) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.PreparedStatement_setNCharacterStream(this, preparedStatement, parameterIndex, value, length);
            return;
        }
        preparedStatement.do_setNCharacterStream(parameterIndex, value, length);
    }

    public void PreparedStatement_setNClob(DmdbPreparedStatement preparedStatement, int parameterIndex, NClob value) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.PreparedStatement_setNClob(this, preparedStatement, parameterIndex, value);
            return;
        }
        preparedStatement.do_setNClob(parameterIndex, value);
    }

    public void PreparedStatement_setNClob(DmdbPreparedStatement preparedStatement, int parameterIndex, Reader reader) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.PreparedStatement_setNClob(this, preparedStatement, parameterIndex, reader);
            return;
        }
        preparedStatement.do_setNClob(parameterIndex, reader);
    }

    public void PreparedStatement_setNClob(DmdbPreparedStatement preparedStatement, int parameterIndex, Reader reader, long length) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.PreparedStatement_setNClob(this, preparedStatement, parameterIndex, reader, length);
            return;
        }
        preparedStatement.do_setNClob(parameterIndex, reader, length);
    }

    public void PreparedStatement_setNString(DmdbPreparedStatement preparedStatement, int parameterIndex, String value) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.PreparedStatement_setNString(this, preparedStatement, parameterIndex, value);
            return;
        }
        preparedStatement.do_setNString(parameterIndex, value);
    }

    public void PreparedStatement_setNull(DmdbPreparedStatement preparedStatement, int parameterIndex, int sqlType) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.PreparedStatement_setNull(this, preparedStatement, parameterIndex, sqlType);
            return;
        }
        preparedStatement.do_setNull(parameterIndex, sqlType);
    }

    public void PreparedStatement_setNull(DmdbPreparedStatement preparedStatement, int parameterIndex, int sqlType, String typeName) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.PreparedStatement_setNull(this, preparedStatement, parameterIndex, sqlType, typeName);
            return;
        }
        preparedStatement.do_setNull(parameterIndex, sqlType, typeName);
    }

    public void PreparedStatement_setObject(DmdbPreparedStatement preparedStatement, int parameterIndex, Object x) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.PreparedStatement_setObject(this, preparedStatement, parameterIndex, x);
            return;
        }
        preparedStatement.do_setObject(parameterIndex, x);
    }

    public void PreparedStatement_setObject(DmdbPreparedStatement preparedStatement, int parameterIndex, Object x, int targetSqlType) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.PreparedStatement_setObject(this, preparedStatement, parameterIndex, x, targetSqlType);
            return;
        }
        preparedStatement.do_setObject(parameterIndex, x, targetSqlType);
    }

    public void PreparedStatement_setObject(DmdbPreparedStatement preparedStatement, int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.PreparedStatement_setObject(this, preparedStatement, parameterIndex, x, targetSqlType, scaleOrLength);
            return;
        }
        preparedStatement.do_setObject(parameterIndex, x, targetSqlType, scaleOrLength);
    }

    public void PreparedStatement_setRef(DmdbPreparedStatement preparedStatement, int parameterIndex, Ref x) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.PreparedStatement_setRef(this, preparedStatement, parameterIndex, x);
            return;
        }
        preparedStatement.do_setRef(parameterIndex, x);
    }

    public void PreparedStatement_setRowId(DmdbPreparedStatement preparedStatement, int parameterIndex, RowId x) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.PreparedStatement_setRowId(this, preparedStatement, parameterIndex, x);
            return;
        }
        preparedStatement.do_setRowId(parameterIndex, x);
    }

    public void PreparedStatement_setSQLXML(DmdbPreparedStatement preparedStatement, int parameterIndex, SQLXML xmlObject) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.PreparedStatement_setSQLXML(this, preparedStatement, parameterIndex, xmlObject);
            return;
        }
        preparedStatement.do_setSQLXML(parameterIndex, xmlObject);
    }

    public void PreparedStatement_setShort(DmdbPreparedStatement preparedStatement, int parameterIndex, short x) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.PreparedStatement_setShort(this, preparedStatement, parameterIndex, x);
            return;
        }
        preparedStatement.do_setShort(parameterIndex, x);
    }

    public void PreparedStatement_setString(DmdbPreparedStatement preparedStatement, int parameterIndex, String x) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.PreparedStatement_setString(this, preparedStatement, parameterIndex, x);
            return;
        }
        preparedStatement.do_setString(parameterIndex, x);
    }

    public void PreparedStatement_setTime(DmdbPreparedStatement preparedStatement, int parameterIndex, Time x) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.PreparedStatement_setTime(this, preparedStatement, parameterIndex, x);
            return;
        }
        preparedStatement.do_setTime(parameterIndex, x);
    }

    public void PreparedStatement_setTime(DmdbPreparedStatement preparedStatement, int parameterIndex, Time x, Calendar cal) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.PreparedStatement_setTime(this, preparedStatement, parameterIndex, x, cal);
            return;
        }
        preparedStatement.do_setTime(parameterIndex, x, cal);
    }

    public void PreparedStatement_setTimestamp(DmdbPreparedStatement preparedStatement, int parameterIndex, Timestamp x) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.PreparedStatement_setTimestamp(this, preparedStatement, parameterIndex, x);
            return;
        }
        preparedStatement.do_setTimestamp(parameterIndex, x);
    }

    public void PreparedStatement_setTimestamp(DmdbPreparedStatement preparedStatement, int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.PreparedStatement_setTimestamp(this, preparedStatement, parameterIndex, x, cal);
            return;
        }
        preparedStatement.do_setTimestamp(parameterIndex, x, cal);
    }

    public void PreparedStatement_setURL(DmdbPreparedStatement preparedStatement, int parameterIndex, URL x) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.PreparedStatement_setURL(this, preparedStatement, parameterIndex, x);
            return;
        }
        preparedStatement.do_setURL(parameterIndex, x);
    }

    public void PreparedStatement_setUnicodeStream(DmdbPreparedStatement preparedStatement, int parameterIndex, InputStream x, int length) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.PreparedStatement_setUnicodeStream(this, preparedStatement, parameterIndex, x, length);
            return;
        }
        preparedStatement.do_setUnicodeStream(parameterIndex, x, length);
    }

    public void CallableStatement_close(DmdbCallableStatement dmdbCallableStatement) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.CallableStatement_close(this, dmdbCallableStatement);
        } else {
            dmdbCallableStatement.do_close();
        }
    }

    public Array CallableStatement_getArray(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.CallableStatement_getArray(this, callableStatement, parameterName);
        }
        return callableStatement.do_getArray(parameterName);
    }

    public Array CallableStatement_getArray(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.CallableStatement_getArray(this, callableStatement, parameterIndex);
        }
        return callableStatement.do_getArray(parameterIndex);
    }

    public BigDecimal CallableStatement_getBigDecimal(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.CallableStatement_getBigDecimal(this, callableStatement, parameterName);
        }
        return callableStatement.do_getBigDecimal(parameterName);
    }

    public BigDecimal CallableStatement_getBigDecimal(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.CallableStatement_getBigDecimal(this, callableStatement, parameterIndex);
        }
        return callableStatement.do_getBigDecimal(parameterIndex);
    }

    public BigDecimal CallableStatement_getBigDecimal(DmdbCallableStatement callableStatement, int parameterIndex, int scale) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.CallableStatement_getBigDecimal(this, callableStatement, parameterIndex, scale);
        }
        return callableStatement.do_getBigDecimal(parameterIndex, scale);
    }

    public Blob CallableStatement_getBlob(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.CallableStatement_getBlob(this, callableStatement, parameterName);
        }
        return callableStatement.do_getBlob(parameterName);
    }

    public Blob CallableStatement_getBlob(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.CallableStatement_getBlob(this, callableStatement, parameterIndex);
        }
        return callableStatement.do_getBlob(parameterIndex);
    }

    public boolean CallableStatement_getBoolean(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.CallableStatement_getBoolean(this, callableStatement, parameterName);
        }
        return callableStatement.do_getBoolean(parameterName);
    }

    public boolean CallableStatement_getBoolean(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.CallableStatement_getBoolean(this, callableStatement, parameterIndex);
        }
        return callableStatement.do_getBoolean(parameterIndex);
    }

    public byte CallableStatement_getByte(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.CallableStatement_getByte(this, callableStatement, parameterName);
        }
        return callableStatement.do_getByte(parameterName);
    }

    public byte CallableStatement_getByte(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.CallableStatement_getByte(this, callableStatement, parameterIndex);
        }
        return callableStatement.do_getByte(parameterIndex);
    }

    public byte[] CallableStatement_getBytes(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.CallableStatement_getBytes(this, callableStatement, parameterName);
        }
        return callableStatement.do_getBytes(parameterName);
    }

    public byte[] CallableStatement_getBytes(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.CallableStatement_getBytes(this, callableStatement, parameterIndex);
        }
        return callableStatement.do_getBytes(parameterIndex);
    }

    public Reader CallableStatement_getCharacterStream(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.CallableStatement_getCharacterStream(this, callableStatement, parameterName);
        }
        return callableStatement.do_getCharacterStream(parameterName);
    }

    public Reader CallableStatement_getCharacterStream(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.CallableStatement_getCharacterStream(this, callableStatement, parameterIndex);
        }
        return callableStatement.do_getCharacterStream(parameterIndex);
    }

    public Clob CallableStatement_getClob(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.CallableStatement_getClob(this, callableStatement, parameterName);
        }
        return callableStatement.do_getClob(parameterName);
    }

    public Clob CallableStatement_getClob(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.CallableStatement_getClob(this, callableStatement, parameterIndex);
        }
        return callableStatement.do_getClob(parameterIndex);
    }

    public Date CallableStatement_getDate(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.CallableStatement_getDate(this, callableStatement, parameterName);
        }
        return callableStatement.do_getDate(parameterName);
    }

    public Date CallableStatement_getDate(DmdbCallableStatement callableStatement, String parameterName, Calendar cal) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.CallableStatement_getDate(this, callableStatement, parameterName, cal);
        }
        return callableStatement.do_getDate(parameterName, cal);
    }

    public Date CallableStatement_getDate(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.CallableStatement_getDate(this, callableStatement, parameterIndex);
        }
        return callableStatement.do_getDate(parameterIndex);
    }

    public Date CallableStatement_getDate(DmdbCallableStatement callableStatement, int parameterIndex, Calendar cal) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.CallableStatement_getDate(this, callableStatement, parameterIndex, cal);
        }
        return callableStatement.do_getDate(parameterIndex, cal);
    }

    public double CallableStatement_getDouble(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.CallableStatement_getDouble(this, callableStatement, parameterName);
        }
        return callableStatement.do_getDouble(parameterName);
    }

    public double CallableStatement_getDouble(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.CallableStatement_getDouble(this, callableStatement, parameterIndex);
        }
        return callableStatement.do_getDouble(parameterIndex);
    }

    public float CallableStatement_getFloat(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.CallableStatement_getFloat(this, callableStatement, parameterName);
        }
        return callableStatement.do_getFloat(parameterName);
    }

    public float CallableStatement_getFloat(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.CallableStatement_getFloat(this, callableStatement, parameterIndex);
        }
        return callableStatement.do_getFloat(parameterIndex);
    }

    public int CallableStatement_getInt(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.CallableStatement_getInt(this, callableStatement, parameterName);
        }
        return callableStatement.do_getInt(parameterName);
    }

    public int CallableStatement_getInt(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.CallableStatement_getInt(this, callableStatement, parameterIndex);
        }
        return callableStatement.do_getInt(parameterIndex);
    }

    public long CallableStatement_getLong(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.CallableStatement_getLong(this, callableStatement, parameterName);
        }
        return callableStatement.do_getLong(parameterName);
    }

    public long CallableStatement_getLong(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.CallableStatement_getLong(this, callableStatement, parameterIndex);
        }
        return callableStatement.do_getLong(parameterIndex);
    }

    public Reader CallableStatement_getNCharacterStream(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.CallableStatement_getNCharacterStream(this, callableStatement, parameterName);
        }
        return callableStatement.do_getNCharacterStream(parameterName);
    }

    public Reader CallableStatement_getNCharacterStream(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.CallableStatement_getNCharacterStream(this, callableStatement, parameterIndex);
        }
        return callableStatement.do_getNCharacterStream(parameterIndex);
    }

    public NClob CallableStatement_getNClob(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.CallableStatement_getNClob(this, callableStatement, parameterName);
        }
        return callableStatement.do_getNClob(parameterName);
    }

    public NClob CallableStatement_getNClob(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.CallableStatement_getNClob(this, callableStatement, parameterIndex);
        }
        return callableStatement.do_getNClob(parameterIndex);
    }

    public String CallableStatement_getNString(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.CallableStatement_getNString(this, callableStatement, parameterName);
        }
        return callableStatement.do_getNString(parameterName);
    }

    public String CallableStatement_getNString(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.CallableStatement_getNString(this, callableStatement, parameterIndex);
        }
        return callableStatement.do_getNString(parameterIndex);
    }

    public Object CallableStatement_getObject(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.CallableStatement_getObject(this, callableStatement, parameterName);
        }
        return callableStatement.do_getObject(parameterName);
    }

    public <T> T CallableStatement_getObject(DmdbCallableStatement callableStatement, String parameterName, Class<T> type) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.CallableStatement_getObject(this, callableStatement, parameterName, type);
        }
        return callableStatement.do_getObject(parameterName, type);
    }

    public Object CallableStatement_getObject(DmdbCallableStatement callableStatement, String parameterName, Map<String, Class<?>> map) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.CallableStatement_getObject(this, callableStatement, parameterName, map);
        }
        return callableStatement.do_getObject(parameterName, map);
    }

    public Object CallableStatement_getObject(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.CallableStatement_getObject(this, callableStatement, parameterIndex);
        }
        return callableStatement.do_getObject(parameterIndex);
    }

    public <T> T CallableStatement_getObject(DmdbCallableStatement callableStatement, int parameterIndex, Class<T> type) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.CallableStatement_getObject(this, callableStatement, parameterIndex, type);
        }
        return callableStatement.do_getObject(parameterIndex, type);
    }

    public Object CallableStatement_getObject(DmdbCallableStatement callableStatement, int parameterIndex, Map<String, Class<?>> map) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.CallableStatement_getObject(this, callableStatement, parameterIndex, map);
        }
        return callableStatement.do_getObject(parameterIndex, map);
    }

    public Ref CallableStatement_getRef(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.CallableStatement_getRef(this, callableStatement, parameterName);
        }
        return callableStatement.do_getRef(parameterName);
    }

    public Ref CallableStatement_getRef(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.CallableStatement_getRef(this, callableStatement, parameterIndex);
        }
        return callableStatement.do_getRef(parameterIndex);
    }

    public RowId CallableStatement_getRowId(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.CallableStatement_getRowId(this, callableStatement, parameterName);
        }
        return callableStatement.do_getRowId(parameterName);
    }

    public RowId CallableStatement_getRowId(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.CallableStatement_getRowId(this, callableStatement, parameterIndex);
        }
        return callableStatement.do_getRowId(parameterIndex);
    }

    public SQLXML CallableStatement_getSQLXML(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.CallableStatement_getSQLXML(this, callableStatement, parameterName);
        }
        return callableStatement.do_getSQLXML(parameterName);
    }

    public SQLXML CallableStatement_getSQLXML(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.CallableStatement_getSQLXML(this, callableStatement, parameterIndex);
        }
        return callableStatement.do_getSQLXML(parameterIndex);
    }

    public short CallableStatement_getShort(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.CallableStatement_getShort(this, callableStatement, parameterName);
        }
        return callableStatement.do_getShort(parameterName);
    }

    public short CallableStatement_getShort(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.CallableStatement_getShort(this, callableStatement, parameterIndex);
        }
        return callableStatement.do_getShort(parameterIndex);
    }

    public String CallableStatement_getString(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.CallableStatement_getString(this, callableStatement, parameterName);
        }
        return callableStatement.do_getString(parameterName);
    }

    public String CallableStatement_getString(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.CallableStatement_getString(this, callableStatement, parameterIndex);
        }
        return callableStatement.do_getString(parameterIndex);
    }

    public Time CallableStatement_getTime(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.CallableStatement_getTime(this, callableStatement, parameterName);
        }
        return callableStatement.do_getTime(parameterName);
    }

    public Time CallableStatement_getTime(DmdbCallableStatement callableStatement, String parameterName, Calendar cal) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.CallableStatement_getTime(this, callableStatement, parameterName, cal);
        }
        return callableStatement.do_getTime(parameterName, cal);
    }

    public Time CallableStatement_getTime(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.CallableStatement_getTime(this, callableStatement, parameterIndex);
        }
        return callableStatement.do_getTime(parameterIndex);
    }

    public Time CallableStatement_getTime(DmdbCallableStatement callableStatement, int parameterIndex, Calendar cal) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.CallableStatement_getTime(this, callableStatement, parameterIndex, cal);
        }
        return callableStatement.do_getTime(parameterIndex, cal);
    }

    public Timestamp CallableStatement_getTimestamp(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.CallableStatement_getTimestamp(this, callableStatement, parameterName);
        }
        return callableStatement.do_getTimestamp(parameterName);
    }

    public Timestamp CallableStatement_getTimestamp(DmdbCallableStatement callableStatement, String parameterName, Calendar cal) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.CallableStatement_getTimestamp(this, callableStatement, parameterName, cal);
        }
        return callableStatement.do_getTimestamp(parameterName, cal);
    }

    public Timestamp CallableStatement_getTimestamp(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.CallableStatement_getTimestamp(this, callableStatement, parameterIndex);
        }
        return callableStatement.do_getTimestamp(parameterIndex);
    }

    public Timestamp CallableStatement_getTimestamp(DmdbCallableStatement callableStatement, int parameterIndex, Calendar cal) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.CallableStatement_getTimestamp(this, callableStatement, parameterIndex, cal);
        }
        return callableStatement.do_getTimestamp(parameterIndex, cal);
    }

    public URL CallableStatement_getURL(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.CallableStatement_getURL(this, callableStatement, parameterName);
        }
        return callableStatement.do_getURL(parameterName);
    }

    public URL CallableStatement_getURL(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.CallableStatement_getURL(this, callableStatement, parameterIndex);
        }
        return callableStatement.do_getURL(parameterIndex);
    }

    public void CallableStatement_registerOutParameter(DmdbCallableStatement callableStatement, String parameterName, int sqlType) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.CallableStatement_registerOutParameter(this, callableStatement, parameterName, sqlType);
            return;
        }
        callableStatement.do_registerOutParameter(parameterName, sqlType);
    }

    public void CallableStatement_registerOutParameter(DmdbCallableStatement callableStatement, String parameterName, int sqlType, String typeName) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.CallableStatement_registerOutParameter(this, callableStatement, parameterName, sqlType, typeName);
            return;
        }
        callableStatement.do_registerOutParameter(parameterName, sqlType, typeName);
    }

    public void CallableStatement_registerOutParameter(DmdbCallableStatement callableStatement, String parameterName, int sqlType, int scale) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.CallableStatement_registerOutParameter(this, callableStatement, parameterName, sqlType, scale);
            return;
        }
        callableStatement.do_registerOutParameter(parameterName, sqlType, scale);
    }

    public void CallableStatement_registerOutParameter(DmdbCallableStatement callableStatement, int parameterIndex, int sqlType) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.CallableStatement_registerOutParameter(this, callableStatement, parameterIndex, sqlType);
            return;
        }
        callableStatement.do_registerOutParameter(parameterIndex, sqlType);
    }

    public void CallableStatement_registerOutParameter(DmdbCallableStatement callableStatement, int parameterIndex, int sqlType, String typeName) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.CallableStatement_registerOutParameter(this, callableStatement, parameterIndex, sqlType, typeName);
            return;
        }
        callableStatement.do_registerOutParameter(parameterIndex, sqlType, typeName);
    }

    public void CallableStatement_registerOutParameter(DmdbCallableStatement callableStatement, int parameterIndex, int sqlType, int scale) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.CallableStatement_registerOutParameter(this, callableStatement, parameterIndex, sqlType, scale);
            return;
        }
        callableStatement.do_registerOutParameter(parameterIndex, sqlType, scale);
    }

    public void CallableStatement_setAsciiStream(DmdbCallableStatement callableStatement, String parameterName, InputStream x) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.CallableStatement_setAsciiStream(this, callableStatement, parameterName, x);
            return;
        }
        callableStatement.do_setAsciiStream(parameterName, x);
    }

    public void CallableStatement_setAsciiStream(DmdbCallableStatement callableStatement, String parameterName, InputStream x, int length) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.CallableStatement_setAsciiStream(this, callableStatement, parameterName, x, length);
            return;
        }
        callableStatement.do_setAsciiStream(parameterName, x, length);
    }

    public void CallableStatement_setAsciiStream(DmdbCallableStatement callableStatement, String parameterName, InputStream x, long length) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.CallableStatement_setAsciiStream(this, callableStatement, parameterName, x, length);
            return;
        }
        callableStatement.do_setAsciiStream(parameterName, x, length);
    }

    public void CallableStatement_setBigDecimal(DmdbCallableStatement callableStatement, String parameterName, BigDecimal x) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.CallableStatement_setBigDecimal(this, callableStatement, parameterName, x);
            return;
        }
        callableStatement.do_setBigDecimal(parameterName, x);
    }

    public void CallableStatement_setBinaryStream(DmdbCallableStatement callableStatement, String parameterName, InputStream x) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.CallableStatement_setBinaryStream(this, callableStatement, parameterName, x);
            return;
        }
        callableStatement.do_setBinaryStream(parameterName, x);
    }

    public void CallableStatement_setBinaryStream(DmdbCallableStatement callableStatement, String parameterName, InputStream x, int length) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.CallableStatement_setBinaryStream(this, callableStatement, parameterName, x, length);
            return;
        }
        callableStatement.do_setBinaryStream(parameterName, x, length);
    }

    public void CallableStatement_setBinaryStream(DmdbCallableStatement callableStatement, String parameterName, InputStream x, long length) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.CallableStatement_setBinaryStream(this, callableStatement, parameterName, x, length);
            return;
        }
        callableStatement.do_setBinaryStream(parameterName, x, length);
    }

    public void CallableStatement_setBlob(DmdbCallableStatement callableStatement, String parameterName, Blob x) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.CallableStatement_setBlob(this, callableStatement, parameterName, x);
            return;
        }
        callableStatement.do_setBlob(parameterName, x);
    }

    public void CallableStatement_setBlob(DmdbCallableStatement callableStatement, String parameterName, InputStream inputStream) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.CallableStatement_setBlob(this, callableStatement, parameterName, inputStream);
            return;
        }
        callableStatement.do_setBlob(parameterName, inputStream);
    }

    public void CallableStatement_setBlob(DmdbCallableStatement callableStatement, String parameterName, InputStream inputStream, long length) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.CallableStatement_setBlob(this, callableStatement, parameterName, inputStream, length);
            return;
        }
        callableStatement.do_setBlob(parameterName, inputStream, length);
    }

    public void CallableStatement_setBoolean(DmdbCallableStatement callableStatement, String parameterName, boolean x) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.CallableStatement_setBoolean(this, callableStatement, parameterName, x);
            return;
        }
        callableStatement.do_setBoolean(parameterName, x);
    }

    public void CallableStatement_setByte(DmdbCallableStatement callableStatement, String parameterName, byte x) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.CallableStatement_setByte(this, callableStatement, parameterName, x);
            return;
        }
        callableStatement.do_setByte(parameterName, x);
    }

    public void CallableStatement_setBytes(DmdbCallableStatement callableStatement, String parameterName, byte[] x) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.CallableStatement_setBytes(this, callableStatement, parameterName, x);
            return;
        }
        callableStatement.do_setBytes(parameterName, x);
    }

    public void CallableStatement_setCharacterStream(DmdbCallableStatement callableStatement, String parameterName, Reader reader) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.CallableStatement_setCharacterStream(this, callableStatement, parameterName, reader);
            return;
        }
        callableStatement.do_setCharacterStream(parameterName, reader);
    }

    public void CallableStatement_setCharacterStream(DmdbCallableStatement callableStatement, String parameterName, Reader reader, int length) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.CallableStatement_setCharacterStream(this, callableStatement, parameterName, reader, length);
            return;
        }
        callableStatement.do_setCharacterStream(parameterName, reader, length);
    }

    public void CallableStatement_setCharacterStream(DmdbCallableStatement callableStatement, String parameterName, Reader reader, long length) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.CallableStatement_setCharacterStream(this, callableStatement, parameterName, reader, length);
            return;
        }
        callableStatement.do_setCharacterStream(parameterName, reader, length);
    }

    public void CallableStatement_setClob(DmdbCallableStatement callableStatement, String parameterName, Clob x) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.CallableStatement_setClob(this, callableStatement, parameterName, x);
            return;
        }
        callableStatement.do_setClob(parameterName, x);
    }

    public void CallableStatement_setClob(DmdbCallableStatement callableStatement, String parameterName, Reader reader) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.CallableStatement_setClob(this, callableStatement, parameterName, reader);
            return;
        }
        callableStatement.do_setClob(parameterName, reader);
    }

    public void CallableStatement_setClob(DmdbCallableStatement callableStatement, String parameterName, Reader reader, long length) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.CallableStatement_setClob(this, callableStatement, parameterName, reader, length);
            return;
        }
        callableStatement.do_setClob(parameterName, reader, length);
    }

    public void CallableStatement_setDate(DmdbCallableStatement callableStatement, String parameterName, Date x) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.CallableStatement_setDate(this, callableStatement, parameterName, x);
            return;
        }
        callableStatement.do_setDate(parameterName, x);
    }

    public void CallableStatement_setDate(DmdbCallableStatement callableStatement, String parameterName, Date x, Calendar cal) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.CallableStatement_setDate(this, callableStatement, parameterName, x, cal);
            return;
        }
        callableStatement.do_setDate(parameterName, x, cal);
    }

    public void CallableStatement_setDouble(DmdbCallableStatement callableStatement, String parameterName, double x) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.CallableStatement_setDouble(this, callableStatement, parameterName, x);
            return;
        }
        callableStatement.do_setDouble(parameterName, x);
    }

    public void CallableStatement_setFloat(DmdbCallableStatement callableStatement, String parameterName, float x) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.CallableStatement_setFloat(this, callableStatement, parameterName, x);
            return;
        }
        callableStatement.do_setFloat(parameterName, x);
    }

    public void CallableStatement_setInt(DmdbCallableStatement callableStatement, String parameterName, int x) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.CallableStatement_setInt(this, callableStatement, parameterName, x);
            return;
        }
        callableStatement.do_setInt(parameterName, x);
    }

    public void CallableStatement_setLong(DmdbCallableStatement callableStatement, String parameterName, long x) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.CallableStatement_setLong(this, callableStatement, parameterName, x);
            return;
        }
        callableStatement.do_setLong(parameterName, x);
    }

    public void CallableStatement_setNCharacterStream(DmdbCallableStatement callableStatement, String parameterName, Reader value) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.CallableStatement_setNCharacterStream(this, callableStatement, parameterName, value);
            return;
        }
        callableStatement.do_setNCharacterStream(parameterName, value);
    }

    public void CallableStatement_setNCharacterStream(DmdbCallableStatement callableStatement, String parameterName, Reader value, long length) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.CallableStatement_setNCharacterStream(this, callableStatement, parameterName, value, length);
            return;
        }
        callableStatement.do_setNCharacterStream(parameterName, value, length);
    }

    public void CallableStatement_setNClob(DmdbCallableStatement callableStatement, String parameterName, NClob value) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.CallableStatement_setNClob(this, callableStatement, parameterName, value);
            return;
        }
        callableStatement.do_setNClob(parameterName, value);
    }

    public void CallableStatement_setNClob(DmdbCallableStatement callableStatement, String parameterName, Reader reader) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.CallableStatement_setNClob(this, callableStatement, parameterName, reader);
            return;
        }
        callableStatement.do_setNClob(parameterName, reader);
    }

    public void CallableStatement_setNClob(DmdbCallableStatement callableStatement, String parameterName, Reader reader, long length) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.CallableStatement_setNClob(this, callableStatement, parameterName, reader, length);
            return;
        }
        callableStatement.do_setNClob(parameterName, reader, length);
    }

    public void CallableStatement_setNString(DmdbCallableStatement callableStatement, String parameterName, String value) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.CallableStatement_setNString(this, callableStatement, parameterName, value);
            return;
        }
        callableStatement.do_setNString(parameterName, value);
    }

    public void CallableStatement_setNull(DmdbCallableStatement callableStatement, String parameterName, int sqlType) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.CallableStatement_setNull(this, callableStatement, parameterName, sqlType);
            return;
        }
        callableStatement.do_setNull(parameterName, sqlType);
    }

    public void CallableStatement_setNull(DmdbCallableStatement callableStatement, String parameterName, int sqlType, String typeName) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.CallableStatement_setNull(this, callableStatement, parameterName, sqlType, typeName);
            return;
        }
        callableStatement.do_setNull(parameterName, sqlType, typeName);
    }

    public void CallableStatement_setObject(DmdbCallableStatement callableStatement, String parameterName, Object x) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.CallableStatement_setObject(this, callableStatement, parameterName, x);
            return;
        }
        callableStatement.do_setObject(parameterName, x);
    }

    public void CallableStatement_setObject(DmdbCallableStatement callableStatement, String parameterName, Object x, int targetSqlType) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.CallableStatement_setObject(this, callableStatement, parameterName, x, targetSqlType);
            return;
        }
        callableStatement.do_setObject(parameterName, x, targetSqlType);
    }

    public void CallableStatement_setObject(DmdbCallableStatement callableStatement, String parameterName, Object x, int targetSqlType, int scale) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.CallableStatement_setObject(this, callableStatement, parameterName, x, targetSqlType, scale);
            return;
        }
        callableStatement.do_setObject(parameterName, x, targetSqlType, scale);
    }

    public void CallableStatement_setRowId(DmdbCallableStatement callableStatement, String parameterName, RowId x) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.CallableStatement_setRowId(this, callableStatement, parameterName, x);
            return;
        }
        callableStatement.do_setRowId(parameterName, x);
    }

    public void CallableStatement_setSQLXML(DmdbCallableStatement callableStatement, String parameterName, SQLXML xmlObject) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.CallableStatement_setSQLXML(this, callableStatement, parameterName, xmlObject);
            return;
        }
        callableStatement.do_setSQLXML(parameterName, xmlObject);
    }

    public void CallableStatement_setShort(DmdbCallableStatement callableStatement, String parameterName, short x) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.CallableStatement_setShort(this, callableStatement, parameterName, x);
            return;
        }
        callableStatement.do_setShort(parameterName, x);
    }

    public void CallableStatement_setString(DmdbCallableStatement callableStatement, String parameterName, String x) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.CallableStatement_setString(this, callableStatement, parameterName, x);
            return;
        }
        callableStatement.do_setString(parameterName, x);
    }

    public void CallableStatement_setTime(DmdbCallableStatement callableStatement, String parameterName, Time x) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.CallableStatement_setTime(this, callableStatement, parameterName, x);
            return;
        }
        callableStatement.do_setTime(parameterName, x);
    }

    public void CallableStatement_setTime(DmdbCallableStatement callableStatement, String parameterName, Time x, Calendar cal) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.CallableStatement_setTime(this, callableStatement, parameterName, x, cal);
            return;
        }
        callableStatement.do_setTime(parameterName, x, cal);
    }

    public void CallableStatement_setTimestamp(DmdbCallableStatement callableStatement, String parameterName, Timestamp x) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.CallableStatement_setTimestamp(this, callableStatement, parameterName, x);
            return;
        }
        callableStatement.do_setTimestamp(parameterName, x);
    }

    public void CallableStatement_setTimestamp(DmdbCallableStatement callableStatement, String parameterName, Timestamp x, Calendar cal) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.CallableStatement_setTimestamp(this, callableStatement, parameterName, x, cal);
            return;
        }
        callableStatement.do_setTimestamp(parameterName, x, cal);
    }

    public void CallableStatement_setURL(DmdbCallableStatement callableStatement, String parameterName, URL val) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.CallableStatement_setURL(this, callableStatement, parameterName, val);
            return;
        }
        callableStatement.do_setURL(parameterName, val);
    }

    public boolean CallableStatement_wasNull(DmdbCallableStatement callableStatement) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.CallableStatement_wasNull(this, callableStatement);
        }
        return callableStatement.do_wasNull();
    }

    public boolean ResultSet_absolute(DmdbResultSet resultSet, int row) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.ResultSet_absolute(this, resultSet, row);
        }
        return resultSet.do_absolute(row);
    }

    public void ResultSet_afterLast(DmdbResultSet resultSet) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.ResultSet_afterLast(this, resultSet);
            return;
        }
        resultSet.do_afterLast();
    }

    public void ResultSet_beforeFirst(DmdbResultSet resultSet) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.ResultSet_beforeFirst(this, resultSet);
            return;
        }
        resultSet.do_beforeFirst();
    }

    public void ResultSet_cancelRowUpdates(DmdbResultSet resultSet) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.ResultSet_cancelRowUpdates(this, resultSet);
            return;
        }
        resultSet.do_cancelRowUpdates();
    }

    public void ResultSet_clearWarnings(DmdbResultSet resultSet) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.ResultSet_clearWarnings(this, resultSet);
            return;
        }
        resultSet.do_clearWarnings();
    }

    public void ResultSet_close(DmdbResultSet resultSet) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.ResultSet_close(this, resultSet);
            return;
        }
        resultSet.do_close();
    }

    public void ResultSet_deleteRow(DmdbResultSet resultSet) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.ResultSet_deleteRow(this, resultSet);
            return;
        }
        resultSet.do_deleteRow();
    }

    public int ResultSet_findColumn(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.ResultSet_findColumn(this, resultSet, columnLabel);
        }
        return resultSet.do_findColumn(columnLabel);
    }

    public boolean ResultSet_first(DmdbResultSet resultSet) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.ResultSet_first(this, resultSet);
        }
        return resultSet.do_first();
    }

    public Array ResultSet_getArray(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.ResultSet_getArray(this, resultSet, columnLabel);
        }
        return resultSet.do_getArray(columnLabel);
    }

    public Array ResultSet_getArray(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.ResultSet_getArray(this, resultSet, columnIndex);
        }
        return resultSet.do_getArray(columnIndex);
    }

    public InputStream ResultSet_getAsciiStream(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.ResultSet_getAsciiStream(this, resultSet, columnLabel);
        }
        return resultSet.do_getAsciiStream(columnLabel);
    }

    public InputStream ResultSet_getAsciiStream(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.ResultSet_getAsciiStream(this, resultSet, columnIndex);
        }
        return resultSet.do_getAsciiStream(columnIndex);
    }

    public BigDecimal ResultSet_getBigDecimal(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.ResultSet_getBigDecimal(this, resultSet, columnLabel);
        }
        return resultSet.do_getBigDecimal(columnLabel);
    }

    public BigDecimal ResultSet_getBigDecimal(DmdbResultSet resultSet, String columnLabel, int scale) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.ResultSet_getBigDecimal(this, resultSet, columnLabel, scale);
        }
        return resultSet.do_getBigDecimal(columnLabel, scale);
    }

    public BigDecimal ResultSet_getBigDecimal(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.ResultSet_getBigDecimal(this, resultSet, columnIndex);
        }
        return resultSet.do_getBigDecimal(columnIndex);
    }

    public BigDecimal ResultSet_getBigDecimal(DmdbResultSet resultSet, int columnIndex, int scale) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.ResultSet_getBigDecimal(this, resultSet, columnIndex, scale);
        }
        return resultSet.do_getBigDecimal(columnIndex, scale);
    }

    public InputStream ResultSet_getBinaryStream(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.ResultSet_getBinaryStream(this, resultSet, columnLabel);
        }
        return resultSet.do_getBinaryStream(columnLabel);
    }

    public InputStream ResultSet_getBinaryStream(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.ResultSet_getBinaryStream(this, resultSet, columnIndex);
        }
        return resultSet.do_getBinaryStream(columnIndex);
    }

    public Blob ResultSet_getBlob(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.ResultSet_getBlob(this, resultSet, columnLabel);
        }
        return resultSet.do_getBlob(columnLabel);
    }

    public Blob ResultSet_getBlob(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.ResultSet_getBlob(this, resultSet, columnIndex);
        }
        return resultSet.do_getBlob(columnIndex);
    }

    public boolean ResultSet_getBoolean(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.ResultSet_getBoolean(this, resultSet, columnLabel);
        }
        return resultSet.do_getBoolean(columnLabel);
    }

    public boolean ResultSet_getBoolean(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.ResultSet_getBoolean(this, resultSet, columnIndex);
        }
        return resultSet.do_getBoolean(columnIndex);
    }

    public byte ResultSet_getByte(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.ResultSet_getByte(this, resultSet, columnLabel);
        }
        return resultSet.do_getByte(columnLabel);
    }

    public byte ResultSet_getByte(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.ResultSet_getByte(this, resultSet, columnIndex);
        }
        return resultSet.do_getByte(columnIndex);
    }

    public byte[] ResultSet_getBytes(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.ResultSet_getBytes(this, resultSet, columnLabel);
        }
        return resultSet.do_getBytes(columnLabel);
    }

    public byte[] ResultSet_getBytes(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.ResultSet_getBytes(this, resultSet, columnIndex);
        }
        return resultSet.do_getBytes(columnIndex);
    }

    public Reader ResultSet_getCharacterStream(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.ResultSet_getCharacterStream(this, resultSet, columnLabel);
        }
        return resultSet.do_getCharacterStream(columnLabel);
    }

    public Reader ResultSet_getCharacterStream(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.ResultSet_getCharacterStream(this, resultSet, columnIndex);
        }
        return resultSet.do_getCharacterStream(columnIndex);
    }

    public Clob ResultSet_getClob(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.ResultSet_getClob(this, resultSet, columnLabel);
        }
        return resultSet.do_getClob(columnLabel);
    }

    public Clob ResultSet_getClob(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.ResultSet_getClob(this, resultSet, columnIndex);
        }
        return resultSet.do_getClob(columnIndex);
    }

    public int ResultSet_getConcurrency(DmdbResultSet resultSet) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.ResultSet_getConcurrency(this, resultSet);
        }
        return resultSet.do_getConcurrency();
    }

    public String ResultSet_getCursorName(DmdbResultSet resultSet) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.ResultSet_getCursorName(this, resultSet);
        }
        return resultSet.do_getCursorName();
    }

    public Date ResultSet_getDate(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.ResultSet_getDate(this, resultSet, columnLabel);
        }
        return resultSet.do_getDate(columnLabel);
    }

    public Date ResultSet_getDate(DmdbResultSet resultSet, String columnLabel, Calendar cal) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.ResultSet_getDate(this, resultSet, columnLabel, cal);
        }
        return resultSet.do_getDate(columnLabel, cal);
    }

    public Date ResultSet_getDate(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.ResultSet_getDate(this, resultSet, columnIndex);
        }
        return resultSet.do_getDate(columnIndex);
    }

    public Date ResultSet_getDate(DmdbResultSet resultSet, int columnIndex, Calendar cal) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.ResultSet_getDate(this, resultSet, columnIndex, cal);
        }
        return resultSet.do_getDate(columnIndex, cal);
    }

    public double ResultSet_getDouble(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.ResultSet_getDouble(this, resultSet, columnLabel);
        }
        return resultSet.do_getDouble(columnLabel);
    }

    public double ResultSet_getDouble(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.ResultSet_getDouble(this, resultSet, columnIndex);
        }
        return resultSet.do_getDouble(columnIndex);
    }

    public int ResultSet_getFetchDirection(DmdbResultSet resultSet) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.ResultSet_getFetchDirection(this, resultSet);
        }
        return resultSet.do_getFetchDirection();
    }

    public int ResultSet_getFetchSize(DmdbResultSet resultSet) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.ResultSet_getFetchSize(this, resultSet);
        }
        return resultSet.do_getFetchSize();
    }

    public float ResultSet_getFloat(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.ResultSet_getFloat(this, resultSet, columnLabel);
        }
        return resultSet.do_getFloat(columnLabel);
    }

    public float ResultSet_getFloat(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.ResultSet_getFloat(this, resultSet, columnIndex);
        }
        return resultSet.do_getFloat(columnIndex);
    }

    public int ResultSet_getHoldability(DmdbResultSet resultSet) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.ResultSet_getHoldability(this, resultSet);
        }
        return resultSet.do_getHoldability();
    }

    public int ResultSet_getInt(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.ResultSet_getInt(this, resultSet, columnLabel);
        }
        return resultSet.do_getInt(columnLabel);
    }

    public int ResultSet_getInt(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.ResultSet_getInt(this, resultSet, columnIndex);
        }
        return resultSet.do_getInt(columnIndex);
    }

    public long ResultSet_getLong(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.ResultSet_getLong(this, resultSet, columnLabel);
        }
        return resultSet.do_getLong(columnLabel);
    }

    public long ResultSet_getLong(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.ResultSet_getLong(this, resultSet, columnIndex);
        }
        return resultSet.do_getLong(columnIndex);
    }

    public ResultSetMetaData ResultSet_getMetaData(DmdbResultSet resultSet) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.ResultSet_getMetaData(this, resultSet);
        }
        return resultSet.do_getMetaData();
    }

    public Reader ResultSet_getNCharacterStream(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.ResultSet_getNCharacterStream(this, resultSet, columnLabel);
        }
        return resultSet.do_getNCharacterStream(columnLabel);
    }

    public Reader ResultSet_getNCharacterStream(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.ResultSet_getNCharacterStream(this, resultSet, columnIndex);
        }
        return resultSet.do_getNCharacterStream(columnIndex);
    }

    public NClob ResultSet_getNClob(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.ResultSet_getNClob(this, resultSet, columnLabel);
        }
        return resultSet.do_getNClob(columnLabel);
    }

    public NClob ResultSet_getNClob(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.ResultSet_getNClob(this, resultSet, columnIndex);
        }
        return resultSet.do_getNClob(columnIndex);
    }

    public String ResultSet_getNString(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.ResultSet_getNString(this, resultSet, columnLabel);
        }
        return resultSet.do_getNString(columnLabel);
    }

    public String ResultSet_getNString(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.ResultSet_getNString(this, resultSet, columnIndex);
        }
        return resultSet.do_getNString(columnIndex);
    }

    public Object ResultSet_getObject(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.ResultSet_getObject(this, resultSet, columnLabel);
        }
        return resultSet.do_getObject(columnLabel);
    }

    public <T> T ResultSet_getObject(DmdbResultSet resultSet, String columnLabel, Class<T> type) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.ResultSet_getObject(this, resultSet, columnLabel, type);
        }
        return resultSet.do_getObject(columnLabel, type);
    }

    public Object ResultSet_getObject(DmdbResultSet resultSet, String columnLabel, Map<String, Class<?>> map) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.ResultSet_getObject(this, resultSet, columnLabel, map);
        }
        return resultSet.do_getObject(columnLabel, map);
    }

    public Object ResultSet_getObject(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.ResultSet_getObject(this, resultSet, columnIndex);
        }
        return resultSet.do_getObject(columnIndex);
    }

    public <T> T ResultSet_getObject(DmdbResultSet resultSet, int columnIndex, Class<T> type) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.ResultSet_getObject(this, resultSet, columnIndex, type);
        }
        return resultSet.do_getObject(columnIndex, type);
    }

    public Object ResultSet_getObject(DmdbResultSet resultSet, int columnIndex, Map<String, Class<?>> map) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.ResultSet_getObject(this, resultSet, columnIndex, map);
        }
        return resultSet.do_getObject(columnIndex, map);
    }

    public Ref ResultSet_getRef(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.ResultSet_getRef(this, resultSet, columnLabel);
        }
        return resultSet.do_getRef(columnLabel);
    }

    public Ref ResultSet_getRef(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.ResultSet_getRef(this, resultSet, columnIndex);
        }
        return resultSet.do_getRef(columnIndex);
    }

    public int ResultSet_getRow(DmdbResultSet resultSet) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.ResultSet_getRow(this, resultSet);
        }
        return resultSet.do_getRow();
    }

    public RowId ResultSet_getRowId(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.ResultSet_getRowId(this, resultSet, columnLabel);
        }
        return resultSet.do_getRowId(columnLabel);
    }

    public RowId ResultSet_getRowId(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.ResultSet_getRowId(this, resultSet, columnIndex);
        }
        return resultSet.do_getRowId(columnIndex);
    }

    public SQLXML ResultSet_getSQLXML(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.ResultSet_getSQLXML(this, resultSet, columnLabel);
        }
        return resultSet.do_getSQLXML(columnLabel);
    }

    public SQLXML ResultSet_getSQLXML(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.ResultSet_getSQLXML(this, resultSet, columnIndex);
        }
        return resultSet.do_getSQLXML(columnIndex);
    }

    public short ResultSet_getShort(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.ResultSet_getShort(this, resultSet, columnLabel);
        }
        return resultSet.do_getShort(columnLabel);
    }

    public short ResultSet_getShort(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.ResultSet_getShort(this, resultSet, columnIndex);
        }
        return resultSet.do_getShort(columnIndex);
    }

    public Statement ResultSet_getStatement(DmdbResultSet resultSet) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.ResultSet_getStatement(this, resultSet);
        }
        return resultSet.do_getStatement();
    }

    public String ResultSet_getString(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.ResultSet_getString(this, resultSet, columnLabel);
        }
        return resultSet.do_getString(columnLabel);
    }

    public String ResultSet_getString(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.ResultSet_getString(this, resultSet, columnIndex);
        }
        return resultSet.do_getString(columnIndex);
    }

    public Time ResultSet_getTime(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.ResultSet_getTime(this, resultSet, columnLabel);
        }
        return resultSet.do_getTime(columnLabel);
    }

    public Time ResultSet_getTime(DmdbResultSet resultSet, String columnLabel, Calendar cal) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.ResultSet_getTime(this, resultSet, columnLabel, cal);
        }
        return resultSet.do_getTime(columnLabel, cal);
    }

    public Time ResultSet_getTime(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.ResultSet_getTime(this, resultSet, columnIndex);
        }
        return resultSet.do_getTime(columnIndex);
    }

    public Time ResultSet_getTime(DmdbResultSet resultSet, int columnIndex, Calendar cal) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.ResultSet_getTime(this, resultSet, columnIndex, cal);
        }
        return resultSet.do_getTime(columnIndex, cal);
    }

    public Timestamp ResultSet_getTimestamp(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.ResultSet_getTimestamp(this, resultSet, columnLabel);
        }
        return resultSet.do_getTimestamp(columnLabel);
    }

    public Timestamp ResultSet_getTimestamp(DmdbResultSet resultSet, String columnLabel, Calendar cal) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.ResultSet_getTimestamp(this, resultSet, columnLabel, cal);
        }
        return resultSet.do_getTimestamp(columnLabel, cal);
    }

    public Timestamp ResultSet_getTimestamp(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.ResultSet_getTimestamp(this, resultSet, columnIndex);
        }
        return resultSet.do_getTimestamp(columnIndex);
    }

    public Timestamp ResultSet_getTimestamp(DmdbResultSet resultSet, int columnIndex, Calendar cal) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.ResultSet_getTimestamp(this, resultSet, columnIndex, cal);
        }
        return resultSet.do_getTimestamp(columnIndex, cal);
    }

    public int ResultSet_getType(DmdbResultSet resultSet) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.ResultSet_getType(this, resultSet);
        }
        return resultSet.do_getType();
    }

    public URL ResultSet_getURL(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.ResultSet_getURL(this, resultSet, columnLabel);
        }
        return resultSet.do_getURL(columnLabel);
    }

    public URL ResultSet_getURL(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.ResultSet_getURL(this, resultSet, columnIndex);
        }
        return resultSet.do_getURL(columnIndex);
    }

    public InputStream ResultSet_getUnicodeStream(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.ResultSet_getUnicodeStream(this, resultSet, columnLabel);
        }
        return resultSet.do_getUnicodeStream(columnLabel);
    }

    public InputStream ResultSet_getUnicodeStream(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.ResultSet_getUnicodeStream(this, resultSet, columnIndex);
        }
        return resultSet.do_getUnicodeStream(columnIndex);
    }

    public SQLWarning ResultSet_getWarnings(DmdbResultSet resultSet) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.ResultSet_getWarnings(this, resultSet);
        }
        return resultSet.do_getWarnings();
    }

    public void ResultSet_insertRow(DmdbResultSet resultSet) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.ResultSet_insertRow(this, resultSet);
            return;
        }
        resultSet.do_insertRow();
    }

    public boolean ResultSet_isAfterLast(DmdbResultSet resultSet) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.ResultSet_isAfterLast(this, resultSet);
        }
        return resultSet.do_isAfterLast();
    }

    public boolean ResultSet_isBeforeFirst(DmdbResultSet resultSet) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.ResultSet_isBeforeFirst(this, resultSet);
        }
        return resultSet.do_isBeforeFirst();
    }

    public boolean ResultSet_isClosed(DmdbResultSet resultSet) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.ResultSet_isClosed(this, resultSet);
        }
        return resultSet.do_isClosed();
    }

    public boolean ResultSet_isFirst(DmdbResultSet resultSet) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.ResultSet_isFirst(this, resultSet);
        }
        return resultSet.do_isFirst();
    }

    public boolean ResultSet_isLast(DmdbResultSet resultSet) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.ResultSet_isLast(this, resultSet);
        }
        return resultSet.do_isLast();
    }

    public boolean ResultSet_last(DmdbResultSet resultSet) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.ResultSet_last(this, resultSet);
        }
        return resultSet.do_last();
    }

    public void ResultSet_moveToCurrentRow(DmdbResultSet resultSet) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.ResultSet_moveToCurrentRow(this, resultSet);
            return;
        }
        resultSet.do_moveToCurrentRow();
    }

    public void ResultSet_moveToInsertRow(DmdbResultSet resultSet) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.ResultSet_moveToInsertRow(this, resultSet);
            return;
        }
        resultSet.do_moveToInsertRow();
    }

    public boolean ResultSet_next(DmdbResultSet resultSet) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.ResultSet_next(this, resultSet);
        }
        return resultSet.do_next();
    }

    public boolean ResultSet_previous(DmdbResultSet resultSet) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.ResultSet_previous(this, resultSet);
        }
        return resultSet.do_previous();
    }

    public void ResultSet_refreshRow(DmdbResultSet resultSet) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.ResultSet_refreshRow(this, resultSet);
            return;
        }
        resultSet.do_refreshRow();
    }

    public boolean ResultSet_relative(DmdbResultSet resultSet, int rows) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.ResultSet_relative(this, resultSet, rows);
        }
        return resultSet.do_relative(rows);
    }

    public boolean ResultSet_rowDeleted(DmdbResultSet resultSet) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.ResultSet_rowDeleted(this, resultSet);
        }
        return resultSet.do_rowDeleted();
    }

    public boolean ResultSet_rowInserted(DmdbResultSet resultSet) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.ResultSet_rowInserted(this, resultSet);
        }
        return resultSet.do_rowInserted();
    }

    public boolean ResultSet_rowUpdated(DmdbResultSet resultSet) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.ResultSet_rowUpdated(this, resultSet);
        }
        return resultSet.do_rowUpdated();
    }

    public void ResultSet_setFetchDirection(DmdbResultSet resultSet, int direction) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.ResultSet_setFetchDirection(this, resultSet, direction);
            return;
        }
        resultSet.do_setFetchDirection(direction);
    }

    public void ResultSet_setFetchSize(DmdbResultSet resultSet, int rows) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.ResultSet_setFetchSize(this, resultSet, rows);
            return;
        }
        resultSet.do_setFetchSize(rows);
    }

    public void ResultSet_updateArray(DmdbResultSet resultSet, String columnLabel, Array x) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.ResultSet_updateArray(this, resultSet, columnLabel, x);
            return;
        }
        resultSet.do_updateArray(columnLabel, x);
    }

    public void ResultSet_updateArray(DmdbResultSet resultSet, int columnIndex, Array x) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.ResultSet_updateArray(this, resultSet, columnIndex, x);
            return;
        }
        resultSet.do_updateArray(columnIndex, x);
    }

    public void ResultSet_updateAsciiStream(DmdbResultSet resultSet, String columnLabel, InputStream x) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.ResultSet_updateAsciiStream(this, resultSet, columnLabel, x);
            return;
        }
        resultSet.do_updateAsciiStream(columnLabel, x);
    }

    public void ResultSet_updateAsciiStream(DmdbResultSet resultSet, String columnLabel, InputStream x, int length) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.ResultSet_updateAsciiStream(this, resultSet, columnLabel, x, length);
            return;
        }
        resultSet.do_updateAsciiStream(columnLabel, x, length);
    }

    public void ResultSet_updateAsciiStream(DmdbResultSet resultSet, String columnLabel, InputStream x, long length) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.ResultSet_updateAsciiStream(this, resultSet, columnLabel, x, length);
            return;
        }
        resultSet.do_updateAsciiStream(columnLabel, x, length);
    }

    public void ResultSet_updateAsciiStream(DmdbResultSet resultSet, int columnIndex, InputStream x) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.ResultSet_updateAsciiStream(this, resultSet, columnIndex, x);
            return;
        }
        resultSet.do_updateAsciiStream(columnIndex, x);
    }

    public void ResultSet_updateAsciiStream(DmdbResultSet resultSet, int columnIndex, InputStream x, int length) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.ResultSet_updateAsciiStream(this, resultSet, columnIndex, x, length);
            return;
        }
        resultSet.do_updateAsciiStream(columnIndex, x, length);
    }

    public void ResultSet_updateAsciiStream(DmdbResultSet resultSet, int columnIndex, InputStream x, long length) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.ResultSet_updateAsciiStream(this, resultSet, columnIndex, x, length);
            return;
        }
        resultSet.do_updateAsciiStream(columnIndex, x, length);
    }

    public void ResultSet_updateBigDecimal(DmdbResultSet resultSet, String columnLabel, BigDecimal x) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.ResultSet_updateBigDecimal(this, resultSet, columnLabel, x);
            return;
        }
        resultSet.do_updateBigDecimal(columnLabel, x);
    }

    public void ResultSet_updateBigDecimal(DmdbResultSet resultSet, int columnIndex, BigDecimal x) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.ResultSet_updateBigDecimal(this, resultSet, columnIndex, x);
            return;
        }
        resultSet.do_updateBigDecimal(columnIndex, x);
    }

    public void ResultSet_updateBinaryStream(DmdbResultSet resultSet, String columnLabel, InputStream x) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.ResultSet_updateBinaryStream(this, resultSet, columnLabel, x);
            return;
        }
        resultSet.do_updateBinaryStream(columnLabel, x);
    }

    public void ResultSet_updateBinaryStream(DmdbResultSet resultSet, String columnLabel, InputStream x, int length) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.ResultSet_updateBinaryStream(this, resultSet, columnLabel, x, length);
            return;
        }
        resultSet.do_updateBinaryStream(columnLabel, x, length);
    }

    public void ResultSet_updateBinaryStream(DmdbResultSet resultSet, String columnLabel, InputStream x, long length) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.ResultSet_updateBinaryStream(this, resultSet, columnLabel, x, length);
            return;
        }
        resultSet.do_updateBinaryStream(columnLabel, x, length);
    }

    public void ResultSet_updateBinaryStream(DmdbResultSet resultSet, int columnIndex, InputStream x) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.ResultSet_updateBinaryStream(this, resultSet, columnIndex, x);
            return;
        }
        resultSet.do_updateBinaryStream(columnIndex, x);
    }

    public void ResultSet_updateBinaryStream(DmdbResultSet resultSet, int columnIndex, InputStream x, int length) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.ResultSet_updateBinaryStream(this, resultSet, columnIndex, x, length);
            return;
        }
        resultSet.do_updateBinaryStream(columnIndex, x, length);
    }

    public void ResultSet_updateBinaryStream(DmdbResultSet resultSet, int columnIndex, InputStream x, long length) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.ResultSet_updateBinaryStream(this, resultSet, columnIndex, x, length);
            return;
        }
        resultSet.do_updateBinaryStream(columnIndex, x, length);
    }

    public void ResultSet_updateBlob(DmdbResultSet resultSet, String columnLabel, InputStream inputStream) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.ResultSet_updateBlob(this, resultSet, columnLabel, inputStream);
            return;
        }
        resultSet.do_updateBlob(columnLabel, inputStream);
    }

    public void ResultSet_updateBlob(DmdbResultSet resultSet, String columnLabel, InputStream inputStream, long length) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.ResultSet_updateBlob(this, resultSet, columnLabel, inputStream, length);
            return;
        }
        resultSet.do_updateBlob(columnLabel, inputStream, length);
    }

    public void ResultSet_updateBlob(DmdbResultSet resultSet, String columnLabel, Blob x) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.ResultSet_updateBlob(this, resultSet, columnLabel, x);
            return;
        }
        resultSet.do_updateBlob(columnLabel, x);
    }

    public void ResultSet_updateBlob(DmdbResultSet resultSet, int columnIndex, InputStream inputStream) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.ResultSet_updateBlob(this, resultSet, columnIndex, inputStream);
            return;
        }
        resultSet.do_updateBlob(columnIndex, inputStream);
    }

    public void ResultSet_updateBlob(DmdbResultSet resultSet, int columnIndex, InputStream inputStream, long length) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.ResultSet_updateBlob(this, resultSet, columnIndex, inputStream, length);
            return;
        }
        resultSet.do_updateBlob(columnIndex, inputStream, length);
    }

    public void ResultSet_updateBlob(DmdbResultSet resultSet, int columnIndex, Blob x) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.ResultSet_updateBlob(this, resultSet, columnIndex, x);
            return;
        }
        resultSet.do_updateBlob(columnIndex, x);
    }

    public void ResultSet_updateBoolean(DmdbResultSet resultSet, String columnLabel, boolean x) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.ResultSet_updateBoolean(this, resultSet, columnLabel, x);
            return;
        }
        resultSet.do_updateBoolean(columnLabel, x);
    }

    public void ResultSet_updateBoolean(DmdbResultSet resultSet, int columnIndex, boolean x) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.ResultSet_updateBoolean(this, resultSet, columnIndex, x);
            return;
        }
        resultSet.do_updateBoolean(columnIndex, x);
    }

    public void ResultSet_updateByte(DmdbResultSet resultSet, String columnLabel, byte x) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.ResultSet_updateByte(this, resultSet, columnLabel, x);
            return;
        }
        resultSet.do_updateByte(columnLabel, x);
    }

    public void ResultSet_updateByte(DmdbResultSet resultSet, int columnIndex, byte x) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.ResultSet_updateByte(this, resultSet, columnIndex, x);
            return;
        }
        resultSet.do_updateByte(columnIndex, x);
    }

    public void ResultSet_updateBytes(DmdbResultSet resultSet, String columnLabel, byte[] x) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.ResultSet_updateBytes(this, resultSet, columnLabel, x);
            return;
        }
        resultSet.do_updateBytes(columnLabel, x);
    }

    public void ResultSet_updateBytes(DmdbResultSet resultSet, int columnIndex, byte[] x) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.ResultSet_updateBytes(this, resultSet, columnIndex, x);
            return;
        }
        resultSet.do_updateBytes(columnIndex, x);
    }

    public void ResultSet_updateCharacterStream(DmdbResultSet resultSet, String columnLabel, Reader reader) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.ResultSet_updateCharacterStream(this, resultSet, columnLabel, reader);
            return;
        }
        resultSet.do_updateCharacterStream(columnLabel, reader);
    }

    public void ResultSet_updateCharacterStream(DmdbResultSet resultSet, String columnLabel, Reader reader, int length) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.ResultSet_updateCharacterStream(this, resultSet, columnLabel, reader, length);
            return;
        }
        resultSet.do_updateCharacterStream(columnLabel, reader, length);
    }

    public void ResultSet_updateCharacterStream(DmdbResultSet resultSet, String columnLabel, Reader reader, long length) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.ResultSet_updateCharacterStream(this, resultSet, columnLabel, reader, length);
            return;
        }
        resultSet.do_updateCharacterStream(columnLabel, reader, length);
    }

    public void ResultSet_updateCharacterStream(DmdbResultSet resultSet, int columnIndex, Reader x) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.ResultSet_updateCharacterStream(this, resultSet, columnIndex, x);
            return;
        }
        resultSet.do_updateCharacterStream(columnIndex, x);
    }

    public void ResultSet_updateCharacterStream(DmdbResultSet resultSet, int columnIndex, Reader x, int length) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.ResultSet_updateCharacterStream(this, resultSet, columnIndex, x, length);
            return;
        }
        resultSet.do_updateCharacterStream(columnIndex, x, length);
    }

    public void ResultSet_updateCharacterStream(DmdbResultSet resultSet, int columnIndex, Reader x, long length) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.ResultSet_updateCharacterStream(this, resultSet, columnIndex, x, length);
            return;
        }
        resultSet.do_updateCharacterStream(columnIndex, x, length);
    }

    public void ResultSet_updateClob(DmdbResultSet resultSet, String columnLabel, Reader reader) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.ResultSet_updateClob(this, resultSet, columnLabel, reader);
            return;
        }
        resultSet.do_updateClob(columnLabel, reader);
    }

    public void ResultSet_updateClob(DmdbResultSet resultSet, String columnLabel, Reader reader, long length) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.ResultSet_updateClob(this, resultSet, columnLabel, reader, length);
            return;
        }
        resultSet.do_updateClob(columnLabel, reader, length);
    }

    public void ResultSet_updateClob(DmdbResultSet resultSet, String columnLabel, Clob x) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.ResultSet_updateClob(this, resultSet, columnLabel, x);
            return;
        }
        resultSet.do_updateClob(columnLabel, x);
    }

    public void ResultSet_updateClob(DmdbResultSet resultSet, int columnIndex, Reader reader) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.ResultSet_updateClob(this, resultSet, columnIndex, reader);
            return;
        }
        resultSet.do_updateClob(columnIndex, reader);
    }

    public void ResultSet_updateClob(DmdbResultSet resultSet, int columnIndex, Reader reader, long length) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.ResultSet_updateClob(this, resultSet, columnIndex, reader, length);
            return;
        }
        resultSet.do_updateClob(columnIndex, reader, length);
    }

    public void ResultSet_updateClob(DmdbResultSet resultSet, int columnIndex, Clob x) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.ResultSet_updateClob(this, resultSet, columnIndex, x);
            return;
        }
        resultSet.do_updateClob(columnIndex, x);
    }

    public void ResultSet_updateDate(DmdbResultSet resultSet, String columnLabel, Date x) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.ResultSet_updateDate(this, resultSet, columnLabel, x);
            return;
        }
        resultSet.do_updateDate(columnLabel, x);
    }

    public void ResultSet_updateDate(DmdbResultSet resultSet, int columnIndex, Date x) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.ResultSet_updateDate(this, resultSet, columnIndex, x);
            return;
        }
        resultSet.do_updateDate(columnIndex, x);
    }

    public void ResultSet_updateDouble(DmdbResultSet resultSet, String columnLabel, double x) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.ResultSet_updateDouble(this, resultSet, columnLabel, x);
            return;
        }
        resultSet.do_updateDouble(columnLabel, x);
    }

    public void ResultSet_updateDouble(DmdbResultSet resultSet, int columnIndex, double x) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.ResultSet_updateDouble(this, resultSet, columnIndex, x);
            return;
        }
        resultSet.do_updateDouble(columnIndex, x);
    }

    public void ResultSet_updateFloat(DmdbResultSet resultSet, String columnLabel, float x) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.ResultSet_updateFloat(this, resultSet, columnLabel, x);
            return;
        }
        resultSet.do_updateFloat(columnLabel, x);
    }

    public void ResultSet_updateFloat(DmdbResultSet resultSet, int columnIndex, float x) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.ResultSet_updateFloat(this, resultSet, columnIndex, x);
            return;
        }
        resultSet.do_updateFloat(columnIndex, x);
    }

    public void ResultSet_updateInt(DmdbResultSet resultSet, String columnLabel, int x) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.ResultSet_updateInt(this, resultSet, columnLabel, x);
            return;
        }
        resultSet.do_updateInt(columnLabel, x);
    }

    public void ResultSet_updateInt(DmdbResultSet resultSet, int columnIndex, int x) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.ResultSet_updateInt(this, resultSet, columnIndex, x);
            return;
        }
        resultSet.do_updateInt(columnIndex, x);
    }

    public void ResultSet_updateLong(DmdbResultSet resultSet, String columnLabel, long x) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.ResultSet_updateLong(this, resultSet, columnLabel, x);
            return;
        }
        resultSet.do_updateLong(columnLabel, x);
    }

    public void ResultSet_updateLong(DmdbResultSet resultSet, int columnIndex, long x) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.ResultSet_updateLong(this, resultSet, columnIndex, x);
            return;
        }
        resultSet.do_updateLong(columnIndex, x);
    }

    public void ResultSet_updateNCharacterStream(DmdbResultSet resultSet, String columnLabel, Reader reader) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.ResultSet_updateNCharacterStream(this, resultSet, columnLabel, reader);
            return;
        }
        resultSet.do_updateNCharacterStream(columnLabel, reader);
    }

    public void ResultSet_updateNCharacterStream(DmdbResultSet resultSet, String columnLabel, Reader reader, long length) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.ResultSet_updateNCharacterStream(this, resultSet, columnLabel, reader, length);
            return;
        }
        resultSet.do_updateNCharacterStream(columnLabel, reader, length);
    }

    public void ResultSet_updateNCharacterStream(DmdbResultSet resultSet, int columnIndex, Reader x) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.ResultSet_updateNCharacterStream(this, resultSet, columnIndex, x);
            return;
        }
        resultSet.do_updateNCharacterStream(columnIndex, x);
    }

    public void ResultSet_updateNCharacterStream(DmdbResultSet resultSet, int columnIndex, Reader x, long length) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.ResultSet_updateNCharacterStream(this, resultSet, columnIndex, x, length);
            return;
        }
        resultSet.do_updateNCharacterStream(columnIndex, x, length);
    }

    public void ResultSet_updateNClob(DmdbResultSet resultSet, String columnLabel, NClob nClob) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.ResultSet_updateNClob(this, resultSet, columnLabel, nClob);
            return;
        }
        resultSet.do_updateNClob(columnLabel, nClob);
    }

    public void ResultSet_updateNClob(DmdbResultSet resultSet, String columnLabel, Reader reader) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.ResultSet_updateNClob(this, resultSet, columnLabel, reader);
            return;
        }
        resultSet.do_updateNClob(columnLabel, reader);
    }

    public void ResultSet_updateNClob(DmdbResultSet resultSet, String columnLabel, Reader reader, long length) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.ResultSet_updateNClob(this, resultSet, columnLabel, reader, length);
            return;
        }
        resultSet.do_updateNClob(columnLabel, reader, length);
    }

    public void ResultSet_updateNClob(DmdbResultSet resultSet, int columnIndex, NClob nClob) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.ResultSet_updateNClob(this, resultSet, columnIndex, nClob);
            return;
        }
        resultSet.do_updateNClob(columnIndex, nClob);
    }

    public void ResultSet_updateNClob(DmdbResultSet resultSet, int columnIndex, Reader reader) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.ResultSet_updateNClob(this, resultSet, columnIndex, reader);
            return;
        }
        resultSet.do_updateNClob(columnIndex, reader);
    }

    public void ResultSet_updateNClob(DmdbResultSet resultSet, int columnIndex, Reader reader, long length) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.ResultSet_updateNClob(this, resultSet, columnIndex, reader, length);
            return;
        }
        resultSet.do_updateNClob(columnIndex, reader, length);
    }

    public void ResultSet_updateNString(DmdbResultSet resultSet, String columnLabel, String nString) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.ResultSet_updateNString(this, resultSet, columnLabel, nString);
            return;
        }
        resultSet.do_updateNString(columnLabel, nString);
    }

    public void ResultSet_updateNString(DmdbResultSet resultSet, int columnIndex, String nString) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.ResultSet_updateNString(this, resultSet, columnIndex, nString);
            return;
        }
        resultSet.do_updateNString(columnIndex, nString);
    }

    public void ResultSet_updateNull(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.ResultSet_updateNull(this, resultSet, columnLabel);
            return;
        }
        resultSet.do_updateNull(columnLabel);
    }

    public void ResultSet_updateNull(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.ResultSet_updateNull(this, resultSet, columnIndex);
            return;
        }
        resultSet.do_updateNull(columnIndex);
    }

    public void ResultSet_updateObject(DmdbResultSet resultSet, String columnLabel, Object x) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.ResultSet_updateObject(this, resultSet, columnLabel, x);
            return;
        }
        resultSet.do_updateObject(columnLabel, x);
    }

    public void ResultSet_updateObject(DmdbResultSet resultSet, String columnLabel, Object x, int scaleOrLength) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.ResultSet_updateObject(this, resultSet, columnLabel, x, scaleOrLength);
            return;
        }
        resultSet.do_updateObject(columnLabel, x, scaleOrLength);
    }

    public void ResultSet_updateObject(DmdbResultSet resultSet, int columnIndex, Object x) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.ResultSet_updateObject(this, resultSet, columnIndex, x);
            return;
        }
        resultSet.do_updateObject(columnIndex, x);
    }

    public void ResultSet_updateObject(DmdbResultSet resultSet, int columnIndex, Object x, int scaleOrLength) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.ResultSet_updateObject(this, resultSet, columnIndex, x, scaleOrLength);
            return;
        }
        resultSet.do_updateObject(columnIndex, x, scaleOrLength);
    }

    public void ResultSet_updateRef(DmdbResultSet resultSet, String columnLabel, Ref x) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.ResultSet_updateRef(this, resultSet, columnLabel, x);
            return;
        }
        resultSet.do_updateRef(columnLabel, x);
    }

    public void ResultSet_updateRef(DmdbResultSet resultSet, int columnIndex, Ref x) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.ResultSet_updateRef(this, resultSet, columnIndex, x);
            return;
        }
        resultSet.do_updateRef(columnIndex, x);
    }

    public void ResultSet_updateRow(DmdbResultSet resultSet) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.ResultSet_updateRow(this, resultSet);
            return;
        }
        resultSet.do_updateRow();
    }

    public void ResultSet_updateRowId(DmdbResultSet resultSet, String columnLabel, RowId x) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.ResultSet_updateRowId(this, resultSet, columnLabel, x);
            return;
        }
        resultSet.do_updateRowId(columnLabel, x);
    }

    public void ResultSet_updateRowId(DmdbResultSet resultSet, int columnIndex, RowId x) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.ResultSet_updateRowId(this, resultSet, columnIndex, x);
            return;
        }
        resultSet.do_updateRowId(columnIndex, x);
    }

    public void ResultSet_updateSQLXML(DmdbResultSet resultSet, String columnLabel, SQLXML xmlObject) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.ResultSet_updateSQLXML(this, resultSet, columnLabel, xmlObject);
            return;
        }
        resultSet.do_updateSQLXML(columnLabel, xmlObject);
    }

    public void ResultSet_updateSQLXML(DmdbResultSet resultSet, int columnIndex, SQLXML xmlObject) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.ResultSet_updateSQLXML(this, resultSet, columnIndex, xmlObject);
            return;
        }
        resultSet.do_updateSQLXML(columnIndex, xmlObject);
    }

    public void ResultSet_updateShort(DmdbResultSet resultSet, String columnLabel, short x) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.ResultSet_updateShort(this, resultSet, columnLabel, x);
            return;
        }
        resultSet.do_updateShort(columnLabel, x);
    }

    public void ResultSet_updateShort(DmdbResultSet resultSet, int columnIndex, short x) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.ResultSet_updateShort(this, resultSet, columnIndex, x);
            return;
        }
        resultSet.do_updateShort(columnIndex, x);
    }

    public void ResultSet_updateString(DmdbResultSet resultSet, String columnLabel, String x) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.ResultSet_updateString(this, resultSet, columnLabel, x);
            return;
        }
        resultSet.do_updateString(columnLabel, x);
    }

    public void ResultSet_updateString(DmdbResultSet resultSet, int columnIndex, String x) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.ResultSet_updateString(this, resultSet, columnIndex, x);
            return;
        }
        resultSet.do_updateString(columnIndex, x);
    }

    public void ResultSet_updateTime(DmdbResultSet resultSet, String columnLabel, Time x) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.ResultSet_updateTime(this, resultSet, columnLabel, x);
            return;
        }
        resultSet.do_updateTime(columnLabel, x);
    }

    public void ResultSet_updateTime(DmdbResultSet resultSet, int columnIndex, Time x) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.ResultSet_updateTime(this, resultSet, columnIndex, x);
            return;
        }
        resultSet.do_updateTime(columnIndex, x);
    }

    public void ResultSet_updateTimestamp(DmdbResultSet resultSet, String columnLabel, Timestamp x) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.ResultSet_updateTimestamp(this, resultSet, columnLabel, x);
            return;
        }
        resultSet.do_updateTimestamp(columnLabel, x);
    }

    public void ResultSet_updateTimestamp(DmdbResultSet resultSet, int columnIndex, Timestamp x) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            filter.ResultSet_updateTimestamp(this, resultSet, columnIndex, x);
            return;
        }
        resultSet.do_updateTimestamp(columnIndex, x);
    }

    public boolean ResultSet_wasNull(DmdbResultSet resultSet) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.ResultSet_wasNull(this, resultSet);
        }
        return resultSet.do_wasNull();
    }

    public boolean DatabaseMetaData_allProceduresAreCallable(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_allProceduresAreCallable(this, databaseMetaData);
        }
        return databaseMetaData.do_allProceduresAreCallable();
    }

    public boolean DatabaseMetaData_allTablesAreSelectable(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_allTablesAreSelectable(this, databaseMetaData);
        }
        return databaseMetaData.do_allTablesAreSelectable();
    }

    public boolean DatabaseMetaData_autoCommitFailureClosesAllResultSets(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_autoCommitFailureClosesAllResultSets(this, databaseMetaData);
        }
        return databaseMetaData.do_autoCommitFailureClosesAllResultSets();
    }

    public boolean DatabaseMetaData_dataDefinitionCausesTransactionCommit(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_dataDefinitionCausesTransactionCommit(this, databaseMetaData);
        }
        return databaseMetaData.do_dataDefinitionCausesTransactionCommit();
    }

    public boolean DatabaseMetaData_dataDefinitionIgnoredInTransactions(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_dataDefinitionIgnoredInTransactions(this, databaseMetaData);
        }
        return databaseMetaData.do_dataDefinitionIgnoredInTransactions();
    }

    public boolean DatabaseMetaData_deletesAreDetected(DmdbDatabaseMetaData databaseMetaData, int type) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_deletesAreDetected(this, databaseMetaData, type);
        }
        return databaseMetaData.do_deletesAreDetected(type);
    }

    public boolean DatabaseMetaData_doesMaxRowSizeIncludeBlobs(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_doesMaxRowSizeIncludeBlobs(this, databaseMetaData);
        }
        return databaseMetaData.do_doesMaxRowSizeIncludeBlobs();
    }

    public boolean DatabaseMetaData_generatedKeyAlwaysReturned(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_generatedKeyAlwaysReturned(this, databaseMetaData);
        }
        return databaseMetaData.do_generatedKeyAlwaysReturned();
    }

    public ResultSet DatabaseMetaData_getAttributes(DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_getAttributes(this, databaseMetaData, catalog, schemaPattern, typeNamePattern, attributeNamePattern);
        }
        return databaseMetaData.do_getAttributes(catalog, schemaPattern, typeNamePattern, attributeNamePattern);
    }

    public ResultSet DatabaseMetaData_getBestRowIdentifier(DmdbDatabaseMetaData databaseMetaData, String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_getBestRowIdentifier(this, databaseMetaData, catalog, schema, table, scope, nullable);
        }
        return databaseMetaData.do_getBestRowIdentifier(catalog, schema, table, scope, nullable);
    }

    public String DatabaseMetaData_getCatalogSeparator(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_getCatalogSeparator(this, databaseMetaData);
        }
        return databaseMetaData.do_getCatalogSeparator();
    }

    public String DatabaseMetaData_getCatalogTerm(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_getCatalogTerm(this, databaseMetaData);
        }
        return databaseMetaData.do_getCatalogTerm();
    }

    public ResultSet DatabaseMetaData_getCatalogs(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_getCatalogs(this, databaseMetaData);
        }
        return databaseMetaData.do_getCatalogs();
    }

    public ResultSet DatabaseMetaData_getClientInfoProperties(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_getClientInfoProperties(this, databaseMetaData);
        }
        return databaseMetaData.do_getClientInfoProperties();
    }

    public ResultSet DatabaseMetaData_getColumnPrivileges(DmdbDatabaseMetaData databaseMetaData, String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_getColumnPrivileges(this, databaseMetaData, catalog, schema, table, columnNamePattern);
        }
        return databaseMetaData.do_getColumnPrivileges(catalog, schema, table, columnNamePattern);
    }

    public ResultSet DatabaseMetaData_getColumns(DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_getColumns(this, databaseMetaData, catalog, schemaPattern, tableNamePattern, columnNamePattern);
        }
        return databaseMetaData.do_getColumns(catalog, schemaPattern, tableNamePattern, columnNamePattern);
    }

    public Connection DatabaseMetaData_getConnection(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_getConnection(this, databaseMetaData);
        }
        return databaseMetaData.do_getConnection();
    }

    public ResultSet DatabaseMetaData_getCrossReference(DmdbDatabaseMetaData databaseMetaData, String parentCatalog, String parentSchema, String parentTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_getCrossReference(this, databaseMetaData, parentCatalog, parentSchema, parentTable, foreignCatalog, foreignSchema, foreignTable);
        }
        return databaseMetaData.do_getCrossReference(parentCatalog, parentSchema, parentTable, foreignCatalog, foreignSchema, foreignTable);
    }

    public int DatabaseMetaData_getDatabaseMajorVersion(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_getDatabaseMajorVersion(this, databaseMetaData);
        }
        return databaseMetaData.do_getDatabaseMajorVersion();
    }

    public int DatabaseMetaData_getDatabaseMinorVersion(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_getDatabaseMinorVersion(this, databaseMetaData);
        }
        return databaseMetaData.do_getDatabaseMinorVersion();
    }

    public String DatabaseMetaData_getDatabaseProductName(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_getDatabaseProductName(this, databaseMetaData);
        }
        return databaseMetaData.do_getDatabaseProductName();
    }

    public String DatabaseMetaData_getDatabaseProductVersion(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_getDatabaseProductVersion(this, databaseMetaData);
        }
        return databaseMetaData.do_getDatabaseProductVersion();
    }

    public int DatabaseMetaData_getDefaultTransactionIsolation(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_getDefaultTransactionIsolation(this, databaseMetaData);
        }
        return databaseMetaData.do_getDefaultTransactionIsolation();
    }

    public int DatabaseMetaData_getDriverMajorVersion(DmdbDatabaseMetaData databaseMetaData) {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_getDriverMajorVersion(this, databaseMetaData);
        }
        return databaseMetaData.do_getDriverMajorVersion();
    }

    public int DatabaseMetaData_getDriverMinorVersion(DmdbDatabaseMetaData databaseMetaData) {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_getDriverMinorVersion(this, databaseMetaData);
        }
        return databaseMetaData.do_getDriverMinorVersion();
    }

    public String DatabaseMetaData_getDriverName(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_getDriverName(this, databaseMetaData);
        }
        return databaseMetaData.do_getDriverName();
    }

    public String DatabaseMetaData_getDriverVersion(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_getDriverVersion(this, databaseMetaData);
        }
        return databaseMetaData.do_getDriverVersion();
    }

    public ResultSet DatabaseMetaData_getExportedKeys(DmdbDatabaseMetaData databaseMetaData, String catalog, String schema, String table) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_getExportedKeys(this, databaseMetaData, catalog, schema, table);
        }
        return databaseMetaData.do_getExportedKeys(catalog, schema, table);
    }

    public String DatabaseMetaData_getExtraNameCharacters(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_getExtraNameCharacters(this, databaseMetaData);
        }
        return databaseMetaData.do_getExtraNameCharacters();
    }

    public ResultSet DatabaseMetaData_getFunctionColumns(DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_getFunctionColumns(this, databaseMetaData, catalog, schemaPattern, functionNamePattern, columnNamePattern);
        }
        return databaseMetaData.do_getFunctionColumns(catalog, schemaPattern, functionNamePattern, columnNamePattern);
    }

    public ResultSet DatabaseMetaData_getFunctions(DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_getFunctions(this, databaseMetaData, catalog, schemaPattern, functionNamePattern);
        }
        return databaseMetaData.do_getFunctions(catalog, schemaPattern, functionNamePattern);
    }

    public String DatabaseMetaData_getIdentifierQuoteString(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_getIdentifierQuoteString(this, databaseMetaData);
        }
        return databaseMetaData.do_getIdentifierQuoteString();
    }

    public ResultSet DatabaseMetaData_getImportedKeys(DmdbDatabaseMetaData databaseMetaData, String catalog, String schema, String table) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_getImportedKeys(this, databaseMetaData, catalog, schema, table);
        }
        return databaseMetaData.do_getImportedKeys(catalog, schema, table);
    }

    public ResultSet DatabaseMetaData_getIndexInfo(DmdbDatabaseMetaData databaseMetaData, String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_getIndexInfo(this, databaseMetaData, catalog, schema, table, unique, approximate);
        }
        return databaseMetaData.do_getIndexInfo(catalog, schema, table, unique, approximate);
    }

    public int DatabaseMetaData_getJDBCMajorVersion(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_getJDBCMajorVersion(this, databaseMetaData);
        }
        return databaseMetaData.do_getJDBCMajorVersion();
    }

    public int DatabaseMetaData_getJDBCMinorVersion(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_getJDBCMinorVersion(this, databaseMetaData);
        }
        return databaseMetaData.do_getJDBCMinorVersion();
    }

    public int DatabaseMetaData_getMaxBinaryLiteralLength(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_getMaxBinaryLiteralLength(this, databaseMetaData);
        }
        return databaseMetaData.do_getMaxBinaryLiteralLength();
    }

    public int DatabaseMetaData_getMaxCatalogNameLength(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_getMaxCatalogNameLength(this, databaseMetaData);
        }
        return databaseMetaData.do_getMaxCatalogNameLength();
    }

    public int DatabaseMetaData_getMaxCharLiteralLength(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_getMaxCharLiteralLength(this, databaseMetaData);
        }
        return databaseMetaData.do_getMaxCharLiteralLength();
    }

    public int DatabaseMetaData_getMaxColumnNameLength(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_getMaxColumnNameLength(this, databaseMetaData);
        }
        return databaseMetaData.do_getMaxColumnNameLength();
    }

    public int DatabaseMetaData_getMaxColumnsInGroupBy(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_getMaxColumnsInGroupBy(this, databaseMetaData);
        }
        return databaseMetaData.do_getMaxColumnsInGroupBy();
    }

    public int DatabaseMetaData_getMaxColumnsInIndex(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_getMaxColumnsInIndex(this, databaseMetaData);
        }
        return databaseMetaData.do_getMaxColumnsInIndex();
    }

    public int DatabaseMetaData_getMaxColumnsInOrderBy(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_getMaxColumnsInOrderBy(this, databaseMetaData);
        }
        return databaseMetaData.do_getMaxColumnsInOrderBy();
    }

    public int DatabaseMetaData_getMaxColumnsInSelect(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_getMaxColumnsInSelect(this, databaseMetaData);
        }
        return databaseMetaData.do_getMaxColumnsInSelect();
    }

    public int DatabaseMetaData_getMaxColumnsInTable(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_getMaxColumnsInTable(this, databaseMetaData);
        }
        return databaseMetaData.do_getMaxColumnsInTable();
    }

    public int DatabaseMetaData_getMaxConnections(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_getMaxConnections(this, databaseMetaData);
        }
        return databaseMetaData.do_getMaxConnections();
    }

    public int DatabaseMetaData_getMaxCursorNameLength(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_getMaxCursorNameLength(this, databaseMetaData);
        }
        return databaseMetaData.do_getMaxCursorNameLength();
    }

    public int DatabaseMetaData_getMaxIndexLength(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_getMaxIndexLength(this, databaseMetaData);
        }
        return databaseMetaData.do_getMaxIndexLength();
    }

    public int DatabaseMetaData_getMaxProcedureNameLength(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_getMaxProcedureNameLength(this, databaseMetaData);
        }
        return databaseMetaData.do_getMaxProcedureNameLength();
    }

    public int DatabaseMetaData_getMaxRowSize(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_getMaxRowSize(this, databaseMetaData);
        }
        return databaseMetaData.do_getMaxRowSize();
    }

    public int DatabaseMetaData_getMaxSchemaNameLength(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_getMaxSchemaNameLength(this, databaseMetaData);
        }
        return databaseMetaData.do_getMaxSchemaNameLength();
    }

    public int DatabaseMetaData_getMaxStatementLength(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_getMaxStatementLength(this, databaseMetaData);
        }
        return databaseMetaData.do_getMaxStatementLength();
    }

    public int DatabaseMetaData_getMaxStatements(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_getMaxStatements(this, databaseMetaData);
        }
        return databaseMetaData.do_getMaxStatements();
    }

    public int DatabaseMetaData_getMaxTableNameLength(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_getMaxTableNameLength(this, databaseMetaData);
        }
        return databaseMetaData.do_getMaxTableNameLength();
    }

    public int DatabaseMetaData_getMaxTablesInSelect(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_getMaxTablesInSelect(this, databaseMetaData);
        }
        return databaseMetaData.do_getMaxTablesInSelect();
    }

    public int DatabaseMetaData_getMaxUserNameLength(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_getMaxUserNameLength(this, databaseMetaData);
        }
        return databaseMetaData.do_getMaxUserNameLength();
    }

    public String DatabaseMetaData_getNumericFunctions(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_getNumericFunctions(this, databaseMetaData);
        }
        return databaseMetaData.do_getNumericFunctions();
    }

    public ResultSet DatabaseMetaData_getPrimaryKeys(DmdbDatabaseMetaData databaseMetaData, String catalog, String schema, String table) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_getPrimaryKeys(this, databaseMetaData, catalog, schema, table);
        }
        return databaseMetaData.do_getPrimaryKeys(catalog, schema, table);
    }

    public ResultSet DatabaseMetaData_getProcedureColumns(DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_getProcedureColumns(this, databaseMetaData, catalog, schemaPattern, procedureNamePattern, columnNamePattern);
        }
        return databaseMetaData.do_getProcedureColumns(catalog, schemaPattern, procedureNamePattern, columnNamePattern);
    }

    public String DatabaseMetaData_getProcedureTerm(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_getProcedureTerm(this, databaseMetaData);
        }
        return databaseMetaData.do_getProcedureTerm();
    }

    public ResultSet DatabaseMetaData_getProcedures(DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_getProcedures(this, databaseMetaData, catalog, schemaPattern, procedureNamePattern);
        }
        return databaseMetaData.do_getProcedures(catalog, schemaPattern, procedureNamePattern);
    }

    public ResultSet DatabaseMetaData_getPseudoColumns(DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_getPseudoColumns(this, databaseMetaData, catalog, schemaPattern, tableNamePattern, columnNamePattern);
        }
        return databaseMetaData.do_getPseudoColumns(catalog, schemaPattern, tableNamePattern, columnNamePattern);
    }

    public int DatabaseMetaData_getResultSetHoldability(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_getResultSetHoldability(this, databaseMetaData);
        }
        return databaseMetaData.do_getResultSetHoldability();
    }

    public RowIdLifetime DatabaseMetaData_getRowIdLifetime(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_getRowIdLifetime(this, databaseMetaData);
        }
        return databaseMetaData.do_getRowIdLifetime();
    }

    public String DatabaseMetaData_getSQLKeywords(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_getSQLKeywords(this, databaseMetaData);
        }
        return databaseMetaData.do_getSQLKeywords();
    }

    public int DatabaseMetaData_getSQLStateType(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_getSQLStateType(this, databaseMetaData);
        }
        return databaseMetaData.do_getSQLStateType();
    }

    public String DatabaseMetaData_getSchemaTerm(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_getSchemaTerm(this, databaseMetaData);
        }
        return databaseMetaData.do_getSchemaTerm();
    }

    public ResultSet DatabaseMetaData_getSchemas(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_getSchemas(this, databaseMetaData);
        }
        return databaseMetaData.do_getSchemas();
    }

    public ResultSet DatabaseMetaData_getSchemas(DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_getSchemas(this, databaseMetaData, catalog, schemaPattern);
        }
        return databaseMetaData.do_getSchemas(catalog, schemaPattern);
    }

    public String DatabaseMetaData_getSearchStringEscape(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_getSearchStringEscape(this, databaseMetaData);
        }
        return databaseMetaData.do_getSearchStringEscape();
    }

    public String DatabaseMetaData_getStringFunctions(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_getStringFunctions(this, databaseMetaData);
        }
        return databaseMetaData.do_getStringFunctions();
    }

    public ResultSet DatabaseMetaData_getSuperTables(DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_getSuperTables(this, databaseMetaData, catalog, schemaPattern, tableNamePattern);
        }
        return databaseMetaData.do_getSuperTables(catalog, schemaPattern, tableNamePattern);
    }

    public ResultSet DatabaseMetaData_getSuperTypes(DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_getSuperTypes(this, databaseMetaData, catalog, schemaPattern, typeNamePattern);
        }
        return databaseMetaData.do_getSuperTypes(catalog, schemaPattern, typeNamePattern);
    }

    public String DatabaseMetaData_getSystemFunctions(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_getSystemFunctions(this, databaseMetaData);
        }
        return databaseMetaData.do_getSystemFunctions();
    }

    public ResultSet DatabaseMetaData_getTablePrivileges(DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_getTablePrivileges(this, databaseMetaData, catalog, schemaPattern, tableNamePattern);
        }
        return databaseMetaData.do_getTablePrivileges(catalog, schemaPattern, tableNamePattern);
    }

    public ResultSet DatabaseMetaData_getTableTypes(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_getTableTypes(this, databaseMetaData);
        }
        return databaseMetaData.do_getTableTypes();
    }

    public ResultSet DatabaseMetaData_getTables(DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_getTables(this, databaseMetaData, catalog, schemaPattern, tableNamePattern, types);
        }
        return databaseMetaData.do_getTables(catalog, schemaPattern, tableNamePattern, types);
    }

    public String DatabaseMetaData_getTimeDateFunctions(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_getTimeDateFunctions(this, databaseMetaData);
        }
        return databaseMetaData.do_getTimeDateFunctions();
    }

    public ResultSet DatabaseMetaData_getTypeInfo(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_getTypeInfo(this, databaseMetaData);
        }
        return databaseMetaData.do_getTypeInfo();
    }

    public ResultSet DatabaseMetaData_getUDTs(DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_getUDTs(this, databaseMetaData, catalog, schemaPattern, typeNamePattern, types);
        }
        return databaseMetaData.do_getUDTs(catalog, schemaPattern, typeNamePattern, types);
    }

    public String DatabaseMetaData_getURL(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_getURL(this, databaseMetaData);
        }
        return databaseMetaData.do_getURL();
    }

    public String DatabaseMetaData_getUserName(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_getUserName(this, databaseMetaData);
        }
        return databaseMetaData.do_getUserName();
    }

    public ResultSet DatabaseMetaData_getVersionColumns(DmdbDatabaseMetaData databaseMetaData, String catalog, String schema, String table) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_getVersionColumns(this, databaseMetaData, catalog, schema, table);
        }
        return databaseMetaData.do_getVersionColumns(catalog, schema, table);
    }

    public boolean DatabaseMetaData_insertsAreDetected(DmdbDatabaseMetaData databaseMetaData, int type) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_insertsAreDetected(this, databaseMetaData, type);
        }
        return databaseMetaData.do_insertsAreDetected(type);
    }

    public boolean DatabaseMetaData_isCatalogAtStart(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_isCatalogAtStart(this, databaseMetaData);
        }
        return databaseMetaData.do_isCatalogAtStart();
    }

    public boolean DatabaseMetaData_isReadOnly(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_isReadOnly(this, databaseMetaData);
        }
        return databaseMetaData.do_isReadOnly();
    }

    public boolean DatabaseMetaData_locatorsUpdateCopy(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_locatorsUpdateCopy(this, databaseMetaData);
        }
        return databaseMetaData.do_locatorsUpdateCopy();
    }

    public boolean DatabaseMetaData_nullPlusNonNullIsNull(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_nullPlusNonNullIsNull(this, databaseMetaData);
        }
        return databaseMetaData.do_nullPlusNonNullIsNull();
    }

    public boolean DatabaseMetaData_nullsAreSortedAtEnd(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_nullsAreSortedAtEnd(this, databaseMetaData);
        }
        return databaseMetaData.do_nullsAreSortedAtEnd();
    }

    public boolean DatabaseMetaData_nullsAreSortedAtStart(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_nullsAreSortedAtStart(this, databaseMetaData);
        }
        return databaseMetaData.do_nullsAreSortedAtStart();
    }

    public boolean DatabaseMetaData_nullsAreSortedHigh(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_nullsAreSortedHigh(this, databaseMetaData);
        }
        return databaseMetaData.do_nullsAreSortedHigh();
    }

    public boolean DatabaseMetaData_nullsAreSortedLow(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_nullsAreSortedLow(this, databaseMetaData);
        }
        return databaseMetaData.do_nullsAreSortedLow();
    }

    public boolean DatabaseMetaData_othersDeletesAreVisible(DmdbDatabaseMetaData databaseMetaData, int type) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_othersDeletesAreVisible(this, databaseMetaData, type);
        }
        return databaseMetaData.do_othersDeletesAreVisible(type);
    }

    public boolean DatabaseMetaData_othersInsertsAreVisible(DmdbDatabaseMetaData databaseMetaData, int type) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_othersInsertsAreVisible(this, databaseMetaData, type);
        }
        return databaseMetaData.do_othersInsertsAreVisible(type);
    }

    public boolean DatabaseMetaData_othersUpdatesAreVisible(DmdbDatabaseMetaData databaseMetaData, int type) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_othersUpdatesAreVisible(this, databaseMetaData, type);
        }
        return databaseMetaData.do_othersUpdatesAreVisible(type);
    }

    public boolean DatabaseMetaData_ownDeletesAreVisible(DmdbDatabaseMetaData databaseMetaData, int type) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_ownDeletesAreVisible(this, databaseMetaData, type);
        }
        return databaseMetaData.do_ownDeletesAreVisible(type);
    }

    public boolean DatabaseMetaData_ownInsertsAreVisible(DmdbDatabaseMetaData databaseMetaData, int type) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_ownInsertsAreVisible(this, databaseMetaData, type);
        }
        return databaseMetaData.do_ownInsertsAreVisible(type);
    }

    public boolean DatabaseMetaData_ownUpdatesAreVisible(DmdbDatabaseMetaData databaseMetaData, int type) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_ownUpdatesAreVisible(this, databaseMetaData, type);
        }
        return databaseMetaData.do_ownUpdatesAreVisible(type);
    }

    public boolean DatabaseMetaData_storesLowerCaseIdentifiers(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_storesLowerCaseIdentifiers(this, databaseMetaData);
        }
        return databaseMetaData.do_storesLowerCaseIdentifiers();
    }

    public boolean DatabaseMetaData_storesLowerCaseQuotedIdentifiers(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_storesLowerCaseQuotedIdentifiers(this, databaseMetaData);
        }
        return databaseMetaData.do_storesLowerCaseQuotedIdentifiers();
    }

    public boolean DatabaseMetaData_storesMixedCaseIdentifiers(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_storesMixedCaseIdentifiers(this, databaseMetaData);
        }
        return databaseMetaData.do_storesMixedCaseIdentifiers();
    }

    public boolean DatabaseMetaData_storesMixedCaseQuotedIdentifiers(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_storesMixedCaseQuotedIdentifiers(this, databaseMetaData);
        }
        return databaseMetaData.do_storesMixedCaseQuotedIdentifiers();
    }

    public boolean DatabaseMetaData_storesUpperCaseIdentifiers(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_storesUpperCaseIdentifiers(this, databaseMetaData);
        }
        return databaseMetaData.do_storesUpperCaseIdentifiers();
    }

    public boolean DatabaseMetaData_storesUpperCaseQuotedIdentifiers(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_storesUpperCaseQuotedIdentifiers(this, databaseMetaData);
        }
        return databaseMetaData.do_storesUpperCaseQuotedIdentifiers();
    }

    public boolean DatabaseMetaData_supportsANSI92EntryLevelSQL(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_supportsANSI92EntryLevelSQL(this, databaseMetaData);
        }
        return databaseMetaData.do_supportsANSI92EntryLevelSQL();
    }

    public boolean DatabaseMetaData_supportsANSI92FullSQL(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_supportsANSI92FullSQL(this, databaseMetaData);
        }
        return databaseMetaData.do_supportsANSI92FullSQL();
    }

    public boolean DatabaseMetaData_supportsANSI92IntermediateSQL(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_supportsANSI92IntermediateSQL(this, databaseMetaData);
        }
        return databaseMetaData.do_supportsANSI92IntermediateSQL();
    }

    public boolean DatabaseMetaData_supportsAlterTableWithAddColumn(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_supportsAlterTableWithAddColumn(this, databaseMetaData);
        }
        return databaseMetaData.do_supportsAlterTableWithAddColumn();
    }

    public boolean DatabaseMetaData_supportsAlterTableWithDropColumn(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_supportsAlterTableWithDropColumn(this, databaseMetaData);
        }
        return databaseMetaData.do_supportsAlterTableWithDropColumn();
    }

    public boolean DatabaseMetaData_supportsBatchUpdates(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_supportsBatchUpdates(this, databaseMetaData);
        }
        return databaseMetaData.do_supportsBatchUpdates();
    }

    public boolean DatabaseMetaData_supportsCatalogsInDataManipulation(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_supportsCatalogsInDataManipulation(this, databaseMetaData);
        }
        return databaseMetaData.do_supportsCatalogsInDataManipulation();
    }

    public boolean DatabaseMetaData_supportsCatalogsInIndexDefinitions(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_supportsCatalogsInIndexDefinitions(this, databaseMetaData);
        }
        return databaseMetaData.do_supportsCatalogsInIndexDefinitions();
    }

    public boolean DatabaseMetaData_supportsCatalogsInPrivilegeDefinitions(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_supportsCatalogsInPrivilegeDefinitions(this, databaseMetaData);
        }
        return databaseMetaData.do_supportsCatalogsInPrivilegeDefinitions();
    }

    public boolean DatabaseMetaData_supportsCatalogsInProcedureCalls(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_supportsCatalogsInProcedureCalls(this, databaseMetaData);
        }
        return databaseMetaData.do_supportsCatalogsInProcedureCalls();
    }

    public boolean DatabaseMetaData_supportsCatalogsInTableDefinitions(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_supportsCatalogsInTableDefinitions(this, databaseMetaData);
        }
        return databaseMetaData.do_supportsCatalogsInTableDefinitions();
    }

    public boolean DatabaseMetaData_supportsColumnAliasing(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_supportsColumnAliasing(this, databaseMetaData);
        }
        return databaseMetaData.do_supportsColumnAliasing();
    }

    public boolean DatabaseMetaData_supportsConvert(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_supportsConvert(this, databaseMetaData);
        }
        return databaseMetaData.do_supportsConvert();
    }

    public boolean DatabaseMetaData_supportsConvert(DmdbDatabaseMetaData databaseMetaData, int fromType, int toType) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_supportsConvert(this, databaseMetaData, fromType, toType);
        }
        return databaseMetaData.do_supportsConvert(fromType, toType);
    }

    public boolean DatabaseMetaData_supportsCoreSQLGrammar(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_supportsCoreSQLGrammar(this, databaseMetaData);
        }
        return databaseMetaData.do_supportsCoreSQLGrammar();
    }

    public boolean DatabaseMetaData_supportsCorrelatedSubqueries(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_supportsCorrelatedSubqueries(this, databaseMetaData);
        }
        return databaseMetaData.do_supportsCorrelatedSubqueries();
    }

    public boolean DatabaseMetaData_supportsDataDefinitionAndDataManipulationTransactions(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_supportsDataDefinitionAndDataManipulationTransactions(this, databaseMetaData);
        }
        return databaseMetaData.do_supportsDataDefinitionAndDataManipulationTransactions();
    }

    public boolean DatabaseMetaData_supportsDataManipulationTransactionsOnly(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_supportsDataManipulationTransactionsOnly(this, databaseMetaData);
        }
        return databaseMetaData.do_supportsDataManipulationTransactionsOnly();
    }

    public boolean DatabaseMetaData_supportsDifferentTableCorrelationNames(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_supportsDifferentTableCorrelationNames(this, databaseMetaData);
        }
        return databaseMetaData.do_supportsDifferentTableCorrelationNames();
    }

    public boolean DatabaseMetaData_supportsExpressionsInOrderBy(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_supportsExpressionsInOrderBy(this, databaseMetaData);
        }
        return databaseMetaData.do_supportsExpressionsInOrderBy();
    }

    public boolean DatabaseMetaData_supportsExtendedSQLGrammar(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_supportsExtendedSQLGrammar(this, databaseMetaData);
        }
        return databaseMetaData.do_supportsExtendedSQLGrammar();
    }

    public boolean DatabaseMetaData_supportsFullOuterJoins(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_supportsFullOuterJoins(this, databaseMetaData);
        }
        return databaseMetaData.do_supportsFullOuterJoins();
    }

    public boolean DatabaseMetaData_supportsGetGeneratedKeys(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_supportsGetGeneratedKeys(this, databaseMetaData);
        }
        return databaseMetaData.do_supportsGetGeneratedKeys();
    }

    public boolean DatabaseMetaData_supportsGroupBy(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_supportsGroupBy(this, databaseMetaData);
        }
        return databaseMetaData.do_supportsGroupBy();
    }

    public boolean DatabaseMetaData_supportsGroupByBeyondSelect(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_supportsGroupByBeyondSelect(this, databaseMetaData);
        }
        return databaseMetaData.do_supportsGroupByBeyondSelect();
    }

    public boolean DatabaseMetaData_supportsGroupByUnrelated(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_supportsGroupByUnrelated(this, databaseMetaData);
        }
        return databaseMetaData.do_supportsGroupByUnrelated();
    }

    public boolean DatabaseMetaData_supportsIntegrityEnhancementFacility(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_supportsIntegrityEnhancementFacility(this, databaseMetaData);
        }
        return databaseMetaData.do_supportsIntegrityEnhancementFacility();
    }

    public boolean DatabaseMetaData_supportsLikeEscapeClause(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_supportsLikeEscapeClause(this, databaseMetaData);
        }
        return databaseMetaData.do_supportsLikeEscapeClause();
    }

    public boolean DatabaseMetaData_supportsLimitedOuterJoins(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_supportsLimitedOuterJoins(this, databaseMetaData);
        }
        return databaseMetaData.do_supportsLimitedOuterJoins();
    }

    public boolean DatabaseMetaData_supportsMinimumSQLGrammar(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_supportsMinimumSQLGrammar(this, databaseMetaData);
        }
        return databaseMetaData.do_supportsMinimumSQLGrammar();
    }

    public boolean DatabaseMetaData_supportsMixedCaseIdentifiers(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_supportsMixedCaseIdentifiers(this, databaseMetaData);
        }
        return databaseMetaData.do_supportsMixedCaseIdentifiers();
    }

    public boolean DatabaseMetaData_supportsMixedCaseQuotedIdentifiers(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_supportsMixedCaseQuotedIdentifiers(this, databaseMetaData);
        }
        return databaseMetaData.do_supportsMixedCaseQuotedIdentifiers();
    }

    public boolean DatabaseMetaData_supportsMultipleOpenResults(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_supportsMultipleOpenResults(this, databaseMetaData);
        }
        return databaseMetaData.do_supportsMultipleOpenResults();
    }

    public boolean DatabaseMetaData_supportsMultipleResultSets(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_supportsMultipleResultSets(this, databaseMetaData);
        }
        return databaseMetaData.do_supportsMultipleResultSets();
    }

    public boolean DatabaseMetaData_supportsMultipleTransactions(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_supportsMultipleTransactions(this, databaseMetaData);
        }
        return databaseMetaData.do_supportsMultipleTransactions();
    }

    public boolean DatabaseMetaData_supportsNamedParameters(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_supportsNamedParameters(this, databaseMetaData);
        }
        return databaseMetaData.do_supportsNamedParameters();
    }

    public boolean DatabaseMetaData_supportsNonNullableColumns(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_supportsNonNullableColumns(this, databaseMetaData);
        }
        return databaseMetaData.do_supportsNonNullableColumns();
    }

    public boolean DatabaseMetaData_supportsOpenCursorsAcrossCommit(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_supportsOpenCursorsAcrossCommit(this, databaseMetaData);
        }
        return databaseMetaData.do_supportsOpenCursorsAcrossCommit();
    }

    public boolean DatabaseMetaData_supportsOpenCursorsAcrossRollback(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_supportsOpenCursorsAcrossRollback(this, databaseMetaData);
        }
        return databaseMetaData.do_supportsOpenCursorsAcrossRollback();
    }

    public boolean DatabaseMetaData_supportsOpenStatementsAcrossCommit(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_supportsOpenStatementsAcrossCommit(this, databaseMetaData);
        }
        return databaseMetaData.do_supportsOpenStatementsAcrossCommit();
    }

    public boolean DatabaseMetaData_supportsOpenStatementsAcrossRollback(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_supportsOpenStatementsAcrossRollback(this, databaseMetaData);
        }
        return databaseMetaData.do_supportsOpenStatementsAcrossRollback();
    }

    public boolean DatabaseMetaData_supportsOrderByUnrelated(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_supportsOrderByUnrelated(this, databaseMetaData);
        }
        return databaseMetaData.do_supportsOrderByUnrelated();
    }

    public boolean DatabaseMetaData_supportsOuterJoins(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_supportsOuterJoins(this, databaseMetaData);
        }
        return databaseMetaData.do_supportsOuterJoins();
    }

    public boolean DatabaseMetaData_supportsPositionedDelete(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_supportsPositionedDelete(this, databaseMetaData);
        }
        return databaseMetaData.do_supportsPositionedDelete();
    }

    public boolean DatabaseMetaData_supportsPositionedUpdate(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_supportsPositionedUpdate(this, databaseMetaData);
        }
        return databaseMetaData.do_supportsPositionedUpdate();
    }

    public boolean DatabaseMetaData_supportsResultSetConcurrency(DmdbDatabaseMetaData databaseMetaData, int type, int concurrency) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_supportsResultSetConcurrency(this, databaseMetaData, type, concurrency);
        }
        return databaseMetaData.do_supportsResultSetConcurrency(type, concurrency);
    }

    public boolean DatabaseMetaData_supportsResultSetHoldability(DmdbDatabaseMetaData databaseMetaData, int holdability) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_supportsResultSetHoldability(this, databaseMetaData, holdability);
        }
        return databaseMetaData.do_supportsResultSetHoldability(holdability);
    }

    public boolean DatabaseMetaData_supportsResultSetType(DmdbDatabaseMetaData databaseMetaData, int type) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_supportsResultSetType(this, databaseMetaData, type);
        }
        return databaseMetaData.do_supportsResultSetType(type);
    }

    public boolean DatabaseMetaData_supportsSavepoints(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_supportsSavepoints(this, databaseMetaData);
        }
        return databaseMetaData.do_supportsSavepoints();
    }

    public boolean DatabaseMetaData_supportsSchemasInDataManipulation(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_supportsSchemasInDataManipulation(this, databaseMetaData);
        }
        return databaseMetaData.do_supportsSchemasInDataManipulation();
    }

    public boolean DatabaseMetaData_supportsSchemasInIndexDefinitions(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_supportsSchemasInIndexDefinitions(this, databaseMetaData);
        }
        return databaseMetaData.do_supportsSchemasInIndexDefinitions();
    }

    public boolean DatabaseMetaData_supportsSchemasInPrivilegeDefinitions(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_supportsSchemasInPrivilegeDefinitions(this, databaseMetaData);
        }
        return databaseMetaData.do_supportsSchemasInPrivilegeDefinitions();
    }

    public boolean DatabaseMetaData_supportsSchemasInProcedureCalls(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_supportsSchemasInProcedureCalls(this, databaseMetaData);
        }
        return databaseMetaData.do_supportsSchemasInProcedureCalls();
    }

    public boolean DatabaseMetaData_supportsSchemasInTableDefinitions(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_supportsSchemasInTableDefinitions(this, databaseMetaData);
        }
        return databaseMetaData.do_supportsSchemasInTableDefinitions();
    }

    public boolean DatabaseMetaData_supportsSelectForUpdate(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_supportsSelectForUpdate(this, databaseMetaData);
        }
        return databaseMetaData.do_supportsSelectForUpdate();
    }

    public boolean DatabaseMetaData_supportsStatementPooling(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_supportsStatementPooling(this, databaseMetaData);
        }
        return databaseMetaData.do_supportsStatementPooling();
    }

    public boolean DatabaseMetaData_supportsStoredFunctionsUsingCallSyntax(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_supportsStoredFunctionsUsingCallSyntax(this, databaseMetaData);
        }
        return databaseMetaData.do_supportsStoredFunctionsUsingCallSyntax();
    }

    public boolean DatabaseMetaData_supportsStoredProcedures(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_supportsStoredProcedures(this, databaseMetaData);
        }
        return databaseMetaData.do_supportsStoredProcedures();
    }

    public boolean DatabaseMetaData_supportsSubqueriesInComparisons(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_supportsSubqueriesInComparisons(this, databaseMetaData);
        }
        return databaseMetaData.do_supportsSubqueriesInComparisons();
    }

    public boolean DatabaseMetaData_supportsSubqueriesInExists(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_supportsSubqueriesInExists(this, databaseMetaData);
        }
        return databaseMetaData.do_supportsSubqueriesInExists();
    }

    public boolean DatabaseMetaData_supportsSubqueriesInIns(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_supportsSubqueriesInIns(this, databaseMetaData);
        }
        return databaseMetaData.do_supportsSubqueriesInIns();
    }

    public boolean DatabaseMetaData_supportsSubqueriesInQuantifieds(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_supportsSubqueriesInQuantifieds(this, databaseMetaData);
        }
        return databaseMetaData.do_supportsSubqueriesInQuantifieds();
    }

    public boolean DatabaseMetaData_supportsTableCorrelationNames(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_supportsTableCorrelationNames(this, databaseMetaData);
        }
        return databaseMetaData.do_supportsTableCorrelationNames();
    }

    public boolean DatabaseMetaData_supportsTransactionIsolationLevel(DmdbDatabaseMetaData databaseMetaData, int level) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_supportsTransactionIsolationLevel(this, databaseMetaData, level);
        }
        return databaseMetaData.do_supportsTransactionIsolationLevel(level);
    }

    public boolean DatabaseMetaData_supportsTransactions(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_supportsTransactions(this, databaseMetaData);
        }
        return databaseMetaData.do_supportsTransactions();
    }

    public boolean DatabaseMetaData_supportsUnion(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_supportsUnion(this, databaseMetaData);
        }
        return databaseMetaData.do_supportsUnion();
    }

    public boolean DatabaseMetaData_supportsUnionAll(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_supportsUnionAll(this, databaseMetaData);
        }
        return databaseMetaData.do_supportsUnionAll();
    }

    public boolean DatabaseMetaData_updatesAreDetected(DmdbDatabaseMetaData databaseMetaData, int type) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_updatesAreDetected(this, databaseMetaData, type);
        }
        return databaseMetaData.do_updatesAreDetected(type);
    }

    public boolean DatabaseMetaData_usesLocalFilePerTable(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_usesLocalFilePerTable(this, databaseMetaData);
        }
        return databaseMetaData.do_usesLocalFilePerTable();
    }

    public boolean DatabaseMetaData_usesLocalFiles(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.DatabaseMetaData_usesLocalFiles(this, databaseMetaData);
        }
        return databaseMetaData.do_usesLocalFiles();
    }

    public String ParameterMetaData_getParameterClassName(DmdbParameterMetaData parameterMetaData, int param) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.ParameterMetaData_getParameterClassName(this, parameterMetaData, param);
        }
        return parameterMetaData.do_getParameterClassName(param);
    }

    public int ParameterMetaData_getParameterCount(DmdbParameterMetaData parameterMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.ParameterMetaData_getParameterCount(this, parameterMetaData);
        }
        return parameterMetaData.do_getParameterCount();
    }

    public int ParameterMetaData_getParameterMode(DmdbParameterMetaData parameterMetaData, int param) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.ParameterMetaData_getParameterMode(this, parameterMetaData, param);
        }
        return parameterMetaData.do_getParameterMode(param);
    }

    public int ParameterMetaData_getParameterType(DmdbParameterMetaData parameterMetaData, int param) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.ParameterMetaData_getParameterType(this, parameterMetaData, param);
        }
        return parameterMetaData.do_getParameterType(param);
    }

    public String ParameterMetaData_getParameterTypeName(DmdbParameterMetaData parameterMetaData, int param) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.ParameterMetaData_getParameterTypeName(this, parameterMetaData, param);
        }
        return parameterMetaData.do_getParameterTypeName(param);
    }

    public int ParameterMetaData_getPrecision(DmdbParameterMetaData parameterMetaData, int param) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.ParameterMetaData_getPrecision(this, parameterMetaData, param);
        }
        return parameterMetaData.do_getPrecision(param);
    }

    public int ParameterMetaData_getScale(DmdbParameterMetaData parameterMetaData, int param) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.ParameterMetaData_getScale(this, parameterMetaData, param);
        }
        return parameterMetaData.do_getScale(param);
    }

    public int ParameterMetaData_isNullable(DmdbParameterMetaData parameterMetaData, int param) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.ParameterMetaData_isNullable(this, parameterMetaData, param);
        }
        return parameterMetaData.do_isNullable(param);
    }

    public boolean ParameterMetaData_isSigned(DmdbParameterMetaData parameterMetaData, int param) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.ParameterMetaData_isSigned(this, parameterMetaData, param);
        }
        return parameterMetaData.do_isSigned(param);
    }

    public String ResultSetMetaData_getCatalogName(DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.ResultSetMetaData_getCatalogName(this, resultSetMetaData, column);
        }
        return resultSetMetaData.do_getCatalogName(column);
    }

    public String ResultSetMetaData_getColumnClassName(DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.ResultSetMetaData_getColumnClassName(this, resultSetMetaData, column);
        }
        return resultSetMetaData.do_getColumnClassName(column);
    }

    public int ResultSetMetaData_getColumnCount(DmdbResultSetMetaData resultSetMetaData) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.ResultSetMetaData_getColumnCount(this, resultSetMetaData);
        }
        return resultSetMetaData.do_getColumnCount();
    }

    public int ResultSetMetaData_getColumnDisplaySize(DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.ResultSetMetaData_getColumnDisplaySize(this, resultSetMetaData, column);
        }
        return resultSetMetaData.do_getColumnDisplaySize(column);
    }

    public String ResultSetMetaData_getColumnLabel(DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.ResultSetMetaData_getColumnLabel(this, resultSetMetaData, column);
        }
        return resultSetMetaData.do_getColumnLabel(column);
    }

    public String ResultSetMetaData_getColumnName(DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.ResultSetMetaData_getColumnName(this, resultSetMetaData, column);
        }
        return resultSetMetaData.do_getColumnName(column);
    }

    public int ResultSetMetaData_getColumnType(DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.ResultSetMetaData_getColumnType(this, resultSetMetaData, column);
        }
        return resultSetMetaData.do_getColumnType(column);
    }

    public String ResultSetMetaData_getColumnTypeName(DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.ResultSetMetaData_getColumnTypeName(this, resultSetMetaData, column);
        }
        return resultSetMetaData.do_getColumnTypeName(column);
    }

    public int ResultSetMetaData_getPrecision(DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.ResultSetMetaData_getPrecision(this, resultSetMetaData, column);
        }
        return resultSetMetaData.do_getPrecision(column);
    }

    public int ResultSetMetaData_getScale(DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.ResultSetMetaData_getScale(this, resultSetMetaData, column);
        }
        return resultSetMetaData.do_getScale(column);
    }

    public String ResultSetMetaData_getSchemaName(DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.ResultSetMetaData_getSchemaName(this, resultSetMetaData, column);
        }
        return resultSetMetaData.do_getSchemaName(column);
    }

    public String ResultSetMetaData_getTableName(DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.ResultSetMetaData_getTableName(this, resultSetMetaData, column);
        }
        return resultSetMetaData.do_getTableName(column);
    }

    public boolean ResultSetMetaData_isAutoIncrement(DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.ResultSetMetaData_isAutoIncrement(this, resultSetMetaData, column);
        }
        return resultSetMetaData.do_isAutoIncrement(column);
    }

    public boolean ResultSetMetaData_isCaseSensitive(DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.ResultSetMetaData_isCaseSensitive(this, resultSetMetaData, column);
        }
        return resultSetMetaData.do_isCaseSensitive(column);
    }

    public boolean ResultSetMetaData_isCurrency(DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.ResultSetMetaData_isCurrency(this, resultSetMetaData, column);
        }
        return resultSetMetaData.do_isCurrency(column);
    }

    public boolean ResultSetMetaData_isDefinitelyWritable(DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.ResultSetMetaData_isDefinitelyWritable(this, resultSetMetaData, column);
        }
        return resultSetMetaData.do_isDefinitelyWritable(column);
    }

    public int ResultSetMetaData_isNullable(DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.ResultSetMetaData_isNullable(this, resultSetMetaData, column);
        }
        return resultSetMetaData.do_isNullable(column);
    }

    public boolean ResultSetMetaData_isReadOnly(DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.ResultSetMetaData_isReadOnly(this, resultSetMetaData, column);
        }
        return resultSetMetaData.do_isReadOnly(column);
    }

    public boolean ResultSetMetaData_isSearchable(DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.ResultSetMetaData_isSearchable(this, resultSetMetaData, column);
        }
        return resultSetMetaData.do_isSearchable(column);
    }

    public boolean ResultSetMetaData_isSigned(DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.ResultSetMetaData_isSigned(this, resultSetMetaData, column);
        }
        return resultSetMetaData.do_isSigned(column);
    }

    public boolean ResultSetMetaData_isWritable(DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.ResultSetMetaData_isWritable(this, resultSetMetaData, column);
        }
        return resultSetMetaData.do_isWritable(column);
    }

    public Connection Connection_connect(DmDriver dmDriver, String url, Properties info) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.Connection_connect(this, dmDriver, url, info);
        }
        return dmDriver.do_connect(url, info);
    }

    public long Statement_getLargeMaxRows(DmdbStatement statement) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.Statement_getLargeMaxRows(this, statement);
        }
        return statement.do_getLargeMaxRows();
    }

    public long[] Statement_executeLargeBatch(DmdbStatement statement) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.Statement_executeLargeBatch(this, statement);
        }
        return statement.do_executeLargeBatch();
    }

    public long Statement_executeLargeUpdate(DmdbStatement statement, String sql) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.Statement_executeLargeUpdate(this, statement, sql);
        }
        return statement.do_executeLargeUpdate(sql);
    }

    public long Statement_executeLargeUpdate(DmdbStatement statement, String sql, int autoGeneratedKeys) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.Statement_executeLargeUpdate(this, statement, sql, autoGeneratedKeys);
        }
        return statement.do_executeLargeUpdate(sql, autoGeneratedKeys);
    }

    public long Statement_executeLargeUpdate(DmdbStatement statement, String sql, int[] columnIndexes) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.Statement_executeLargeUpdate(this, statement, sql, columnIndexes);
        }
        return statement.do_executeLargeUpdate(sql, columnIndexes);
    }

    public long Statement_executeLargeUpdate(DmdbStatement statement, String sql, String[] columnNames) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.Statement_executeLargeUpdate(this, statement, sql, columnNames);
        }
        return statement.do_executeLargeUpdate(sql, columnNames);
    }

    public long PreparedStatement_executeLargeUpdate(DmdbPreparedStatement preparedStatement) throws SQLException {
        BaseFilter filter = this.nextFilter();
        if (filter != null) {
            return filter.PreparedStatement_executeLargeUpdate(this, preparedStatement);
        }
        return preparedStatement.do_executeLargeUpdate();
    }
}

