/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.dbaccess.DBError;
import dm.jdbc.driver.DmdbBlob;
import dm.jdbc.driver.DmdbClob;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;

public class DmdbOutputStream
extends OutputStream {
    private DmdbBlob blob;
    private DmdbClob clob;
    private int typeFlag;
    private long position = 0L;

    public DmdbOutputStream(Object o, long p) throws SQLException {
        if (o instanceof DmdbBlob) {
            this.blob = (DmdbBlob)o;
            this.typeFlag = 0;
        } else if (o instanceof DmdbClob) {
            this.clob = (DmdbClob)o;
            this.typeFlag = 1;
        } else {
            throw new SQLException("Only permit DmdbBlob and DmdbClob object");
        }
        this.position = p;
    }

    public void write(int a) throws IOException {
        byte[] tempByte = new byte[]{(byte)a};
        this.write(tempByte, 0, 1);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        block9: {
            if (off < 0) {
                throw new IndexOutOfBoundsException(new Integer(off).toString());
            }
            if (len < 0) {
                throw new IndexOutOfBoundsException(new Integer(len).toString());
            }
            if (off + len > b.length) {
                throw new IndexOutOfBoundsException(new Integer(off + len).toString());
            }
            try {
                if (this.typeFlag == 0) {
                    this.blob.setBytes(this.position, b, off, len);
                    this.position += (long)len;
                    break block9;
                }
                if (this.typeFlag == 1) {
                    byte[] tempByte;
                    if (len == b.length && off == 0) {
                        tempByte = b;
                    } else {
                        tempByte = new byte[len];
                        System.arraycopy(b, off, tempByte, 0, len);
                    }
                    String tempStr = new String(tempByte);
                    this.clob.setString(this.position, tempStr, 0, tempStr.length());
                    this.position += (long)tempStr.length();
                    break block9;
                }
                throw new SQLException("Fatal error occured in DmdbOutputStream ");
            }
            catch (SQLException e) {
                DBError.SQLToIOException(e);
            }
        }
    }
}

