/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.dbaccess;

import dm.jdbc.dbaccess.DBError;
import dm.jdbc.dbaccess.DbAccess;
import dm.jdbc.dbaccess.DmdbCSI;
import dm.jdbc.desc.DmServerInfo;
import dm.jdbc.desc.DmSvcConf;
import dm.jdbc.desc.ServerGroup;
import dm.jdbc.driver.DmdbConnection_bs;
import dm.jdbc.log.ILogger;
import dm.jdbc.log.LogFactory;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DmdbSwitch {
    static ILogger LOG = LogFactory.getLog(DmdbSwitch.class);
    private static int curServerPos = -1;
    private static ReentrantLock lock = new ReentrantLock();

    public static void connect(DmdbConnection_bs conn) throws IOException, SQLException {
        if (conn.hasOneSvr()) {
            if (!DmdbSwitch.tryConnectOneServer(conn, conn.getHosts().get(0), 0)) {
                throw new IOException();
            }
        } else if (conn.isLoadBalance()) {
            DmdbSwitch.connectLoadBalance(conn);
        } else {
            DmdbSwitch.connectWellDistribute(conn);
        }
        if (conn.getRwSeparate()) {
            conn.getDbAccess().setStandbyAlive(DmdbCSI.connToStandby(conn));
        }
    }

    private static void connectLoadBalance(DmdbConnection_bs conn) throws IOException {
        ServerGroup serverGroup = conn.getServerGroup();
        ServerGroup.LBResult result = serverGroup.checkLoadBalance(conn, false);
        if (!DmdbSwitch.tryConnectServerListLoadBalance(conn, result, 0L)) {
            throw new IOException();
        }
    }

    private static void connectWellDistribute(DmdbConnection_bs conn) throws IOException {
        int serverCount = conn.getHosts().size();
        int startPos = 0;
        try {
            lock.lock();
            startPos = curServerPos = (curServerPos + 1) % serverCount;
        }
        finally {
            lock.unlock();
        }
        conn.setServPos(startPos);
        List<Integer> serverArr = DmdbSwitch.serverOrderByLastConnSucc(conn.getHosts(), conn.getServPos());
        if (!DmdbSwitch.tryConnectServerList(conn, serverArr, 0L)) {
            throw new IOException();
        }
    }

    public static void doSwitchForConnError(DmdbConnection_bs conn) throws SQLException {
        long times = conn.getSwitchTimes();
        List<Integer> serverArr = null;
        if (conn.getDbAccess() != null && conn.getDbAccess().getAccessStandby() != null) {
            conn.getDbAccess().getAccessStandby().close();
        }
        if (conn.isLoadBalance()) {
            serverArr = DmdbSwitch.serverOrderBySessCount(conn.getHosts(), conn.getServerGroup().getSessCounts(), conn.getLoginMode());
            serverArr.remove(new Integer(conn.getServPos()));
            serverArr.add(conn.getServPos());
        } else {
            serverArr = DmdbSwitch.serverOrderByLastConnSucc(conn.getHosts(), conn.getServPos());
        }
        int i = 0;
        while ((long)i < times) {
            if (DmdbSwitch.tryConnectServerList(conn, serverArr, conn.getSwitchInterval())) {
                if (conn.getRwSeparate()) {
                    conn.getDbAccess().setStandbyAlive(DmdbCSI.connToStandby(conn));
                }
                conn.resetStatments();
                conn.setClosed(false);
                DBError.throwSQLException(20000);
                return;
            }
            ++i;
        }
        conn.setClosed(true);
        DBError.throwSQLException(20001);
    }

    private static boolean tryConnectServerList(DmdbConnection_bs conn, List<Integer> serverArr, long switchInterval) {
        if (conn.getLoginMode() == 1) {
            if (DmdbSwitch.traverseServerList(conn, serverArr, switchInterval, 1)) {
                return true;
            }
        } else if (conn.getLoginMode() == 2) {
            if (DmdbSwitch.traverseServerList(conn, serverArr, switchInterval, 2)) {
                return true;
            }
        } else if (conn.getLoginMode() == 3) {
            if (DmdbSwitch.traverseServerList(conn, serverArr, switchInterval, 2)) {
                return true;
            }
            if (DmdbSwitch.traverseServerList(conn, serverArr, switchInterval, 1)) {
                return true;
            }
        } else {
            if (DmdbSwitch.traverseServerList(conn, serverArr, switchInterval, 1)) {
                return true;
            }
            if (DmdbSwitch.traverseServerList(conn, serverArr, switchInterval, 2)) {
                return true;
            }
        }
        return false;
    }

    private static boolean traverseServerList(DmdbConnection_bs conn, List<Integer> serverArr, long switchInterval, int loginMode) {
        int curSvrIndex = 0;
        if (serverArr != null && serverArr.size() > 0) {
            int i = 0;
            while (i < serverArr.size()) {
                curSvrIndex = serverArr.get(i);
                try {
                    if (i != 0 && switchInterval > 0L) {
                        Thread.sleep(switchInterval);
                    }
                }
                catch (InterruptedException interruptedException) {}
                try {
                    if (DmdbSwitch.tryConnectOneServer(conn, conn.getHosts().get(curSvrIndex), loginMode)) {
                        conn.setServPos(curSvrIndex);
                        return true;
                    }
                }
                catch (Exception exception) {
                    conn.closeDbAccess();
                }
                ++i;
            }
        }
        return false;
    }

    private static boolean tryConnectOneServer(DmdbConnection_bs conn, DmServerInfo tmp, int loginMode) throws IOException, SQLException {
        String host = tmp.getSvrName();
        int port = 0;
        port = tmp.hasPort() ? tmp.getSvrPort() : Integer.valueOf(conn.getProperties().getProperty("port", "5236")).intValue();
        try {
            DbAccess m_dbaccess = new DbAccess(host, port, conn.getProperties(), conn.getConnectTimeout());
            m_dbaccess.setSoTimeout(conn.getSocketTimeout());
            conn.setDbAccess(m_dbaccess);
            tmp.setLastConnSucc(true);
            conn.setStandbyInfo(null, 0);
            DmdbCSI.connToPrimary(conn);
            if (DmdbSwitch.validServerMode(loginMode, conn)) {
                conn.setNetworkPacketSize(m_dbaccess.getNetPacketSize());
                conn.setHost(host);
                conn.setPort(port);
                return true;
            }
        }
        catch (IOException e) {
            conn.closeDbAccess();
            tmp.setLastConnSucc(false);
            throw e;
        }
        conn.closeDbAccess();
        return false;
    }

    public static List<Integer> serverOrderByLastConnSucc(List<DmServerInfo> hosts, int startPos) {
        ArrayList<Integer> succArr = new ArrayList<Integer>(hosts.size());
        ArrayList<Integer> failArr = new ArrayList<Integer>(hosts.size());
        int serverIndex = startPos;
        int i = 0;
        while (i < hosts.size()) {
            if (hosts.get(serverIndex).isLastConnSucc()) {
                succArr.add(serverIndex);
            } else {
                failArr.add(serverIndex);
            }
            serverIndex = (serverIndex + 1) % hosts.size();
            ++i;
        }
        succArr.addAll(failArr);
        return succArr;
    }

    public static List<Integer> serverOrderByLastConnSucc(List<DmServerInfo> hosts, List<Integer> svrArr) {
        ArrayList<Integer> succArr = new ArrayList<Integer>(hosts.size());
        ArrayList<Integer> failArr = new ArrayList<Integer>(hosts.size());
        int i = 0;
        while (i < svrArr.size()) {
            int serverIndex = svrArr.get(i);
            if (hosts.get(serverIndex).isLastConnSucc()) {
                succArr.add(serverIndex);
            } else {
                failArr.add(serverIndex);
            }
            ++i;
        }
        succArr.addAll(failArr);
        return succArr;
    }

    public static boolean validServerMode(int loginMode, DmdbConnection_bs conn) {
        return loginMode == 0 || loginMode == 1 && conn.getSvrMode() != 2 || loginMode == 2 && conn.getSvrMode() == 2 || loginMode == 3;
    }

    private static boolean tryConnectServerListLoadBalance(DmdbConnection_bs conn, ServerGroup.LBResult sgCopy, long switchInterval) {
        return conn.getLoginMode() == 1 ? DmdbSwitch.traverseServerListLoadBalance(conn, sgCopy, switchInterval, 1) : (conn.getLoginMode() == 2 ? DmdbSwitch.traverseServerListLoadBalance(conn, sgCopy, switchInterval, 2) : DmdbSwitch.traverseServerListLoadBalance(conn, sgCopy, switchInterval, conn.getLoginMode()));
    }

    private static boolean traverseServerListLoadBalance(DmdbConnection_bs conn, ServerGroup.LBResult result, long switchInterval, int loginMode) {
        int curSvrIndex = 0;
        List<Integer> serverArr = result.getSvrArr();
        if (serverArr != null && serverArr.size() > 0) {
            int i = 0;
            while (i < serverArr.size()) {
                block9: {
                    curSvrIndex = serverArr.get(i);
                    try {
                        if (i != 0 && switchInterval > 0L) {
                            Thread.sleep(switchInterval);
                        }
                    }
                    catch (InterruptedException interruptedException) {}
                    if (i != 0) {
                        conn.getServerGroup().addSession(curSvrIndex, result.getPlbTs());
                    }
                    if (!DmdbSwitch.tryConnectOneServer(conn, conn.getHosts().get(curSvrIndex), loginMode)) break block9;
                    conn.setServPos(curSvrIndex);
                    return true;
                }
                try {
                    conn.getServerGroup().removeSession(curSvrIndex, result.getPlbTs());
                }
                catch (Exception exception) {
                    conn.closeDbAccess();
                }
                ++i;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doSwitchForLoadBalance(DmdbConnection_bs conn) {
        DmdbConnection_bs dmdbConnection_bs = conn;
        synchronized (dmdbConnection_bs) {
            if (!conn.isLoadBalance() || conn.hasOneSvr() || !conn.getTransFinish() || System.currentTimeMillis() - conn.getCheckLoadBalanceTs() < (long)DmSvcConf.loadBalanceFreq) {
                return;
            }
            conn.setCheckLoadBalanceTs(System.currentTimeMillis());
            ServerGroup serverGroup = conn.getServerGroup();
            ServerGroup.LBResult result = serverGroup.checkLoadBalance(conn, true);
            if (result.isBalance()) {
                return;
            }
            List<Integer> serverArr = result.getSvrArr();
            if (serverArr != null && serverArr.size() > 0) {
                int oldSvrPos = conn.getServPos();
                DbAccess oldDBAccess = conn.getDbAccess();
                DmdbConnection_bs.ConnServAttr oldConnServAttr = conn.getConnServAttr().clone();
                conn.setDbAccess(null);
                if (DmdbSwitch.tryConnectServerListLoadBalance(conn, result, 0L)) {
                    LOG.debug((Object)"DmdbSwitch", "doSwitchForLoadBalance()", "from " + oldDBAccess.getAccessPrimary() + " to " + conn);
                    oldDBAccess.close();
                    conn.resetStatments();
                    conn.setClosed(false);
                    serverGroup.removeSession(oldSvrPos, result.getPlbTs());
                } else {
                    conn.setDbAccess(oldDBAccess);
                    conn.setConnServAttr(oldConnServAttr);
                    conn.setClosed(false);
                }
            }
        }
    }

    public static List<Integer> serverOrderBySessCount(List<DmServerInfo> hosts, int[] sessCounts, int loginMode) {
        LinkedList<Integer> arr = new LinkedList<Integer>();
        int i = 0;
        while (i < hosts.size()) {
            int currentSessCount = sessCounts[i];
            DmdbConnection_bs conn = hosts.get(i).getConn();
            if (conn == null || DmdbSwitch.validServerMode(loginMode, conn)) {
                boolean succ = false;
                int j = 0;
                while (j < arr.size()) {
                    if (currentSessCount < sessCounts[(Integer)arr.get(j)]) {
                        arr.add(j, i);
                        succ = true;
                        break;
                    }
                    ++j;
                }
                if (!succ) {
                    arr.add(i);
                }
            }
            ++i;
        }
        return arr;
    }
}

