/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.dbaccess;

import dm.jdbc.dataConvertion.Convertion;
import dm.jdbc.util.List;
import java.sql.SQLException;

public class DmMsgSend {
    private int nextBufferSize = 32640;
    private List bufferList;
    private BufferNode curNode;
    private List.Node nextNode;
    private List.Node previousNode;
    byte[] initHead = new byte[64];

    public DmMsgSend() {
        this.bufferList = new List();
        this.addBufferNode();
        this.resetCurNode();
    }

    public void cutBufferLen(int len) {
        while (len > 0) {
            int curlen = this.curNode.len;
            if (curlen > len) {
                this.curNode.setBufferLen(curlen - len);
                break;
            }
            this.curNode.reset();
            this.curNode = (BufferNode)this.previousNode.data;
            this.nextNode = this.previousNode.next;
            this.previousNode = this.previousNode.previous;
            len -= curlen;
        }
    }

    public byte[] getFromOffsetWithLen(int offset, int len) {
        BufferNode node = this.findNodeByOffsetForGet(offset);
        int nodeOff = offset - node.preNodesLen;
        byte[] tmp = new byte[len];
        int count = 0;
        int lenToRead = 0;
        while (node != null && len > count) {
            if (count == 0) {
                lenToRead = len - count > node.len - nodeOff ? node.len - nodeOff : len - count;
                System.arraycopy(node.buffer, nodeOff, tmp, count, lenToRead);
            } else {
                lenToRead = len - count > node.len ? node.len : len - count;
                System.arraycopy(node.buffer, 0, tmp, count, lenToRead);
            }
            count += lenToRead;
            if (!this.bufferList.hasNextObject()) break;
            node = (BufferNode)this.bufferList.nextNode();
        }
        return tmp;
    }

    public void replaceFromOffset(int offset, byte[] destBuf) {
        BufferNode node = this.findNodeByOffsetForSet(offset, 0);
        boolean included = false;
        int destLen = destBuf.length;
        if (node.size >= offset + destLen) {
            System.arraycopy(destBuf, 0, node.buffer, offset, destLen);
            node.len = offset - node.preNodesLen + destBuf.length;
            included = true;
        } else {
            node.len = offset - node.preNodesLen;
        }
        this.curNode = node;
        boolean toRemove = false;
        this.bufferList.reset();
        BufferNode nextNode = (BufferNode)this.bufferList.getHead();
        while (nextNode != null) {
            if (!toRemove) {
                if (node == nextNode) {
                    toRemove = true;
                }
                nextNode = this.bufferList.hasNextObject() ? (BufferNode)this.bufferList.nextNode() : null;
            }
            if (!toRemove) continue;
            if (nextNode == null) break;
            if (this.bufferList.isEnd()) {
                nextNode = (BufferNode)this.bufferList.remove();
                break;
            }
            nextNode = (BufferNode)this.bufferList.remove();
        }
        if (!included) {
            node = new BufferNode(destBuf);
            this.bufferList.addLast(node);
            this.curNode = node;
        }
    }

    public List getBufferList() {
        return this.bufferList;
    }

    public byte[] getFirstBuffer() {
        BufferNode node = (BufferNode)this.bufferList.getHead();
        return node.buffer;
    }

    public BufferNode getFirstNode() {
        return (BufferNode)this.bufferList.getHead();
    }

    public BufferNode getNextNode() {
        return (BufferNode)this.bufferList.nextNode();
    }

    public BufferNode getCurNode() {
        return this.curNode;
    }

    public void addBufferNode(int size) {
        int destSize = this.nextBufferSize;
        if (this.bufferList.size() > 0) {
            destSize = this.nextBufferSize * 2;
        }
        if (destSize > 326400) {
            destSize = 326400;
        }
        if (destSize < size) {
            this.curNode = new BufferNode(size);
        } else {
            this.curNode = new BufferNode(destSize);
            this.nextBufferSize = destSize;
        }
        this.previousNode = this.bufferList.getTailNode();
        this.bufferList.addLast(this.curNode);
        this.nextNode = null;
    }

    public void addBufferNode() {
        if (this.bufferList.size() > 0) {
            this.nextBufferSize *= 2;
        }
        if (this.nextBufferSize > 326400) {
            this.nextBufferSize = 326400;
        }
        this.curNode = new BufferNode(this.nextBufferSize);
        this.previousNode = this.bufferList.getTailNode();
        this.bufferList.addLast(this.curNode);
        this.nextNode = null;
    }

    public byte[] getBuffer() {
        return this.curNode.buffer;
    }

    public void resetListPointer() {
        this.bufferList.reset();
    }

    private final void addBufferWhenApp(int len) {
        if (this.curNode.len + len > this.curNode.size) {
            if (this.nextNode == null) {
                this.addBufferNode(len);
            } else {
                List.Node tempNode = this.nextNode;
                this.curNode = (BufferNode)tempNode.data;
                this.previousNode = tempNode.previous;
                this.nextNode = tempNode.next;
            }
        }
    }

    public void appendByte(byte val) {
        this.addBufferWhenApp(1);
        this.fillByte(this.curNode, val, this.curNode.len);
    }

    private final int fillByte(BufferNode node, byte val, int nodeOff) {
        byte[] buffer = node.buffer;
        buffer[nodeOff++] = val;
        if (node.len < nodeOff) {
            node.len = nodeOff;
        }
        return 1;
    }

    public final int appendBytes(byte[] src, int src_offset, int len) {
        this.addBufferWhenApp(len);
        byte[] buffer = this.curNode.buffer;
        int offset = this.curNode.len;
        System.arraycopy(src, src_offset, buffer, offset, len);
        BufferNode bufferNode = this.curNode;
        bufferNode.len = bufferNode.len + len;
        return len;
    }

    public final int appendBytesWithLen2(byte[] src, int src_offset, int len) {
        if (len > 65535) {
            len = 65535;
        }
        byte[] lenBuf = Convertion.shortToByteArray(len);
        this.appendBytes(lenBuf, 0, 2);
        this.appendBytes(src, src_offset, len);
        return len + 2;
    }

    public int appendBytesWithLen4(byte[] src, int src_offset, int len) {
        byte[] lenBuf = Convertion.intToByteArray(len);
        this.appendBytes(lenBuf, 0, 4);
        this.appendBytes(src, src_offset, len);
        return len + 4;
    }

    public int appendOffRowBytes(byte[] src, int src_offset, int blen, boolean new_lob_flag, int clen) {
        int retLen = 0;
        byte[] blenBuf = Convertion.intToByteArray(blen);
        this.appendBytes(blenBuf, 0, 4);
        retLen += 4;
        if (new_lob_flag) {
            byte[] clenBuf = Convertion.intToByteArray(clen);
            this.appendBytes(clenBuf, 0, 4);
            retLen += 4;
        }
        return retLen += this.appendBytes(src, src_offset, blen);
    }

    public final int appendLen2(int len) {
        byte[] lenBuf = Convertion.shortToByteArray(len);
        this.appendBytes(lenBuf, 0, 2);
        return 2;
    }

    private final BufferNode findNodeByOffsetForSet(int offset, int len) {
        int preNodesLen = 0;
        int totalLen = 0;
        int nodesSize = 0;
        int maxOff = offset + len;
        this.bufferList.reset();
        BufferNode node = (BufferNode)this.bufferList.getHead();
        while (node != null) {
            nodesSize = preNodesLen + node.size;
            if (nodesSize >= maxOff) break;
            if (this.bufferList.hasNextObject()) {
                node = (BufferNode)this.bufferList.nextNode();
                node.preNodesLen = (preNodesLen += node.len);
                continue;
            }
            totalLen = node.preNodesLen + node.len;
            node = null;
            break;
        }
        if (node == null) {
            this.addBufferNode(len);
            node = (BufferNode)this.bufferList.getTail();
            node.preNodesLen = totalLen;
        }
        return node;
    }

    private final BufferNode findNodeByOffsetForGet(int offset) {
        int preNodesLen = 0;
        int nodesSize = 0;
        int maxOff = offset;
        this.bufferList.reset();
        BufferNode node = (BufferNode)this.bufferList.getHead();
        while (node != null) {
            nodesSize = preNodesLen + node.len;
            if (nodesSize > maxOff || !this.bufferList.hasNextObject()) break;
            preNodesLen += node.len;
            node = (BufferNode)this.bufferList.nextNode();
        }
        return node;
    }

    public int setBytes(byte[] src, int src_offset, int offset, int len) {
        BufferNode node = this.findNodeByOffsetForSet(offset, len);
        int nodeOff = offset - node.preNodesLen;
        byte[] buffer = node.buffer;
        System.arraycopy(src, src_offset, buffer, nodeOff, len);
        if (node.len < (nodeOff += len)) {
            node.len = nodeOff;
        }
        return len;
    }

    public int setBytesWithLen2(byte[] src, int src_offset, int offset, int len) {
        BufferNode node = this.findNodeByOffsetForSet(offset + 2, len);
        int nodeOff = offset - node.preNodesLen;
        byte[] buffer = node.buffer;
        byte[] lenBuf = Convertion.shortToByteArray(len);
        System.arraycopy(lenBuf, 0, buffer, nodeOff, 2);
        System.arraycopy(src, src_offset, buffer, nodeOff += 2, len);
        if (node.len < (nodeOff += len)) {
            node.len = nodeOff;
        }
        return len + 2;
    }

    public int setBytesWithLen4(byte[] src, int src_offset, int offset, int len) {
        BufferNode node = this.findNodeByOffsetForSet(offset + 4, len);
        int nodeOff = offset - node.preNodesLen;
        byte[] buffer = node.buffer;
        byte[] lenBuf = Convertion.intToByteArray(len);
        System.arraycopy(lenBuf, 0, buffer, nodeOff, lenBuf.length);
        System.arraycopy(src, src_offset, buffer, nodeOff += 4, len);
        if (node.len < (nodeOff += len)) {
            node.len = nodeOff;
        }
        return len + 4;
    }

    public final void setCRC(byte crc) {
        byte[] ret = new byte[]{crc};
        BufferNode node = (BufferNode)this.bufferList.getHead();
        byte[] buffer = node.buffer;
        System.arraycopy(ret, 0, buffer, 19, ret.length);
    }

    public final int setString(String str, String serverEncoding, int offset) throws SQLException {
        byte[] ret = Convertion.getBytes(str, serverEncoding);
        this.setBytes(ret, 0, offset, ret.length);
        return ret.length;
    }

    public final int setString(String str, String serverEncoding) throws SQLException {
        byte[] ret = Convertion.getBytes(str, serverEncoding);
        this.appendBytes(ret, 0, ret.length);
        return ret.length;
    }

    public final int setStringWithNTS(String str, String serverEncoding, int offset) throws SQLException {
        byte[] ret = Convertion.getBytes(str, serverEncoding);
        this.setBytes(ret, 0, offset, ret.length);
        this.setByte((byte)0, offset + ret.length);
        return ret.length + 1;
    }

    public final int setStringWithNTS(String str, String serverEncoding) throws SQLException {
        byte[] ret = Convertion.getBytes(str, serverEncoding);
        byte[] val = new byte[]{0};
        this.appendBytes(ret, 0, ret.length);
        this.appendBytes(val, 0, 1);
        return ret.length + 1;
    }

    public final int setByte(byte val, int offset) {
        BufferNode node = this.findNodeByOffsetForSet(offset, 1);
        int nodeOff = offset - node.preNodesLen;
        this.fillByte(node, val, nodeOff);
        return 1;
    }

    private final int fillShort(BufferNode node, int val, int nodeOff) {
        byte[] buffer = node.buffer;
        buffer[nodeOff++] = (byte)(val & 0xFF);
        buffer[nodeOff++] = (byte)(val >>> 8);
        if (node.len < nodeOff) {
            node.len = nodeOff;
        }
        return 2;
    }

    public final void setShort(int val) {
        this.addBufferWhenApp(2);
        this.fillShort(this.curNode, val, this.curNode.len);
    }

    public final void setShort(int val, int offset) {
        BufferNode node = this.findNodeByOffsetForSet(offset, 2);
        int nodeOff = offset - node.preNodesLen;
        this.fillShort(node, val, nodeOff);
    }

    private final int fillInt(BufferNode node, int val, int nodeOff) {
        byte[] buffer = node.buffer;
        buffer[nodeOff++] = (byte)(val & 0xFF);
        buffer[nodeOff++] = (byte)(val >>> 8 & 0xFF);
        buffer[nodeOff++] = (byte)(val >>> 16 & 0xFF);
        buffer[nodeOff++] = (byte)(val >>> 24 & 0xFF);
        if (node.len < nodeOff) {
            node.len = nodeOff;
        }
        return 4;
    }

    public final void setInt(int val) {
        this.addBufferWhenApp(4);
        this.fillInt(this.curNode, val, this.curNode.len);
    }

    public final void setInt(int val, int offset) {
        BufferNode node = this.findNodeByOffsetForSet(offset, 4);
        int nodeOff = offset - node.preNodesLen;
        this.fillInt(node, val, nodeOff);
    }

    private final int fillLong(BufferNode node, long val, int nodeOff) {
        byte[] buffer = node.buffer;
        buffer[nodeOff++] = (byte)(val & 0xFFL);
        buffer[nodeOff++] = (byte)(val >>> 8);
        buffer[nodeOff++] = (byte)(val >>> 16);
        buffer[nodeOff++] = (byte)(val >>> 24);
        buffer[nodeOff++] = (byte)(val >>> 32);
        buffer[nodeOff++] = (byte)(val >>> 40);
        buffer[nodeOff++] = (byte)(val >>> 48);
        buffer[nodeOff++] = (byte)(val >>> 56);
        if (node.len < nodeOff) {
            node.len = nodeOff;
        }
        return 8;
    }

    public final int appendNumWithLen2(long val, int numLen) throws SQLException {
        this.addBufferWhenApp(2 + numLen);
        this.fillShort(this.curNode, numLen, this.curNode.len);
        switch (numLen) {
            case 1: {
                this.fillByte(this.curNode, (byte)val, this.curNode.len);
                break;
            }
            case 2: {
                this.fillShort(this.curNode, (int)val, this.curNode.len);
                break;
            }
            case 4: {
                this.fillInt(this.curNode, (int)val, this.curNode.len);
                break;
            }
            case 8: {
                this.fillLong(this.curNode, val, this.curNode.len);
                break;
            }
            default: {
                throw new SQLException("Invalid Number value Length");
            }
        }
        return 2 + numLen;
    }

    public final void setLong(long val, int offset) {
        BufferNode node = this.findNodeByOffsetForSet(offset, 8);
        int nodeOff = offset - node.preNodesLen;
        this.fillLong(node, val, nodeOff);
    }

    public void setParamDataLength(int len, int offset) {
        this.setShort(len, offset);
    }

    public void setParamDataLength(int len) {
        this.setShort(len);
    }

    public void setParamData(int offset, byte[] data) {
        this.setBytes(data, 0, offset, data.length);
    }

    public void setParamDataEx(byte[] data) {
        this.appendBytesWithLen2(data, 0, data.length);
    }

    public void resetCurNode() {
        this.bufferList.reset();
        this.curNode = (BufferNode)this.bufferList.getHead();
        this.curNode.reset();
        System.arraycopy(this.initHead, 0, this.curNode.buffer, 0, this.initHead.length);
        this.curNode.len = this.initHead.length;
        this.nextNode = null;
        BufferNode node = null;
        while (this.bufferList.hasNextObject()) {
            if (this.nextNode == null) {
                this.nextNode = this.bufferList.next();
                node = (BufferNode)this.nextNode.data;
            } else {
                node = (BufferNode)this.bufferList.nextNode();
            }
            node.reset();
        }
        this.nextBufferSize = 32640;
    }

    public void clear() {
        this.bufferList.removeAll();
    }

    public void req_startup_set_encrypt_type(int encrypt_type) {
        this.setInt(encrypt_type, 20);
    }

    public void req_startup_set_cmp_flag(int cmp_flag) {
        this.setInt(cmp_flag, 24);
    }

    public void req_startup_set_rs_bdta_flag(byte rs_bdta_flag) {
        this.setByte(rs_bdta_flag, 30);
    }

    public void req_startup_set_comm_enc_flag(byte comm_enc_flag) {
        this.setByte(comm_enc_flag, 29);
    }

    public void req_startup_set_gen_keypair_flag(byte gen_keypair_flag) {
        this.setByte(gen_keypair_flag, 28);
    }

    public void req_login_set_env(int env) {
        this.setInt(env, 20);
    }

    public void req_login_set_iso_level(int isoLevel) {
        this.setInt(isoLevel, 24);
    }

    public void req_login_set_language(int language) {
        this.setInt(language, 28);
    }

    public void req_login_set_read_only(byte readOnly) {
        this.setByte(readOnly, 32);
    }

    public void req_login_set_time_zone(short timeZone) {
        this.setShort(timeZone, 33);
    }

    public void req_login_set_session_timeout(int sessionTimeout) {
        this.setInt(sessionTimeout, 35);
    }

    public void req_login_set_mpp_login_type(byte mppLoginType) {
        this.setByte(mppLoginType, 39);
    }

    public void req_login_set_req_standby_flag(byte req_flag) {
        this.setByte(req_flag, 40);
    }

    public void nmsg_req_login_set_new_lob_flag(byte new_flag) {
        this.setByte(new_flag, 41);
    }

    public void nmsg_req_login_set_login_osauth_type(byte osauth_type) {
        this.setByte(osauth_type, 42);
    }

    public void req_alloc_stmt_set_new_col_desc_flag(byte readBaseDesc) {
        this.setByte(readBaseDesc, 20);
    }

    public void req_prepare_set_auto_cmt(byte autoCmt) {
        this.setByte(autoCmt, 20);
    }

    public void req_prepare_set_exec_direct(byte execDirect) {
        this.setByte(execDirect, 21);
    }

    public byte req_prepare_get_exec_direct() {
        return this.getByte(21);
    }

    public void req_prepare_set_param_sequ(byte paramSequ) {
        this.setByte(paramSequ, 22);
    }

    public void req_prepare_set_cur_forward_only(byte forwardOnly) {
        this.setByte(forwardOnly, 23);
    }

    public void req_prepare_set_check_type(byte checkType) {
        this.setByte(checkType, 24);
    }

    public void req_prepare_set_sql_Type(short sqlType) {
        this.setShort(sqlType, 25);
    }

    public void req_prepare_set_fetch_max(long fetchMax) {
        this.setLong(fetchMax, 27);
    }

    public void req_prepare_set_ret_id_flag(byte flag) {
        this.setByte(flag, 38);
    }

    public void req_prepare_set_rs_bdta_flag(byte rs_bdta_flag) {
        this.setByte(rs_bdta_flag, 35);
    }

    public void req_prepare_set_bdta_len(short bdta_len) {
        this.setShort(bdta_len, 36);
    }

    public void req_prepare_set_query_time_out(int queryTimeout) {
        if (queryTimeout == 0) {
            queryTimeout = -1;
        }
        this.setInt(queryTimeout, 41);
    }

    public void req_execute_set_auto_cmt(byte autoCmt) {
        this.setByte(autoCmt, 20);
    }

    public void req_execute_set_param_num(short paramNum) {
        this.setShort(paramNum, 21);
    }

    public void req_execute_set_cur_forward_only(byte curForwardOnly) {
        this.setByte(curForwardOnly, 23);
    }

    public void req_execute_set_row_num(long rowNum) {
        this.setLong(rowNum, 24);
    }

    public void req_execute_set_cur_pos(long curPos) {
        this.setLong(curPos, 32);
    }

    public void req_execute_set_fetch_max(long fetchMax) {
        this.setLong(fetchMax, 40);
    }

    public void req_execute_set_ret_id_flag(byte flag) {
        this.setByte(flag, 48);
    }

    public void req_execute_set_ign_bp_err(byte ign_bp_err) {
        this.setByte(ign_bp_err, 49);
    }

    public void req_execute_set_query_time_out(int queryTimeout) {
        if (queryTimeout == 0) {
            queryTimeout = -1;
        }
        this.setInt(queryTimeout, 52);
    }

    public final long getInt(int offset) {
        return Convertion.getUInt(this.getFromOffsetWithLen(offset, 4), 0);
    }

    public int getShort(int offset) {
        return Convertion.getUShort(this.getFromOffsetWithLen(offset, 2), 0);
    }

    public byte getByte(int offset) {
        return Convertion.getByte(this.getFromOffsetWithLen(offset, 1), 0);
    }

    public int req_get_len() {
        return (int)this.getInt(6);
    }

    public void req_set_stmtid(int stmtid) {
        this.setInt(stmtid, 0);
    }

    public void req_set_cmd(short cmd) {
        this.setShort(cmd, 4);
    }

    public short req_get_cmd() {
        return (short)this.getShort(4);
    }

    public void req_set_len(int len) {
        this.setInt(len, 6);
    }

    public void req_set_crc(byte crc) {
        this.setByte(crc, 19);
    }

    public void req_set_compress(byte isCompress) {
        this.setByte(isCompress, 18);
    }

    public final byte calculateCRC() {
        byte[] buffer = ((BufferNode)this.bufferList.getHead()).buffer;
        byte crc = buffer[0];
        int times = 19;
        byte single = buffer[1];
        int i = 1;
        while (i < times) {
            single = buffer[i];
            crc = (byte)(crc ^ single);
            i = (byte)(i + 1);
        }
        return crc;
    }

    public void req_preexec_set_param_num(short paramNum) {
        this.setShort(paramNum, 20);
    }

    public void req_putdata_set_para_index(short paraIndex) {
        this.setShort(paraIndex, 20);
    }

    public void req_fetch_set_cur_pos(long curPos) {
        this.setLong(curPos, 20);
    }

    public void req_fetch_set_row_count(long rowCount) {
        this.setLong(rowCount, 28);
    }

    public void req_fetch_set_res_id(short resId) {
        this.setShort(resId, 36);
    }

    public int res_fetch_get_ret_count() {
        return (int)this.getInt(28);
    }

    public void req_moreres_set_res_id(short resId) {
        this.setShort(resId, 20);
    }

    public void req_sess_iso_set_level(int isoLevel) {
        this.setInt(isoLevel, 20);
    }

    public void req_xa_set_xa_type(int xa_type) {
        this.setInt(xa_type, 64);
    }

    public void req_xa_set_xid(int fmtId, int gTran, int bQual, byte[] xid) {
        this.setInt(fmtId, 68);
        this.setInt(gTran, 72);
        this.setInt(bQual, 76);
        this.setBytes(xid, 0, 80, xid.length);
    }

    public void req_xa_set_xa_flag(int flag) {
        this.setInt(flag, 208);
    }

    public class BufferNode {
        byte[] buffer = null;
        private int len = 0;
        private int size = 0;
        private int preNodesLen = 0;

        int getBufferSize() {
            return this.size;
        }

        BufferNode() {
            this.buffer = new byte[32640];
            this.size = 32640;
            this.len = 0;
            this.preNodesLen = 0;
        }

        BufferNode(int nodeSize) {
            this.buffer = new byte[nodeSize];
            this.len = 0;
            this.size = nodeSize;
            this.preNodesLen = 0;
        }

        BufferNode(byte[] destBuf) {
            this.buffer = destBuf;
            this.size = this.len = destBuf.length;
            this.preNodesLen = 0;
        }

        public int getBufferLen() {
            return this.len;
        }

        public void setBufferLen(int reallen) {
            this.len = reallen;
        }

        void reset() {
            this.len = 0;
            this.preNodesLen = 0;
        }

        void clear() {
            this.buffer = null;
            this.len = 0;
            this.size = 0;
            this.preNodesLen = 0;
        }
    }
}

