/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.dataConvertion.binder;

import dm.jdbc.dataConvertion.binder.DmBinder;
import dm.jdbc.dataConvertion.binder.DmNullBinder;
import dm.jdbc.dbaccess.DBError;
import dm.jdbc.dbaccess.DmMsgSend;
import dm.jdbc.driver.DmdbPreparedStatement_bs;
import dm.jdbc.driver.DmdbStatement_bs;
import dm.jdbc.driver.DmdbType;
import dm.sql.TypeDescriptor;
import java.sql.SQLException;

public class DmOutParamBinder
extends DmBinder {
    public DmBinder m_inParamBinder = null;
    DmdbStatement_bs curStmt = null;
    private TypeDescriptor typeDesc;

    public TypeDescriptor getTypeDesc() {
        return this.typeDesc;
    }

    public void setTypeDesc(TypeDescriptor typeDesc) {
        this.typeDesc = typeDesc;
    }

    public DmOutParamBinder(DmdbPreparedStatement_bs pstmt) {
        super(pstmt);
        this.setHasSqlScale(false);
        this.setHasSqlType(false);
    }

    public DmOutParamBinder(DmdbPreparedStatement_bs pstmt, int sqlType) {
        this(pstmt);
        this.setSqlType(sqlType);
        this.setHasSqlType(true);
    }

    public DmOutParamBinder(DmdbPreparedStatement_bs pstmt, int sqlType, int sqlScale) {
        this(pstmt, sqlType);
        this.setSqlScale(sqlScale);
        this.setHasSqlScale(true);
    }

    void init() {
    }

    public void setCursorStmt(DmdbStatement_bs stmt) {
        this.curStmt = stmt;
    }

    void checkType(int irow, int icol, boolean forBatch) throws SQLException {
        if (this.m_checkType) {
            return;
        }
        this.m_checkType = true;
        if (this.paramsDesc == null) {
            this.paramsDesc = this.pstmt.getParamsDesc();
        }
        byte typeFlag = this.paramsDesc[icol].getTypeFlag();
        int dType = this.paramsDesc[icol].getDType();
        int prec = this.paramsDesc[icol].getPrec();
        int scale = this.paramsDesc[icol].getScale();
        byte ioType = this.paramsDesc[icol].getIOType();
        if (typeFlag != 1 && dType == 54) {
            if (this.typeDesc != null) {
                this.destDType = this.typeDesc.getDType();
                this.destScale = this.typeDesc.getScale();
                this.destPrec = this.typeDesc.getPrec();
            } else {
                this.destDType = this.isHasSqlType() ? DmdbType.sqlTypeToDType(this.getSqlType()) : dType;
                this.destScale = this.isHasSqlScale() ? this.getSqlScale() : scale;
                this.destPrec = prec;
            }
        } else {
            this.destDType = dType;
            this.destScale = scale;
            this.destPrec = prec;
            this.typeDesc = this.paramsDesc[icol].getTypeDescriptor();
        }
        this.srcScale = scale;
        this.destIoType = ioType;
        if (this.destIoType == 1 && this.destDType == 120) {
            this.destIoType = (byte)2;
        }
    }

    public int bindDesc(DmMsgSend msg, int irow, int icol, boolean forBatch) throws SQLException {
        this.checkType(irow, icol, forBatch);
        if (this.destIoType == 2 && 120 != this.destDType) {
            DmBinder inBinder = this.m_inParamBinder;
            inBinder.checkType(irow, icol, forBatch);
            this.destDType = inBinder.destDType;
            this.destPrec = inBinder.destPrec;
            this.destScale = inBinder.destScale;
            this.destIoType = inBinder.destIoType;
            this.srcScale = inBinder.srcScale;
        }
        if (this.destIoType == 1 && 120 == this.destDType) {
            msg.appendByte((byte)2);
        } else {
            msg.appendByte(this.destIoType);
        }
        msg.setInt(this.destDType);
        int lprec = 0;
        int lscale = 0;
        boolean isComplex = true;
        switch (this.destDType) {
            case 117: 
            case 122: {
                if (this.typeDesc == null) {
                    DBError.throwSQLException(6037);
                }
                lprec = TypeDescriptor.getPackArraySize(this.typeDesc);
                break;
            }
            case 121: {
                if (this.typeDesc == null) {
                    DBError.throwSQLException(6037);
                }
                lprec = TypeDescriptor.getPackRecordSize(this.typeDesc);
                break;
            }
            case 119: {
                if (this.typeDesc == null) {
                    DBError.throwSQLException(6037);
                }
                lprec = TypeDescriptor.getPackClassSize(this.typeDesc);
                break;
            }
            case 12: {
                if (DmdbType.isComplexType(this.paramsDesc[icol].getDType(), this.paramsDesc[icol].getScale())) {
                    if (this.typeDesc == null) {
                        DBError.throwSQLException(6037);
                    }
                    lprec = this.typeDesc.getObjId();
                } else {
                    lprec = this.destPrec;
                }
                lscale = this.destScale;
                isComplex = false;
                break;
            }
            default: {
                lprec = this.destPrec;
                lscale = this.destScale;
                isComplex = false;
            }
        }
        msg.setInt(lprec);
        msg.setInt(lscale);
        switch (this.destDType) {
            case 117: 
            case 122: {
                TypeDescriptor.packArray(this.typeDesc, msg);
                break;
            }
            case 121: {
                TypeDescriptor.packRecord(this.typeDesc, msg);
                break;
            }
            case 119: {
                TypeDescriptor.packClass(this.typeDesc, msg);
                break;
            }
            default: {
                isComplex = false;
            }
        }
        if (isComplex) {
            return 13 + lprec;
        }
        return 13;
    }

    public int bindData(DmMsgSend msg, int irow, int icol, boolean forBatch) throws SQLException {
        int retLen = 0;
        if (120 == this.destDType) {
            if (this.curStmt == null) {
                DBError.throwSQLException(6048);
            }
            msg.setShort(4);
            msg.setInt(this.curStmt.getHandle());
            retLen = 6;
        } else if (this.destIoType == 2) {
            if (this.m_inParamBinder == null) {
                DBError.throwSQLException(6054);
            }
            this.m_inParamBinder.checkType(irow, icol, forBatch);
            byte isNull = this.pstmt.getNullIndicator(irow, icol);
            retLen = isNull == 1 || this.m_inParamBinder instanceof DmNullBinder ? DmNullBinder.bindData(msg) : this.m_inParamBinder.bindData(msg, irow, icol, forBatch);
        }
        return retLen;
    }

    public void setInoutParamBinder(DmBinder inBinder) throws SQLException {
        if (this.m_inParamBinder == null) {
            this.m_inParamBinder = inBinder;
        } else if (this.m_inParamBinder instanceof DmNullBinder) {
            this.m_inParamBinder = inBinder;
        } else if (inBinder != null && this.m_inParamBinder.getClass() != inBinder.getClass()) {
            throw new SQLException("Different object bound with the first row in the same column");
        }
        this.m_inParamBinder = inBinder;
    }

    public DmBinder getInoutParamBinder() throws SQLException {
        return this.m_inParamBinder;
    }

    public DmdbStatement_bs getCursorStmt() throws SQLException {
        return this.curStmt;
    }

    public void close() {
        if (this.curStmt != null) {
            try {
                this.curStmt.close();
            }
            catch (Exception exception) {}
            this.curStmt = null;
        }
    }
}

