/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hpsf.examples;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.hpsf.PropertySetFactory;
import org.apache.poi.hpsf.SummaryInformation;
import org.apache.poi.poifs.eventfilesystem.POIFSReader;
import org.apache.poi.poifs.eventfilesystem.POIFSReaderEvent;
import org.apache.poi.poifs.eventfilesystem.POIFSReaderListener;

public class ReadTitle {
    public static void main(String[] args) throws IOException {
        String filename = args[0];
        POIFSReader r = new POIFSReader();
        r.registerListener((POIFSReaderListener)new MyPOIFSReaderListener(), "\u0005SummaryInformation");
        r.read((InputStream)new FileInputStream(filename));
    }

    static class MyPOIFSReaderListener
    implements POIFSReaderListener {
        MyPOIFSReaderListener() {
        }

        public void processPOIFSReaderEvent(POIFSReaderEvent event) {
            SummaryInformation si = null;
            try {
                si = (SummaryInformation)PropertySetFactory.create((InputStream)event.getStream());
            }
            catch (Exception ex) {
                throw new RuntimeException("Property set stream \"" + event.getPath() + event.getName() + "\": " + ex);
            }
            String title = si.getTitle();
            if (title != null) {
                System.out.println("Title: \"" + title + "\"");
            } else {
                System.out.println("Document has no title.");
            }
        }
    }
}

