/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ddf;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.ddf.EscherProperty;
import org.apache.poi.ddf.EscherPropertyFactory;
import org.apache.poi.ddf.EscherRecord;
import org.apache.poi.ddf.EscherRecordFactory;
import org.apache.poi.ddf.EscherSerializationListener;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.LittleEndian;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEscherOptRecord
extends EscherRecord {
    protected List<EscherProperty> properties = new ArrayList<EscherProperty>();

    public void addEscherProperty(EscherProperty prop) {
        this.properties.add(prop);
    }

    @Override
    public int fillFields(byte[] data, int offset, EscherRecordFactory recordFactory) {
        int bytesRemaining = this.readHeader(data, offset);
        short propertiesCount = AbstractEscherOptRecord.readInstance(data, offset);
        int pos = offset + 8;
        EscherPropertyFactory f = new EscherPropertyFactory();
        this.properties = f.createProperties(data, pos, propertiesCount);
        return bytesRemaining + 8;
    }

    public List<EscherProperty> getEscherProperties() {
        return this.properties;
    }

    public EscherProperty getEscherProperty(int index) {
        return this.properties.get(index);
    }

    private int getPropertiesSize() {
        int totalSize = 0;
        for (EscherProperty property : this.properties) {
            totalSize += property.getPropertySize();
        }
        return totalSize;
    }

    @Override
    public int getRecordSize() {
        return 8 + this.getPropertiesSize();
    }

    public <T extends EscherProperty> T lookup(int propId) {
        for (EscherProperty prop : this.properties) {
            if (prop.getPropertyNumber() != propId) continue;
            EscherProperty result = prop;
            return (T)result;
        }
        return null;
    }

    @Override
    public int serialize(int offset, byte[] data, EscherSerializationListener listener) {
        listener.beforeRecordSerialize(offset, this.getRecordId(), this);
        LittleEndian.putShort(data, offset, this.getOptions());
        LittleEndian.putShort(data, offset + 2, this.getRecordId());
        LittleEndian.putInt(data, offset + 4, this.getPropertiesSize());
        int pos = offset + 8;
        for (EscherProperty property : this.properties) {
            pos += property.serializeSimplePart(data, pos);
        }
        for (EscherProperty property : this.properties) {
            pos += property.serializeComplexPart(data, pos);
        }
        listener.afterRecordSerialize(pos, this.getRecordId(), pos - offset, this);
        return pos - offset;
    }

    public void sortProperties() {
        Collections.sort(this.properties, new Comparator<EscherProperty>(){

            @Override
            public int compare(EscherProperty p1, EscherProperty p2) {
                short s2;
                short s1 = p1.getPropertyNumber();
                return s1 < (s2 = p2.getPropertyNumber()) ? -1 : (s1 == s2 ? 0 : 1);
            }
        });
    }

    public void setEscherProperty(EscherProperty value) {
        Iterator<EscherProperty> iterator = this.properties.iterator();
        while (iterator.hasNext()) {
            EscherProperty prop = iterator.next();
            if (prop.getId() != value.getId()) continue;
            iterator.remove();
        }
        this.properties.add(value);
        this.sortProperties();
    }

    public void removeEscherProperty(int num) {
        Iterator<EscherProperty> iterator = this.getEscherProperties().iterator();
        while (iterator.hasNext()) {
            EscherProperty prop = iterator.next();
            if (prop.getPropertyNumber() != num) continue;
            iterator.remove();
        }
    }

    public String toString() {
        String nl = System.getProperty("line.separator");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append(":");
        stringBuilder.append(nl);
        stringBuilder.append("  isContainer: ");
        stringBuilder.append(this.isContainerRecord());
        stringBuilder.append(nl);
        stringBuilder.append("  version: 0x");
        stringBuilder.append(HexDump.toHex(this.getVersion()));
        stringBuilder.append(nl);
        stringBuilder.append("  instance: 0x");
        stringBuilder.append(HexDump.toHex(this.getInstance()));
        stringBuilder.append(nl);
        stringBuilder.append("  recordId: 0x");
        stringBuilder.append(HexDump.toHex(this.getRecordId()));
        stringBuilder.append(nl);
        stringBuilder.append("  numchildren: ");
        stringBuilder.append(this.getChildRecords().size());
        stringBuilder.append(nl);
        stringBuilder.append("  properties:");
        stringBuilder.append(nl);
        for (EscherProperty property : this.properties) {
            stringBuilder.append("    " + property.toString() + nl);
        }
        return stringBuilder.toString();
    }

    @Override
    public String toXml(String tab) {
        StringBuilder builder = new StringBuilder();
        builder.append(tab).append(this.formatXmlRecordHeader(this.getClass().getSimpleName(), HexDump.toHex(this.getRecordId()), HexDump.toHex(this.getVersion()), HexDump.toHex(this.getInstance())));
        for (EscherProperty property : this.getEscherProperties()) {
            builder.append(property.toXml(tab + "\t"));
        }
        builder.append(tab).append("</").append(this.getClass().getSimpleName()).append(">\n");
        return builder.toString();
    }
}

