package com.censoft.db;

import com.censoft.common.base.Pub;
import com.censoft.common.db.ConnectionFactory;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import java.util.UUID;

public class DBUtil {
    public static String ADDRLOCAL = "";

    public static Connection getConnection() {
        ConnectionFactory cf = new ConnectionFactory();
        Connection conn = null;
        //if(true)return cf.getConnection();
        InputStream in = null;
        Properties props = new Properties();
        try {
            in = DBUtil.class.getResourceAsStream("db.properties");
            props.load(in);
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            if (in != null) {
                try {
                    in.close();
                } catch (Exception e) {
                }
            }
        }

        String url = props.getProperty("url");
        String user = props.getProperty("user");
        String password = props.getProperty("password");
        String driver = props.getProperty("driver");
        if (driver == "" || password == "" || user == "" || url == "") {
            System.out.println("数据库配置有问题");
            return null;
        }
        if (props != null) {
            props.clear();
        }
        try {
            conn = cf.getConnection(driver, url, user, password);
        } catch (Exception e) {
            return null;
        }
        return conn;
    }
    public static String stringToMD5(String plainText) {
        byte[] secretBytes = null;
        try {
            secretBytes = MessageDigest.getInstance("md5").digest(
                    plainText.getBytes());
        } catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("没有这个md5算法！");
        }
        String md5code = new BigInteger(1, secretBytes).toString(16);
        for (int i = 0; i < 32 - md5code.length(); i++) {
            md5code = "0" + md5code;
        }
        return md5code;
    }

    public static String getUUID() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    /**
     * @param args
     */
    public static void main(String[] args) {
        // TODO Auto-generated method stub
        Connection conn = null;
        try {
            conn = DBUtil.getConnection();
            System.out.println(conn);
        } catch (Exception e) {

        } finally {
            try {
                conn.close();
            } catch (SQLException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }
        }
    }

}
