/*
 * Decompiled with CFR 0.152.
 */
package com.censoft.common.util;

import com.censoft.common.base.Base;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Random;

public class RandomGUID
extends Base {
    public String valueBeforeMD5 = "";
    public String valueAfterMD5 = "";
    private Random myRand;
    private SecureRandom mySecureRand;
    private String s_id;
    private final int PAD_BELOW = 16;
    private final int TWO_BYTES = 255;

    public RandomGUID() {
        this.mySecureRand = new SecureRandom();
        long l = this.mySecureRand.nextLong();
        this.myRand = new Random(l);
        try {
            this.s_id = InetAddress.getLocalHost().toString();
        }
        catch (UnknownHostException unknownHostException) {
            this.setMsg("RandomGUID\u7c7b\u521d\u59cb\u5316\u65f6\u53d1\u751f\u5f02\u5e38\uff1a" + unknownHostException, unknownHostException);
            unknownHostException.printStackTrace();
        }
        this.getRandomGUID(false);
    }

    public RandomGUID(boolean bl) {
        this.getRandomGUID(bl);
    }

    private void getRandomGUID(boolean bl) {
        MessageDigest messageDigest = null;
        StringBuffer stringBuffer = new StringBuffer(128);
        try {
            messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            this.setMsg("\u83b7\u53d6GUID\u65f6\u53d1\u751f\u5f02\u5e38\uff1a" + noSuchAlgorithmException, noSuchAlgorithmException);
        }
        try {
            long l = System.currentTimeMillis();
            long l2 = 0L;
            l2 = bl ? this.mySecureRand.nextLong() : this.myRand.nextLong();
            stringBuffer.append(this.s_id);
            stringBuffer.append(":");
            stringBuffer.append(Long.toString(l));
            stringBuffer.append(":");
            stringBuffer.append(Long.toString(l2));
            this.valueBeforeMD5 = stringBuffer.toString();
            messageDigest.update(this.valueBeforeMD5.getBytes());
            byte[] byArray = messageDigest.digest();
            StringBuffer stringBuffer2 = new StringBuffer(32);
            for (int i = 0; i < byArray.length; ++i) {
                int n = byArray[i] & 0xFF;
                if (n < 16) {
                    stringBuffer2.append('0');
                }
                stringBuffer2.append(Integer.toHexString(n));
            }
            this.valueAfterMD5 = stringBuffer2.toString();
        }
        catch (Exception exception) {
            this.setMsg("\u83b7\u53d6GUID\u65f6\u53d1\u751f\u5f02\u5e38\uff1a" + exception, exception);
        }
    }

    public String toString() {
        String string = this.valueAfterMD5.toUpperCase();
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append(string.substring(0, 8));
        stringBuffer.append("-");
        stringBuffer.append(string.substring(8, 12));
        stringBuffer.append("-");
        stringBuffer.append(string.substring(12, 16));
        stringBuffer.append("-");
        stringBuffer.append(string.substring(16, 20));
        stringBuffer.append("-");
        stringBuffer.append(string.substring(20));
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        for (int i = 0; i < 1; ++i) {
            RandomGUID randomGUID = new RandomGUID();
            System.out.println("Seeding String=" + randomGUID.valueBeforeMD5);
            System.out.println("rawGUID=" + randomGUID.valueAfterMD5);
            System.out.println("RandomGUID=" + randomGUID.toString());
        }
    }
}

