/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.security.level2;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Serializable;
import java.util.Vector;
import org.jacorb.security.level2.SecAttributeManager;
import org.omg.CORBA.LocalObject;
import org.omg.Security.AttributeListHolder;
import org.omg.Security.AttributeType;
import org.omg.Security.AuthenticationStatus;
import org.omg.Security.CommunicationDirection;
import org.omg.Security.InvocationCredentialsType;
import org.omg.Security.SecAttribute;
import org.omg.Security.SecurityFeature;
import org.omg.SecurityLevel2.Credentials;
import org.omg.TimeBase.UtcTHolder;

public class CredentialsImpl
extends LocalObject
implements Credentials,
Serializable {
    private SecAttribute[] my_attributes;
    private short accepting_options_supported;
    private short accepting_options_required;
    private short invocation_options_supported;
    private short invocation_options_required;
    private AuthenticationStatus authStatus = null;
    private InvocationCredentialsType type = null;
    private boolean[] securityFeaturesForRequests;
    private boolean[] securityFeaturesForReplies;
    private SecAttributeManager attrib_mgr = null;
    private boolean dirty = true;

    public CredentialsImpl(SecAttribute[] secAttributeArray, AuthenticationStatus authenticationStatus, InvocationCredentialsType invocationCredentialsType) {
        this.authStatus = authenticationStatus;
        this.my_attributes = secAttributeArray;
        this.type = invocationCredentialsType;
        this.attrib_mgr = SecAttributeManager.getInstance();
    }

    public Credentials copy() {
        try {
            PipedOutputStream pipedOutputStream = new PipedOutputStream();
            PipedInputStream pipedInputStream = new PipedInputStream(pipedOutputStream);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(pipedOutputStream);
            objectOutputStream.writeObject(this);
            objectOutputStream.flush();
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(pipedInputStream);
            CredentialsImpl credentialsImpl = (CredentialsImpl)objectInputStream.readObject();
            objectInputStream.close();
            pipedInputStream.close();
            pipedOutputStream.close();
            return credentialsImpl;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public InvocationCredentialsType credentials_type() {
        return this.type;
    }

    public AuthenticationStatus authentication_state() {
        return this.authStatus;
    }

    public String mechanism() {
        return null;
    }

    public short accepting_options_supported() {
        return this.accepting_options_supported;
    }

    public void accepting_options_supported(short s) {
        this.accepting_options_supported = s;
    }

    public short accepting_options_required() {
        return this.accepting_options_required;
    }

    public void accepting_options_required(short s) {
        this.accepting_options_required = s;
    }

    public short invocation_options_supported() {
        return this.invocation_options_supported;
    }

    public void invocation_options_supported(short s) {
        this.invocation_options_supported = s;
    }

    public short invocation_options_required() {
        return this.invocation_options_required;
    }

    public void invocation_options_required(short s) {
        this.invocation_options_required = s;
    }

    public SecAttribute[] get_attributes(AttributeType[] attributeTypeArray) {
        if (attributeTypeArray == null || attributeTypeArray.length == 0) {
            return this.my_attributes;
        }
        Vector<SecAttribute> vector = new Vector<SecAttribute>();
        for (int i = 0; i < attributeTypeArray.length; ++i) {
            for (int j = 0; j < this.my_attributes.length; ++j) {
                if (this.my_attributes[j].attribute_type.attribute_family.family != attributeTypeArray[i].attribute_family.family || this.my_attributes[j].attribute_type.attribute_type != attributeTypeArray[i].attribute_type) continue;
                vector.addElement(this.my_attributes[j]);
            }
        }
        Object[] objectArray = new SecAttribute[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public void destroy() {
    }

    public void set_security_feature(CommunicationDirection communicationDirection, SecurityFeature[] securityFeatureArray) {
        switch (communicationDirection.value()) {
            case 1: {
                this.setFeatures(this.securityFeaturesForRequests, securityFeatureArray);
            }
            case 2: {
                this.setFeatures(this.securityFeaturesForReplies, securityFeatureArray);
            }
            case 0: {
                this.setFeatures(this.securityFeaturesForRequests, securityFeatureArray);
                this.setFeatures(this.securityFeaturesForReplies, securityFeatureArray);
            }
        }
    }

    private void setFeatures(boolean[] blArray, SecurityFeature[] securityFeatureArray) {
        if (securityFeatureArray.length > blArray.length) {
            throw new IllegalArgumentException("Too many features");
        }
        for (int i = 0; i < securityFeatureArray.length; ++i) {
            int n = securityFeatureArray[i].value();
            if (n > blArray.length || n < 0) {
                throw new IllegalArgumentException("SecurityFeatureValue out of range");
            }
            blArray[n] = true;
        }
    }

    public boolean get_security_feature(CommunicationDirection communicationDirection, SecurityFeature securityFeature) {
        switch (communicationDirection.value()) {
            case 1: {
                return this.securityFeaturesForRequests[securityFeature.value()];
            }
            case 2: {
                return this.securityFeaturesForReplies[securityFeature.value()];
            }
        }
        return this.securityFeaturesForRequests[securityFeature.value()] && this.securityFeaturesForReplies[securityFeature.value()];
    }

    public boolean set_privileges(boolean bl, SecAttribute[] secAttributeArray, AttributeListHolder attributeListHolder) {
        for (int i = 0; i < secAttributeArray.length; ++i) {
            if (this.attrib_mgr.getAttributeValue(secAttributeArray[i]) != null) continue;
            throw new RuntimeException("SecAttribute not created by Manager");
        }
        Vector<SecAttribute> vector = new Vector<SecAttribute>();
        for (int i = 0; i < secAttributeArray.length; ++i) {
            if (secAttributeArray[i].attribute_type.attribute_family.family != 1) continue;
            vector.addElement(secAttributeArray[i]);
        }
        if (vector.size() > 0) {
            SecAttribute[] secAttributeArray2 = new SecAttribute[this.my_attributes.length + vector.size()];
            System.arraycopy(this.my_attributes, 0, secAttributeArray2, 0, this.my_attributes.length);
            for (int i = 0; i < vector.size(); ++i) {
                SecAttribute secAttribute;
                secAttributeArray2[this.my_attributes.length + i] = secAttribute = (SecAttribute)vector.elementAt(i);
            }
            this.my_attributes = secAttributeArray2;
            attributeListHolder.value = secAttributeArray2;
            this.dirty = true;
            return true;
        }
        return false;
    }

    public boolean is_valid(UtcTHolder utcTHolder) {
        return false;
    }

    public boolean refresh(byte[] byArray) {
        return false;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void clearDirtyFlag() {
        this.dirty = false;
    }
}

