/*
 * Decompiled with CFR 0.152.
 */
package org.sitemesh.webapp.contentfilter.io;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Locale;

public class RoutablePrintWriter
extends PrintWriter {
    private PrintWriter destination;
    private DestinationFactory factory;

    public RoutablePrintWriter(DestinationFactory factory) {
        super(new DummyWriter());
        this.factory = factory;
    }

    private PrintWriter getDestination() {
        if (this.destination == null) {
            try {
                this.destination = this.factory.activateDestination();
            }
            catch (IOException e) {
                this.setError();
            }
        }
        return this.destination;
    }

    public void updateDestination(DestinationFactory factory) {
        this.destination = null;
        this.factory = factory;
    }

    public void close() {
        this.getDestination().close();
    }

    public void println(Object x) {
        this.getDestination().println(x);
    }

    public void println(String x) {
        this.getDestination().println(x);
    }

    public void println(char[] x) {
        this.getDestination().println(x);
    }

    public void println(double x) {
        this.getDestination().println(x);
    }

    public void println(float x) {
        this.getDestination().println(x);
    }

    public void println(long x) {
        this.getDestination().println(x);
    }

    public void println(int x) {
        this.getDestination().println(x);
    }

    public void println(char x) {
        this.getDestination().println(x);
    }

    public void println(boolean x) {
        this.getDestination().println(x);
    }

    public void println() {
        this.getDestination().println();
    }

    public void print(Object obj) {
        this.getDestination().print(obj);
    }

    public void print(String s) {
        this.getDestination().print(s);
    }

    public void print(char[] s) {
        this.getDestination().print(s);
    }

    public void print(double d) {
        this.getDestination().print(d);
    }

    public void print(float f) {
        this.getDestination().print(f);
    }

    public void print(long l) {
        this.getDestination().print(l);
    }

    public void print(int i) {
        this.getDestination().print(i);
    }

    public void print(char c) {
        this.getDestination().print(c);
    }

    public void print(boolean b) {
        this.getDestination().print(b);
    }

    public void write(String s) {
        this.getDestination().write(s);
    }

    public void write(String s, int off, int len) {
        this.getDestination().write(s, off, len);
    }

    public void write(char[] buf) {
        this.getDestination().write(buf);
    }

    public void write(char[] buf, int off, int len) {
        this.getDestination().write(buf, off, len);
    }

    public void write(int c) {
        this.getDestination().write(c);
    }

    public boolean checkError() {
        return this.getDestination().checkError();
    }

    public void flush() {
        this.getDestination().flush();
    }

    public PrintWriter printf(String string, Object ... args) {
        this.getDestination().printf(string, args);
        return this;
    }

    public PrintWriter printf(Locale locale, String string, Object ... args) {
        this.getDestination().printf(locale, string, args);
        return this;
    }

    public PrintWriter format(String string, Object ... args) {
        this.getDestination().format(string, args);
        return this;
    }

    public PrintWriter format(Locale locale, String string, Object ... args) {
        this.getDestination().format(locale, string, args);
        return this;
    }

    public PrintWriter append(CharSequence charSequence) {
        this.getDestination().append(charSequence);
        return this;
    }

    public PrintWriter append(CharSequence charSequence, int s, int e) {
        this.getDestination().append(charSequence, s, e);
        return this;
    }

    public PrintWriter append(char c) {
        this.getDestination().append(c);
        return this;
    }

    private static class DummyWriter
    extends Writer {
        protected DummyWriter() {
        }

        public void write(char[] cbuf, int off, int len) throws IOException {
            throw new UnsupportedOperationException();
        }

        public void flush() throws IOException {
            throw new UnsupportedOperationException();
        }

        public void close() throws IOException {
            throw new UnsupportedOperationException();
        }
    }

    public static interface DestinationFactory {
        public PrintWriter activateDestination() throws IOException;
    }
}

