/*
 * Decompiled with CFR 0.152.
 */
package org.sitemesh.config.xml;

import java.util.ArrayList;
import java.util.List;
import org.sitemesh.builder.BaseSiteMeshFilterBuilder;
import org.sitemesh.config.ObjectFactory;
import org.sitemesh.config.xml.Xml;
import org.sitemesh.config.xml.XmlConfigurator;
import org.w3c.dom.Element;

public class XmlFilterConfigurator
extends XmlConfigurator {
    private final Xml xml;

    public XmlFilterConfigurator(ObjectFactory objectFactory, Element siteMeshElement) {
        super(objectFactory, siteMeshElement);
        this.xml = new Xml(siteMeshElement);
    }

    public void configureFilter(BaseSiteMeshFilterBuilder builder) {
        this.configureCommon(builder);
        for (Xml mapping : this.xml.children("mapping")) {
            String path = mapping.child("path").text(mapping.attribute("path", "/*"));
            if (!this.isTrue(mapping.attribute("exclude")) && mapping.children("exclude").isEmpty()) continue;
            builder.addExcludedPath(path);
        }
        List<Xml> mimeTypeTags = this.xml.children("mime-type");
        if (!mimeTypeTags.isEmpty()) {
            ArrayList<String> mimeTypes = new ArrayList<String>();
            for (Xml mimeTypeTag : mimeTypeTags) {
                mimeTypes.add(mimeTypeTag.text());
            }
            builder.setMimeTypes(mimeTypes);
        }
    }

    private boolean isTrue(String string) {
        String lower = string == null ? "" : string.trim().toLowerCase();
        return lower.equals("true") || lower.equals("1") || lower.equals("yes");
    }
}

