/*
 * Decompiled with CFR 0.152.
 */
package org.sitemesh.config.properties;

import java.util.Map;
import org.sitemesh.builder.BaseSiteMeshBuilder;
import org.sitemesh.config.ObjectFactory;
import org.sitemesh.config.properties.PropertiesParser;
import org.sitemesh.content.ContentProcessor;
import org.sitemesh.content.tagrules.TagRuleBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesConfigurator {
    public static final String TAG_RULE_BUNDLES_PARAM = "tagRuleBundles";
    public static final String CONTENT_PROCESSOR_PARAM = "contentProcessor";
    public static final String DECORATOR_MAPPINGS_PARAM = "decoratorMappings";
    private final ObjectFactory objectFactory;
    private final PropertiesParser properties;

    public PropertiesConfigurator(ObjectFactory objectFactory, Map<String, String> properties) {
        this.objectFactory = objectFactory;
        this.properties = new PropertiesParser(properties);
    }

    public void configureCommon(BaseSiteMeshBuilder builder) {
        Map<String, String[]> decoratorsMappings;
        String[] ruleSetNames;
        for (String ruleSetName : ruleSetNames = this.properties.getStringArray(TAG_RULE_BUNDLES_PARAM)) {
            builder.addTagRuleBundle((TagRuleBundle)this.objectFactory.create(ruleSetName));
        }
        String contentProcessorName = this.properties.getString(CONTENT_PROCESSOR_PARAM);
        if (contentProcessorName != null) {
            builder.setCustomContentProcessor((ContentProcessor)this.objectFactory.create(contentProcessorName));
        }
        if ((decoratorsMappings = this.properties.getStringMultiMap(DECORATOR_MAPPINGS_PARAM)) != null) {
            for (Map.Entry<String, String[]> entry : decoratorsMappings.entrySet()) {
                builder.addDecoratorPaths(entry.getKey(), entry.getValue());
            }
        }
    }
}

