/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.stat.support;

import dm.jdbc.stat.StatService;
import dm.jdbc.stat.support.W2uiGridData;
import dm.jdbc.stat.support.json.JSONArray;
import dm.jdbc.stat.support.json.JSONObject;
import dm.jdbc.util.DmJdbcUtil;
import dm.jdbc.util.StringUtil;
import dm.jdbc.util.stat.JSONUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class StatViewServlet
extends HttpServlet {
    public static final String SERVLET_NAME = "dmjdbc";
    protected static String resourcePath = "dm/jdbc/stat/support/resources/";
    public static final int RESULT_CODE_SUCCESS = 1;
    public static final int RESULT_CODE_ERROR = -1;

    public void init() throws ServletException {
        super.init();
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String contextPath = StringUtil.trimToEmpty(request.getContextPath());
        String servletPath = request.getServletPath();
        String requestURI = request.getRequestURI();
        response.setCharacterEncoding("utf-8");
        String uri = String.valueOf(contextPath) + servletPath;
        String path = requestURI.substring(contextPath.length() + servletPath.length());
        if ("".equals(path)) {
            if (contextPath.equals("") || contextPath.equals("/")) {
                response.sendRedirect("/dmjdbc/index.html");
            } else {
                response.sendRedirect("dmjdbc/index.html");
            }
            return;
        }
        if ("/".equals(path)) {
            response.sendRedirect("index.html");
            return;
        }
        if (path.contains(".json")) {
            response.getWriter().print(this.process(path, request));
        } else {
            this.returnResourceFile(path, uri, response);
        }
    }

    protected String process(String url, HttpServletRequest request) {
        Properties params = this.getParameters(request);
        List<Map<String, Object>> sortedArray = StatService.getInstance().service(url, params);
        if (sortedArray != null) {
            return this.returnJSONResult(1, sortedArray, params);
        }
        return this.returnJSONResult(-1, "Do not support this request, please contact with administrator.", null);
    }

    private Properties getParameters(HttpServletRequest request) {
        Properties parmas = new Properties();
        if (request != null) {
            String id;
            JSONArray sort;
            JSONObject reqParams = W2uiGridData.requestToJson(request);
            if (reqParams.has("search")) {
                parmas.put("search", (JSONArray)reqParams.get("search"));
            }
            if (reqParams.has("sort") && (sort = (JSONArray)reqParams.get("sort")).length() > 0 && sort.getJSONObject(0) != null) {
                if (sort.getJSONObject(0).has("field")) {
                    parmas.put("field", sort.getJSONObject(0).get("field"));
                }
                if (sort.getJSONObject(0).has("direction")) {
                    parmas.put("direction", sort.getJSONObject(0).get("direction"));
                }
            }
            if (reqParams.has("pageNum")) {
                parmas.put("pageNum", reqParams.get("pageNum"));
            }
            if (reqParams.has("pageSize")) {
                parmas.put("pageSize", reqParams.get("pageSize"));
            }
            if (StringUtil.isNotEmpty(id = request.getParameter("dataSourceId"))) {
                parmas.put("dataSourceId", id);
            }
            if (StringUtil.isNotEmpty(id = request.getParameter("sqlId"))) {
                parmas.put("sqlId", id);
            }
        }
        return parmas;
    }

    private String returnJSONResult(int resultCode, Object content, Properties parmas) {
        LinkedHashMap<String, Object> dataMap = new LinkedHashMap<String, Object>();
        dataMap.put("ResultCode", resultCode);
        if (content != null) {
            dataMap.put("records", content);
            dataMap.put("total", ((List)content).size());
        } else {
            dataMap.put("records", new ArrayList());
            dataMap.put("total", 0);
        }
        if (parmas != null && parmas.containsKey("pageNum")) {
            dataMap.put("pageNum", parmas.get("pageNum"));
        }
        if (parmas != null && parmas.containsKey("pageCount")) {
            dataMap.put("pageCount", parmas.get("pageCount"));
        }
        if (parmas != null && parmas.containsKey("pageSize")) {
            dataMap.put("pageSize", parmas.get("pageSize"));
        }
        if (parmas != null && parmas.containsKey("totalRowCount")) {
            dataMap.put("totalRowCount", parmas.get("totalRowCount"));
        }
        if (parmas != null && parmas.containsKey("flushFreq")) {
            dataMap.put("flushFreq", parmas.get("flushFreq"));
        }
        return JSONUtils.toJSONString(dataMap);
    }

    protected String getFilePath(String fileName) {
        if (fileName.startsWith("/")) {
            return String.valueOf(resourcePath) + fileName.substring(1);
        }
        return String.valueOf(resourcePath) + fileName;
    }

    protected void returnResourceFile(String fileName, String uri, HttpServletResponse response) throws ServletException, IOException {
        String filePath = this.getFilePath(fileName);
        if (fileName.endsWith(".jpg") || fileName.endsWith(".png")) {
            byte[] bytes = DmJdbcUtil.readByteArrayFromResource(filePath);
            if (bytes != null) {
                response.getOutputStream().write(bytes);
            }
            return;
        }
        String text = DmJdbcUtil.readFromResource(filePath);
        if (text == null) {
            response.setContentType("text/html");
            response.sendRedirect(String.valueOf(uri) + "/index.html");
            return;
        }
        if (fileName.endsWith(".css")) {
            response.setContentType("text/css;charset=utf-8");
        } else if (fileName.endsWith(".js")) {
            response.setContentType("text/javascript;charset=utf-8");
        } else if (fileName.endsWith(".html")) {
            response.setContentType("text/html");
        }
        response.getWriter().write(text);
    }

    public void destroy() {
        super.destroy();
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doPost(req, resp);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doGet(req, resp);
    }
}

