/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.dataConvertion.accessor;

import dm.jdbc.dataConvertion.Convertion;
import dm.jdbc.dataConvertion.accessor.BaseAccessor;
import dm.jdbc.dbaccess.DBError;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LongAccessor
extends BaseAccessor {
    @Override
    public boolean getBoolean() throws SQLException {
        this.getByteArrayValue();
        if (this.wasNull) {
            return false;
        }
        return Convertion.eightByteToLong(this.dataBuffer) != 0L;
    }

    @Override
    public byte getByte() throws SQLException {
        this.getByteArrayValue();
        if (this.wasNull) {
            return 0;
        }
        long result = Convertion.eightByteToLong(this.dataBuffer);
        if (result < -128L || result > 127L) {
            DBError.throwSQLException(6004);
        }
        return (byte)result;
    }

    @Override
    public short getShort() throws SQLException {
        this.getByteArrayValue();
        if (this.wasNull) {
            return 0;
        }
        long result = Convertion.eightByteToLong(this.dataBuffer);
        if (result < -32768L || result > 32767L) {
            DBError.throwSQLException(6004);
        }
        return (short)result;
    }

    @Override
    public int getInt() throws SQLException {
        this.getByteArrayValue();
        if (this.wasNull) {
            return 0;
        }
        long result = Convertion.eightByteToLong(this.dataBuffer);
        if (result < Integer.MIN_VALUE || result > Integer.MAX_VALUE) {
            DBError.throwSQLException(6004);
        }
        return (int)result;
    }

    @Override
    public long getLong() throws SQLException {
        this.getByteArrayValue();
        return this.wasNull ? 0L : Convertion.eightByteToLong(this.dataBuffer);
    }

    @Override
    public float getFloat() throws SQLException {
        this.getByteArrayValue();
        return this.wasNull ? 0L : Convertion.eightByteToLong(this.dataBuffer);
    }

    @Override
    public double getDouble() throws SQLException {
        this.getByteArrayValue();
        return this.wasNull ? 0L : Convertion.eightByteToLong(this.dataBuffer);
    }

    @Override
    public BigDecimal getBigDecimal() throws SQLException {
        this.getByteArrayValue();
        return this.wasNull ? null : new BigDecimal(Convertion.eightByteToLong(this.dataBuffer));
    }

    @Override
    public String getString() throws SQLException {
        this.getByteArrayValue();
        return this.wasNull ? null : String.valueOf(Convertion.eightByteToLong(this.dataBuffer));
    }

    @Override
    Object getObjectInner(Map<String, Class<?>> typeMap) throws SQLException {
        this.getByteArrayValue();
        return this.wasNull ? null : Long.valueOf(Convertion.eightByteToLong(this.dataBuffer));
    }
}

