import request from '@/utils/request'

// 查询安全策略信息列表
export function listPolicy (query) {
  return request({
    url: '/security/policy/list',
    method: 'get',
    params: query
  })
}

// 查询安全策略信息详细
export function getPolicy (id) {
  return request({
    url: '/security/policy/' + id,
    method: 'get'
  })
}

// 新增安全策略信息
export function addPolicy (data) {
  return request({
    url: '/security/policy',
    method: 'post',
    data: data
  })
}

// 修改安全策略信息
export function updatePolicy (data) {
  return request({
    url: '/security/policy',
    method: 'put',
    data: data
  })
}

// 删除安全策略信息
export function delPolicy (id) {
  return request({
    url: '/security/policy/' + id,
    method: 'delete'
  })
}

// 导出安全策略信息
export function exportPolicy (query) {
  return request({
    url: '/security/policy/export',
    method: 'get',
    params: query
  })
}

export function savePolicy (data) {
  return request({
    url: '/security/policy/save',
    method: 'post',
    data: data
  })
}

// 不可匿名访问的接口

export function getPolicyByType (type) {
  return request({
    url: '/security/policy/getPolicyByType/' + type,
    method: 'get'
  })
}
// 可匿名访问的接口
export function getAnonPolicyByType (type) {
  return request({
    url: '/security/policy/getAnonPolicyByType?type=' + type,
    method: 'get'
  })
}
