import request from '@/utils/request'

// 查询安全策略信息-IP黑白名单列表
export function listIp (query) {
  return request({
    url: '/security/ip/list',
    method: 'get',
    params: query
  })
}

// 查询安全策略信息-IP黑白名单详细
export function getIp (id) {
  return request({
    url: '/security/ip/' + id,
    method: 'get'
  })
}

// 新增安全策略信息-IP黑白名单
export function addIp (data) {
  return request({
    url: '/security/ip',
    method: 'post',
    data: data
  })
}

// 修改安全策略信息-IP黑白名单
export function updateIp (data) {
  return request({
    url: '/security/ip',
    method: 'put',
    data: data
  })
}

// 删除安全策略信息-IP黑白名单
export function delIp (id) {
  return request({
    url: '/security/ip/' + id,
    method: 'delete'
  })
}

// 导出安全策略信息-IP黑白名单
export function exportIp (query) {
  return request({
    url: '/security/ip/export',
    method: 'get',
    params: query
  })
}

// 查询安全策略信息-IP黑白名单详细
export function getInfoByIP() {
  return request({
    url: '/security/ip/getInfoByIP',
    method: 'get',
  })
}
