import request from '@/utils/request'

const userApi = {
  Login: '/login',
  Logout: '/logout',
  Register: '/register',
  // get my info
  UserInfo: '/getInfo'
}

/**
 * login func
 * @param parameter
 * @returns {*}
 */
export function login (parameter) {
  return request({
    url: userApi.Login,
    method: 'post',
    data: parameter
  })
}
// 钉钉登录
export function DDLogins (a) {
  return request({
    url: userApi.Login + `?code=${a}`,
    method: 'get'
  })
}

// 注册方法
export function register (data) {
  return request({
    url: userApi.Register,
    headers: {
      isToken: false
    },
    method: 'post',
    data: data
  })
}

export function getInfo () {
  return request({
    url: userApi.UserInfo,
    method: 'get',
    headers: {
      'Content-Type': 'application/json;charset=UTF-8'
    }
  })
}

export function logout () {
  return request({
    url: userApi.Logout,
    method: 'get',
    headers: {
      'Content-Type': 'application/json;charset=UTF-8'
    }
  })
}

// 获取验证码
export function getCodeImg () {
  return request({
    url: '/captchaImage',
    method: 'get'
  })
}

export function authCode (query) {
  return request({
    url: '/dd/auth?authCode=' + query,
    method: 'get'
  })
}
// 业务系统跳转判断
export function verificationLogin (data) {
  return request({
    url: '/verification/verificationLogin',
    method: 'post',
    data
  })
}
// 用户名密码登录方式验证
export function CAVerifyLogin (userInfo) {
  const data = {
    'username': userInfo.username,
    'password': userInfo.password
  }
  return request({
    url: '/backmanage/caUserLogin/xtUserLogin',
    method: 'post',
    data: data
  })
}

/**
 *CA用户登陆之后查询当前用户的注册系统权限
 * */
export function getUserSystemByRole () {
  return request({
    url: '/system/inside/getUserSystemByRole',
    method: 'get'
    //   data: parameter
  })
}

export function cassss (a, b, c) {
  return request({
    url: `/casCenter/casCen?username=${a}&password=${b}&joinsysCode=${c}`,
    method: 'get'
  })
}

export function getCALoginUserInfo (parameter) {
  return request({
    url: '/backmanage/caUserLogin/getCALoginUserInfo',
    method: 'get',
    data: parameter
  })
}
