import request from '@/utils/request'

// 查询业务系统访问记录列表
export function listLoginfo (query) {
  return request({
    url: '/log/bsLoginfo/list',
    method: 'get',
    params: query
  })
}

// 查询业务系统访问记录详细
export function getLoginfo (id) {
  return request({
    url: '/log/bsLoginfo/' + id,
    method: 'get'
  })
}

// 新增业务系统访问记录
export function addLoginfo (data) {
  return request({
    url: '/log/bsLoginfo',
    method: 'post',
    data: data
  })
}

// 修改业务系统访问记录
export function updateLoginfo (data) {
  return request({
    url: '/log/bsLoginfo',
    method: 'put',
    data: data
  })
}

// 删除业务系统访问记录
export function delLoginfo (id) {
  return request({
    url: '/log/bsLoginfo/' + id,
    method: 'delete'
  })
}

// 导出业务系统访问记录
export function exportLoginfo (query) {
  return request({
    url: '/log/bsLoginfo/export',
    method: 'get',
    params: query
  })
}

// 首页工作台 统计信息
export function getOverview () {
  return request({
    url: '/log/bsLoginfo/getOverview',
    method: 'get'
  })
}

// 首页工作台 变动信息
export function getAddInfo () {
  return request({
    url: '/log/bsLoginfo/getAddInfo',
    method: 'get'
  })
}

// 首页工作台 业务系统访问量
export function getBSVisits () {
  return request({
    url: '/log/bsLoginfo/getBSVisits',
    method: 'get'
  })
}
