import { axios } from '@/utils/request'

const api = {
    organization: '/system/dept',
    user: '/system/user',
    group: '/system/group'
}
/* 组织机构授权 */

// 勾选回显
export function organizationChecked (deptId) {
    return axios({
        url: api.organization + '/authDeptInsideSystemId/?deptId=' + deptId,
        method: 'get'
    })
}

// 授权
export function organizationEmpower (data) {
    return axios({
        url: api.organization + '/authDeptInside',
        method: 'post',
        data: data
    })
}
// 取消授权
export function organizationEmpowerRemove (data) {
    return axios({
        url: api.organization + '/delAuthDeptInside',
        method: 'post',
        data: data
    })
}
/* 用户授权 */

// 勾选回显
export function userChecked (deptId) {
    return axios({
        url: api.user + '/authUserInsideSystemId/?userId=' + deptId,
        method: 'get'
    })
}

// 授权
export function userEmpower (data) {
    return axios({
        url: api.user + '/authUserInside',
        method: 'post',
        data: data
    })
}
// 取消授权
export function userEmpowerRemove (data) {
    return axios({
        url: api.user + '/delAuthUserInside',
        method: 'post',
        data: data
    })
}
/* 用户组授权 */

// 勾选回显
export function groupChecked (deptId) {
    return axios({
        url: api.group + '/authGroupInsideSystemId/?groupId=' + deptId,
        method: 'get'
    })
}

// 授权
export function groupEmpower (data) {
    return axios({
        url: api.group + '/authGroupInside',
        method: 'post',
        data: data
    })
}
// 取消授权
export function groupEmpowerRemove (data) {
    return axios({
        url: api.group + '/delAuthGroupInside',
        method: 'post',
        data: data
    })
}
