import { axios } from '@/utils/request'

const api = {
  consulateInfo: '/backmanage/consulateUser'
}

export function getConsulateInfoList (parameter) {
  return axios({
    url: api.consulateInfo + '/list',
    method: 'get',
    params: parameter
  })
}

export function saveConsulateInfo (parameter) {
  return axios({
    url: api.consulateInfo + (parameter.id === 0 ? '/save' : '/update'),
    method: 'post',
    data: parameter,
    headers: {
      'Content-Type': 'application/json;charset=UTF-8'
    }
  })
}
//校验教育处名称是否唯一
export function countByIdAndEducationName (parameter) {
  return axios({
    url: api.consulateInfo + '/countByEducationName',
    method: 'post',
    params: parameter
  })
}
//校验用户名是否唯一
export function countByIdAndUserName (parameter) {
  return axios({
    url: api.consulateInfo + '/countByUserName',
    method: 'post',
    params: parameter
  })
}
export const consulateInfoExport = api.consulateInfo + '/export'
