import request from '@/utils/request'

// 查询树结构
export function getClassTreeApi() {
  return request({
    url: '/system/ClassificationManagement/tree',
    method: 'get'
  })
}

export function getModelListApi(data) {
  return request({
    url: '/system/ModelManagement/list',
		method: 'post',
		data
  })
}
export function addModel(data) {
  return request({
    url: '/system/ModelManagement/save',
		method: 'post',
		data
  })
}
export function updateModel(data) {
  return request({
    url: '/system/ModelManagement/update',
		method: 'post',
		data
  })
}
export function removeModelApi(data) {
  return request({
    url: '/system/ModelManagement/remove',
		method: 'post',
		data
  })
}
// 创建数据表

export function createTableApi(params) {
  return request({
    url: '/system/ModelManagement/createTable',
		method: 'get',
		params
  })
}
// 确认创建表
export function createTableAgainApi(params) {
  return request({
    url: '/system/ModelManagement/createTableAgain',
		method: 'get',
		params
  })
}

// 确认创建表
export function deleteDropTable(data) {
  return request({
    url: '/system/ModelManagement/dropTable',
		method: 'post',
		data
  })
}
// 模型下载
export function downLoadTemplate() {
  return request({
    url: `/system/ModelManagement/downLoadTemplate`,
    method: 'get'
  })
}
// 模板下载
export function modelExport() {
  return request({
    url: `/system/ModelManagement/export`,
    method: 'get'
  })
}
// 模版导入
export function fileImport(data) {
  return request({
    url: `/system/ModelManagement/fileImport`,
    method: 'post',
    data
  })
}
// 模版导入确定按钮
export function tempToModel() {
  return request({
    url: `/system/ModelManagement/tempToModel`,
    method: 'get'
  })
}
// 模版导入取消按钮
export function deleteTemp() {
  return request({
    url: `/system/ModelManagement/deleteTemp`,
    method: 'get'
  })
}

// 模型名称 模型代码唯一性校验
export function checkUniqueModel(data) {
  return request({
    url: '/system/ModelManagement/checkUniqueModel',
		method: 'post',
		data
  })
}
