import request from '@/utils/request'

// 卡片数据
export function getList(params) {
  return request({
    url: '/system/ModelManagement/listAttr',
    method: 'get',
    params
  })
}

// 卡片置顶
export function modelTop(data) {
  return request({
    url: '/system/ModelManagement/stickyOperation',
    method: 'post',
    data
  })
}
// 属性列表
export function getAttributeApi(data) {
  return request({
    url: '/project/attrManaTemp/list',
    method: 'post',
    data
  })
}
//
export function getRandomCodeApi() {
  return request({
    url: '/project/attrManaTemp/randomCode',
    method: 'get'
  })
}

// 属性新增
export function addAttr(data) {
  return request({
    url: '/project/attrManaTemp/add',
    method: 'post',
    data
  })
}
// 属性修改
export function editAttr(data) {
  return request({
    url: '/project/attrManaTemp/edit',
    method: 'post',
    data
  })
}

// 属性新增
export function checkUnique(data) {
  return request({
    url: '/project/attrManaTemp/checkUnique',
    method: 'post',
    data
  })
}

// 属性信息(编辑回显)
export function getAttributeDetail(id) {
  return request({
    url: `/project/attrManaTemp/getInfo/${id}`,
    method: 'get'
  })
}

// 属性批量删除
export function removeModel(data) {
  return request({
    url: `/project/attrManaTemp/remove`,
    method: 'post',
    data
  })
}

// 属性批量关闭开启
export function changeStatus(data) {
  return request({
    url: `/project/attrManaTemp/enableAttr`,
    method: 'post',
    data
  })
}
