package com.ruoyi.algorithm.mapper;

import java.util.List;
import com.ruoyi.algorithm.domain.AlgorithmPieceVariable;

/**
 * 策略算法块所需参数Mapper接口
 * 
 * @author ruoyi
 * @date 2023-04-26
 */
public interface AlgorithmPieceVariableMapper 
{
    /**
     * 查询策略算法块所需参数
     * 
     * @param algorithmPieceBaseId 策略算法块所需参数主键
     * @return 策略算法块所需参数
     */
    public AlgorithmPieceVariable selectAlgorithmPieceVariableByAlgorithmPieceBaseId(Long algorithmPieceBaseId);

    /**
     * 查询策略算法块所需参数列表
     * 
     * @param algorithmPieceVariable 策略算法块所需参数
     * @return 策略算法块所需参数集合
     */
    public List<AlgorithmPieceVariable> selectAlgorithmPieceVariableList(AlgorithmPieceVariable algorithmPieceVariable);

    /**
     * 新增策略算法块所需参数
     * 
     * @param algorithmPieceVariable 策略算法块所需参数
     * @return 结果
     */
    public int insertAlgorithmPieceVariable(AlgorithmPieceVariable algorithmPieceVariable);

    /**
     * 修改策略算法块所需参数
     * 
     * @param algorithmPieceVariable 策略算法块所需参数
     * @return 结果
     */
    public int updateAlgorithmPieceVariable(AlgorithmPieceVariable algorithmPieceVariable);

    /**
     * 删除策略算法块所需参数
     * 
     * @param algorithmPieceBaseId 策略算法块所需参数主键
     * @return 结果
     */
    public int deleteAlgorithmPieceVariableByAlgorithmPieceBaseId(Long algorithmPieceBaseId);

    /**
     * 批量删除策略算法块所需参数
     * 
     * @param algorithmPieceBaseIds 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteAlgorithmPieceVariableByAlgorithmPieceBaseIds(Long[] algorithmPieceBaseIds);
}
