package com.ruoyi.algorithm.mapper;

import java.util.List;
import com.ruoyi.algorithm.domain.AlgorithmBaseType;

/**
 * 算法预警类型Mapper接口
 * 
 * @author ruoyi
 * @date 2023-04-26
 */
public interface AlgorithmBaseTypeMapper 
{
    /**
     * 查询算法预警类型
     * 
     * @param algorithmId 算法预警类型主键
     * @return 算法预警类型
     */
    public AlgorithmBaseType selectAlgorithmBaseTypeByAlgorithmId(Long algorithmId);

    /**
     * 查询算法预警类型列表
     * 
     * @param algorithmBaseType 算法预警类型
     * @return 算法预警类型集合
     */
    public List<AlgorithmBaseType> selectAlgorithmBaseTypeList(AlgorithmBaseType algorithmBaseType);

    /**
     * 新增算法预警类型
     * 
     * @param algorithmBaseType 算法预警类型
     * @return 结果
     */
    public int insertAlgorithmBaseType(AlgorithmBaseType algorithmBaseType);

    /**
     * 修改算法预警类型
     * 
     * @param algorithmBaseType 算法预警类型
     * @return 结果
     */
    public int updateAlgorithmBaseType(AlgorithmBaseType algorithmBaseType);

    /**
     * 删除算法预警类型
     * 
     * @param algorithmId 算法预警类型主键
     * @return 结果
     */
    public int deleteAlgorithmBaseTypeByAlgorithmId(Long algorithmId);

    /**
     * 批量删除算法预警类型
     * 
     * @param algorithmIds 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteAlgorithmBaseTypeByAlgorithmIds(Long[] algorithmIds);
}
