package com.ruoyi.algorithm.domain;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;

/**
 * 策略算法块所需参数对象 algorithm_piece_variable
 * 
 * @author ruoyi
 * @date 2023-04-26
 */
public class AlgorithmPieceVariable
{
    private static final long serialVersionUID = 1L;

    /** 算法块主键id */
    private Long algorithmPieceBaseId;

    /** 参数唯一标识 */
    private String variableKey;

    /** 参数名称 */
    @Excel(name = "参数名称")
    private String variableName;

    /** 参数类型 */
    @Excel(name = "参数类型")
    private String variableType;

    public void setAlgorithmPieceBaseId(Long algorithmPieceBaseId) 
    {
        this.algorithmPieceBaseId = algorithmPieceBaseId;
    }

    public Long getAlgorithmPieceBaseId() 
    {
        return algorithmPieceBaseId;
    }
    public void setVariableKey(String variableKey) 
    {
        this.variableKey = variableKey;
    }

    public String getVariableKey() 
    {
        return variableKey;
    }
    public void setVariableName(String variableName) 
    {
        this.variableName = variableName;
    }

    public String getVariableName() 
    {
        return variableName;
    }
    public void setVariableType(String variableType) 
    {
        this.variableType = variableType;
    }

    public String getVariableType() 
    {
        return variableType;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("algorithmPieceBaseId", getAlgorithmPieceBaseId())
            .append("variableKey", getVariableKey())
            .append("variableName", getVariableName())
            .append("variableType", getVariableType())
            .toString();
    }
}
