package com.ruoyi.algorithm.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;

import com.ruoyi.algorithm.domain.dto.AlgorithmCameraListDto;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.algorithm.domain.AlgorithmCameraBase;
import com.ruoyi.algorithm.service.IAlgorithmCameraBaseService;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.common.core.page.TableDataInfo;

/**
 * 算法摄像头Controller
 * 
 * @author ruoyi
 * @date 2023-04-26
 */
@RestController
@RequestMapping("/system/algorithm/camera/base")
public class AlgorithmCameraBaseController extends BaseController
{
    @Autowired
    private IAlgorithmCameraBaseService algorithmCameraBaseService;

    /**
     * 查询算法摄像头列表
     */
    @PreAuthorize("@ss.hasPermi('system:algorithmCamera:list')")
    @GetMapping("/list")
    public TableDataInfo list(AlgorithmCameraBase algorithmCameraBase)
    {
        startPage();
        List<AlgorithmCameraListDto> list = algorithmCameraBaseService.selectAlgorithmCameraListDto(algorithmCameraBase);
        return getDataTable(list);
    }

    /**
     * 查询算法摄像头列表
     */
    @PreAuthorize("@ss.hasPermi('system:algorithmCamera:list')")
    @GetMapping("/list/all")
    public AjaxResult listAll(AlgorithmCameraBase algorithmCameraBase)
    {
        return success(algorithmCameraBaseService.selectAlgorithmCameraBaseList(algorithmCameraBase));
    }

    /**
     * 获取算法摄像头详细信息
     */
    @PreAuthorize("@ss.hasPermi('system:algorithmCamera:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(algorithmCameraBaseService.selectAlgorithmCameraBaseById(id));
    }

    /**
     * 新增算法摄像头
     */
    @PreAuthorize("@ss.hasPermi('system:algorithmCamera:add')")
    @Log(title = "算法摄像头", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody AlgorithmCameraBase algorithmCameraBase)
    {
        algorithmCameraBase.setCreateBy(getUsername());
        return toAjax(algorithmCameraBaseService.insertAlgorithmCameraBase(algorithmCameraBase));
    }

    /**
     * 修改算法摄像头
     */
    @PreAuthorize("@ss.hasPermi('system:algorithmCamera:edit')")
    @Log(title = "算法摄像头", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody AlgorithmCameraBase algorithmCameraBase)
    {
        algorithmCameraBase.setUpdateBy(getUsername());
        return toAjax(algorithmCameraBaseService.updateAlgorithmCameraBase(algorithmCameraBase));
    }

    /**
     * 删除算法摄像头
     */
    @PreAuthorize("@ss.hasPermi('system:algorithmCamera:remove')")
    @Log(title = "算法摄像头", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(algorithmCameraBaseService.deleteAlgorithmCameraBaseByIds(ids));
    }
}
