package com.ruoyi.algorithm.service.impl;

import java.util.List;

import com.ruoyi.algorithm.domain.dto.AlgorithmPieceListDto;
import com.ruoyi.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ruoyi.algorithm.mapper.AlgorithmPieceBaseMapper;
import com.ruoyi.algorithm.domain.AlgorithmPieceBase;
import com.ruoyi.algorithm.service.IAlgorithmPieceBaseService;

/**
 * 策略算法块Service业务层处理
 * 
 * @author ruoyi
 * @date 2023-04-26
 */
@Service
public class AlgorithmPieceBaseServiceImpl implements IAlgorithmPieceBaseService 
{
    @Autowired
    private AlgorithmPieceBaseMapper algorithmPieceBaseMapper;

    /**
     * 查询策略算法块
     * 
     * @param id 策略算法块主键
     * @return 策略算法块
     */
    @Override
    public AlgorithmPieceBase selectAlgorithmPieceBaseById(Long id)
    {
        return algorithmPieceBaseMapper.selectAlgorithmPieceBaseById(id);
    }

    /**
     * 查询策略算法块列表
     * 
     * @param algorithmPieceBase 策略算法块
     * @return 策略算法块
     */
    @Override
    public List<AlgorithmPieceBase> selectAlgorithmPieceBaseList(AlgorithmPieceBase algorithmPieceBase)
    {
        return algorithmPieceBaseMapper.selectAlgorithmPieceBaseList(algorithmPieceBase);
    }

    /**
     * 新增策略算法块
     * 
     * @param algorithmPieceBase 策略算法块
     * @return 结果
     */
    @Override
    public int insertAlgorithmPieceBase(AlgorithmPieceBase algorithmPieceBase)
    {
        algorithmPieceBase.setCreateTime(DateUtils.getNowDate());
        return algorithmPieceBaseMapper.insertAlgorithmPieceBase(algorithmPieceBase);
    }

    /**
     * 修改策略算法块
     * 
     * @param algorithmPieceBase 策略算法块
     * @return 结果
     */
    @Override
    public int updateAlgorithmPieceBase(AlgorithmPieceBase algorithmPieceBase)
    {
        algorithmPieceBase.setUpdateTime(DateUtils.getNowDate());
        return algorithmPieceBaseMapper.updateAlgorithmPieceBase(algorithmPieceBase);
    }

    /**
     * 批量删除策略算法块
     * 
     * @param ids 需要删除的策略算法块主键
     * @return 结果
     */
    @Override
    public int deleteAlgorithmPieceBaseByIds(Long[] ids)
    {
        return algorithmPieceBaseMapper.deleteAlgorithmPieceBaseByIds(ids);
    }

    /**
     * 删除策略算法块信息
     * 
     * @param id 策略算法块主键
     * @return 结果
     */
    @Override
    public int deleteAlgorithmPieceBaseById(Long id)
    {
        return algorithmPieceBaseMapper.deleteAlgorithmPieceBaseById(id);
    }

    @Override
    public List<AlgorithmPieceListDto> selectAlgorithmPieceListDto(AlgorithmPieceBase algorithmPieceBase) {
        return algorithmPieceBaseMapper.selectAlgorithmPieceListDto(algorithmPieceBase);
    }
}
