package com.ruoyi.algorithm.domain;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;

/**
 * 算法摄像头对象 algorithm_camera_base
 * 
 * @author ruoyi
 * @date 2023-04-26
 */
public class AlgorithmCameraBase extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主键id */
    private Long id;

    /** 摄像头名 */
    @Excel(name = "摄像头名")
    private String cameraName;

    /** 摄像头视频流地址 */
    @Excel(name = "摄像头视频流地址")
    private String rtsp;

    /** 排序 */
    @Excel(name = "排序")
    private Long sort;

    /** 帐号状态（0正常 */
    @Excel(name = "帐号状态", readConverterExp = "帐号状态（0正常")
    private String status;

    /** 删除标志（0代表存在 */
    private String delFlag;

    public void setId(Long id) 
    {
        this.id = id;
    }

    public Long getId() 
    {
        return id;
    }
    public void setCameraName(String cameraName) 
    {
        this.cameraName = cameraName;
    }

    public String getCameraName() 
    {
        return cameraName;
    }
    public void setRtsp(String rtsp) 
    {
        this.rtsp = rtsp;
    }

    public String getRtsp() 
    {
        return rtsp;
    }
    public void setSort(Long sort) 
    {
        this.sort = sort;
    }

    public Long getSort() 
    {
        return sort;
    }
    public void setStatus(String status) 
    {
        this.status = status;
    }

    public String getStatus() 
    {
        return status;
    }
    public void setDelFlag(String delFlag) 
    {
        this.delFlag = delFlag;
    }

    public String getDelFlag() 
    {
        return delFlag;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("cameraName", getCameraName())
            .append("rtsp", getRtsp())
            .append("sort", getSort())
            .append("status", getStatus())
            .append("delFlag", getDelFlag())
            .append("createBy", getCreateBy())
            .append("createTime", getCreateTime())
            .append("updateBy", getUpdateBy())
            .append("updateTime", getUpdateTime())
            .append("remark", getRemark())
            .toString();
    }
}
