package com.ruoyi.algorithm.domain;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;

/**
 * 算法对象 algorithm_base
 * 
 * @author ruoyi
 * @date 2023-04-26
 */
public class AlgorithmBase extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主键id */
    private Long id;

    /** 算法名 */
    @Excel(name = "算法名")
    private String algorithmName;

    /** 算法唯一标识 */
    @Excel(name = "算法唯一标识")
    private String algorithmKey;

    /** 排序 */
    @Excel(name = "排序")
    private Long sort;

    /** 帐号状态（0正常 */
    @Excel(name = "帐号状态", readConverterExp = "帐号状态（0正常")
    private String status;

    /** 删除标志（0代表存在 */
    private String delFlag;

    public void setId(Long id) 
    {
        this.id = id;
    }

    public Long getId() 
    {
        return id;
    }
    public void setAlgorithmName(String algorithmName) 
    {
        this.algorithmName = algorithmName;
    }

    public String getAlgorithmName() 
    {
        return algorithmName;
    }
    public void setAlgorithmKey(String algorithmKey) 
    {
        this.algorithmKey = algorithmKey;
    }

    public String getAlgorithmKey() 
    {
        return algorithmKey;
    }
    public void setSort(Long sort) 
    {
        this.sort = sort;
    }

    public Long getSort() 
    {
        return sort;
    }
    public void setStatus(String status) 
    {
        this.status = status;
    }

    public String getStatus() 
    {
        return status;
    }
    public void setDelFlag(String delFlag) 
    {
        this.delFlag = delFlag;
    }

    public String getDelFlag() 
    {
        return delFlag;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("algorithmName", getAlgorithmName())
            .append("algorithmKey", getAlgorithmKey())
            .append("sort", getSort())
            .append("status", getStatus())
            .append("delFlag", getDelFlag())
            .append("createBy", getCreateBy())
            .append("createTime", getCreateTime())
            .append("updateBy", getUpdateBy())
            .append("updateTime", getUpdateTime())
            .append("remark", getRemark())
            .toString();
    }
}
