package com.ruoyi.algorithm.service.impl;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ruoyi.algorithm.mapper.AlgorithmPieceVariableMapper;
import com.ruoyi.algorithm.domain.AlgorithmPieceVariable;
import com.ruoyi.algorithm.service.IAlgorithmPieceVariableService;

/**
 * 策略算法块所需参数Service业务层处理
 * 
 * @author ruoyi
 * @date 2023-04-26
 */
@Service
public class AlgorithmPieceVariableServiceImpl implements IAlgorithmPieceVariableService 
{
    @Autowired
    private AlgorithmPieceVariableMapper algorithmPieceVariableMapper;

    /**
     * 查询策略算法块所需参数
     * 
     * @param algorithmPieceBaseId 策略算法块所需参数主键
     * @return 策略算法块所需参数
     */
    @Override
    public AlgorithmPieceVariable selectAlgorithmPieceVariableByAlgorithmPieceBaseId(Long algorithmPieceBaseId)
    {
        return algorithmPieceVariableMapper.selectAlgorithmPieceVariableByAlgorithmPieceBaseId(algorithmPieceBaseId);
    }

    /**
     * 查询策略算法块所需参数列表
     * 
     * @param algorithmPieceVariable 策略算法块所需参数
     * @return 策略算法块所需参数
     */
    @Override
    public List<AlgorithmPieceVariable> selectAlgorithmPieceVariableList(AlgorithmPieceVariable algorithmPieceVariable)
    {
        return algorithmPieceVariableMapper.selectAlgorithmPieceVariableList(algorithmPieceVariable);
    }

    /**
     * 新增策略算法块所需参数
     * 
     * @param algorithmPieceVariable 策略算法块所需参数
     * @return 结果
     */
    @Override
    public int insertAlgorithmPieceVariable(AlgorithmPieceVariable algorithmPieceVariable)
    {
        return algorithmPieceVariableMapper.insertAlgorithmPieceVariable(algorithmPieceVariable);
    }

    /**
     * 修改策略算法块所需参数
     * 
     * @param algorithmPieceVariable 策略算法块所需参数
     * @return 结果
     */
    @Override
    public int updateAlgorithmPieceVariable(AlgorithmPieceVariable algorithmPieceVariable)
    {
        return algorithmPieceVariableMapper.updateAlgorithmPieceVariable(algorithmPieceVariable);
    }

    /**
     * 批量删除策略算法块所需参数
     * 
     * @param algorithmPieceBaseIds 需要删除的策略算法块所需参数主键
     * @return 结果
     */
    @Override
    public int deleteAlgorithmPieceVariableByAlgorithmPieceBaseIds(Long[] algorithmPieceBaseIds)
    {
        return algorithmPieceVariableMapper.deleteAlgorithmPieceVariableByAlgorithmPieceBaseIds(algorithmPieceBaseIds);
    }

    /**
     * 删除策略算法块所需参数信息
     * 
     * @param algorithmPieceBaseId 策略算法块所需参数主键
     * @return 结果
     */
    @Override
    public int deleteAlgorithmPieceVariableByAlgorithmPieceBaseId(Long algorithmPieceBaseId)
    {
        return algorithmPieceVariableMapper.deleteAlgorithmPieceVariableByAlgorithmPieceBaseId(algorithmPieceBaseId);
    }
}
