package com.ruoyi.algorithm.service.impl;

import java.util.List;

import com.ruoyi.algorithm.domain.dto.AlgorithmBaseListDto;
import com.ruoyi.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ruoyi.algorithm.mapper.AlgorithmBaseMapper;
import com.ruoyi.algorithm.domain.AlgorithmBase;
import com.ruoyi.algorithm.service.IAlgorithmBaseService;

/**
 * 算法Service业务层处理
 * 
 * @author ruoyi
 * @date 2023-04-26
 */
@Service
public class AlgorithmBaseServiceImpl implements IAlgorithmBaseService 
{
    @Autowired
    private AlgorithmBaseMapper algorithmBaseMapper;

    /**
     * 查询算法
     * 
     * @param id 算法主键
     * @return 算法
     */
    @Override
    public AlgorithmBase selectAlgorithmBaseById(Long id)
    {
        return algorithmBaseMapper.selectAlgorithmBaseById(id);
    }

    /**
     * 查询算法列表
     * 
     * @param algorithmBase 算法
     * @return 算法
     */
    @Override
    public List<AlgorithmBase> selectAlgorithmBaseList(AlgorithmBase algorithmBase)
    {
        return algorithmBaseMapper.selectAlgorithmBaseList(algorithmBase);
    }

    /**
     * 新增算法
     * 
     * @param algorithmBase 算法
     * @return 结果
     */
    @Override
    public int insertAlgorithmBase(AlgorithmBase algorithmBase)
    {
        algorithmBase.setCreateTime(DateUtils.getNowDate());
        return algorithmBaseMapper.insertAlgorithmBase(algorithmBase);
    }

    /**
     * 修改算法
     * 
     * @param algorithmBase 算法
     * @return 结果
     */
    @Override
    public int updateAlgorithmBase(AlgorithmBase algorithmBase)
    {
        algorithmBase.setUpdateTime(DateUtils.getNowDate());
        return algorithmBaseMapper.updateAlgorithmBase(algorithmBase);
    }

    /**
     * 批量删除算法
     * 
     * @param ids 需要删除的算法主键
     * @return 结果
     */
    @Override
    public int deleteAlgorithmBaseByIds(Long[] ids)
    {
        return algorithmBaseMapper.deleteAlgorithmBaseByIds(ids);
    }

    /**
     * 删除算法信息
     * 
     * @param id 算法主键
     * @return 结果
     */
    @Override
    public int deleteAlgorithmBaseById(Long id)
    {
        return algorithmBaseMapper.deleteAlgorithmBaseById(id);
    }

    @Override
    public List<AlgorithmBaseListDto> selectAlgorithmBaseListDto(AlgorithmBase algorithmBase) {
        return algorithmBaseMapper.selectAlgorithmBaseListDto(algorithmBase);
    }
}
