package com.ruoyi.algorithm.service;

import java.util.List;
import com.ruoyi.algorithm.domain.AlgorithmBaseType;

/**
 * 算法预警类型Service接口
 * 
 * @author ruoyi
 * @date 2023-04-26
 */
public interface IAlgorithmBaseTypeService 
{
    /**
     * 查询算法预警类型
     * 
     * @param algorithmId 算法预警类型主键
     * @return 算法预警类型
     */
    public AlgorithmBaseType selectAlgorithmBaseTypeByAlgorithmId(Long algorithmId);

    /**
     * 查询算法预警类型列表
     * 
     * @param algorithmBaseType 算法预警类型
     * @return 算法预警类型集合
     */
    public List<AlgorithmBaseType> selectAlgorithmBaseTypeList(AlgorithmBaseType algorithmBaseType);

    /**
     * 新增算法预警类型
     * 
     * @param algorithmBaseType 算法预警类型
     * @return 结果
     */
    public int insertAlgorithmBaseType(AlgorithmBaseType algorithmBaseType);

    /**
     * 修改算法预警类型
     * 
     * @param algorithmBaseType 算法预警类型
     * @return 结果
     */
    public int updateAlgorithmBaseType(AlgorithmBaseType algorithmBaseType);

    /**
     * 批量删除算法预警类型
     * 
     * @param algorithmIds 需要删除的算法预警类型主键集合
     * @return 结果
     */
    public int deleteAlgorithmBaseTypeByAlgorithmIds(Long[] algorithmIds);

    /**
     * 删除算法预警类型信息
     * 
     * @param algorithmId 算法预警类型主键
     * @return 结果
     */
    public int deleteAlgorithmBaseTypeByAlgorithmId(Long algorithmId);
}
