package com.ruoyi.algorithm.mapper;

import java.util.List;
import com.ruoyi.algorithm.domain.AlgorithmScenePiece;
import com.ruoyi.algorithm.domain.dto.AlgorithmPieceDetailsDto;
import org.apache.ibatis.annotations.Param;

/**
 * 场景算法块Mapper接口
 * 
 * @author ruoyi
 * @date 2023-04-26
 */
public interface AlgorithmScenePieceMapper 
{
    /**
     * 查询场景算法块
     * 
     * @param sceneId 场景算法块主键
     * @return 场景算法块
     */
    public AlgorithmScenePiece selectAlgorithmScenePieceBySceneId(Long sceneId);

    /**
     * 查询场景算法块列表
     * 
     * @param algorithmScenePiece 场景算法块
     * @return 场景算法块集合
     */
    public List<AlgorithmScenePiece> selectAlgorithmScenePieceList(AlgorithmScenePiece algorithmScenePiece);

    /**
     * 新增场景算法块
     * 
     * @param algorithmScenePiece 场景算法块
     * @return 结果
     */
    public int insertAlgorithmScenePiece(AlgorithmScenePiece algorithmScenePiece);

    /**
     * 修改场景算法块
     * 
     * @param algorithmScenePiece 场景算法块
     * @return 结果
     */
    public int updateAlgorithmScenePiece(AlgorithmScenePiece algorithmScenePiece);

    /**
     * 删除场景算法块
     * 
     * @param sceneId 场景算法块主键
     * @return 结果
     */
    public int deleteAlgorithmScenePieceBySceneId(Long sceneId);

    /**
     * 批量删除场景算法块
     * 
     * @param sceneIds 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteAlgorithmScenePieceBySceneIds(Long[] sceneIds);

    List<AlgorithmPieceDetailsDto> selectAlgorithmPieceDetailsDtoBySceneId(@Param("sceneId") Long sceneId);
}
