package com.ruoyi.algorithm.mapper;

import java.util.List;
import com.ruoyi.algorithm.domain.AlgorithmSceneBase;
import com.ruoyi.algorithm.domain.dto.AlgorithmSceneListDto;

/**
 * 算法场景Mapper接口
 * 
 * @author ruoyi
 * @date 2023-04-26
 */
public interface AlgorithmSceneBaseMapper 
{
    /**
     * 查询算法场景
     * 
     * @param id 算法场景主键
     * @return 算法场景
     */
    public AlgorithmSceneBase selectAlgorithmSceneBaseById(Long id);

    /**
     * 查询算法场景列表
     * 
     * @param algorithmSceneBase 算法场景
     * @return 算法场景集合
     */
    public List<AlgorithmSceneBase> selectAlgorithmSceneBaseList(AlgorithmSceneBase algorithmSceneBase);

    /**
     * 新增算法场景
     * 
     * @param algorithmSceneBase 算法场景
     * @return 结果
     */
    public int insertAlgorithmSceneBase(AlgorithmSceneBase algorithmSceneBase);

    /**
     * 修改算法场景
     * 
     * @param algorithmSceneBase 算法场景
     * @return 结果
     */
    public int updateAlgorithmSceneBase(AlgorithmSceneBase algorithmSceneBase);

    /**
     * 删除算法场景
     * 
     * @param id 算法场景主键
     * @return 结果
     */
    public int deleteAlgorithmSceneBaseById(Long id);

    /**
     * 批量删除算法场景
     * 
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteAlgorithmSceneBaseByIds(Long[] ids);

    List<AlgorithmSceneListDto> selectAlgorithmSceneListDto(AlgorithmSceneBase algorithmSceneBase);
}
